package dressing.ui.cam.parts;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.part.EditorPart;


import dressing.model.Piece2D;
import dressing.cam.model.PlanUsinage;

import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.FillLayout;

import java.util.HashMap;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.management.DescriptorKey;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import java.util.function.Consumer;
import org.eclipse.swt.events.SelectionEvent;

public class GcodeEditorPart extends EditorPart {
	private DataBindingContext m_bindingContext;

	public static final String ID = "dressing.ui.cam.parts.GcodeEditorPart"; //$NON-NLS-1$
	private Text txtGcodeEditor;
	@Inject
	MPart part;
	@Inject
	private EHandlerService handlerService;
	@Inject
	private EModelService modelService;
	@Inject
	private ECommandService commandService;
	boolean dirty=false;
	Piece2D piece;
	PlanUsinage perspective=PlanUsinage.FRONT;
	Action saveAction=new Action ("Save") {
         public void run() {
       	  ParameterizedCommand cmd = commandService.createCommand("org.eclipse.ui.file.save", null);                        	
       	  handlerService.executeHandler(cmd);
         };
	};
	 Action exportgcodeAction=new Action ("Export Gcode") {
     	public void run() {
     		ParameterizedCommand cmd = commandService.createCommand("dressing.command.saveas", null);                        	
     		handlerService.executeHandler(cmd);
     	};
		};
	ModifyListener modifyListener=new ModifyListener() {
		
		@Override
		public void modifyText(ModifyEvent e) {
			GcodeEditorPart.this.setDirty(true);
			part.setDirty(true);
		}
	};
	public GcodeEditorPart() {
		   super();
	}

	/**
	 * Create contents of the editor part.
	 * @param parent
	 */
	@Override
	@PostConstruct
	public void createPartControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		txtGcodeEditor = new Text(container, SWT.BORDER | SWT.WRAP | SWT.H_SCROLL | SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		txtGcodeEditor.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				 
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				 if (e.stateMask == SWT.CTRL && e.keyCode == 'a') {
					  txtGcodeEditor.selectAll();
			            e.doit = false;
			        }
				 if (e.stateMask == SWT.CTRL && e.keyCode == 's') {
					 saveAction.run();
			        }
				 if (e.stateMask == (SWT.CTRL|SWT.SHIFT) && e.keyCode == 's') {
					 exportgcodeAction.run();
			        }
			}
		});
		txtGcodeEditor.setText("/*      gcode editor part */");
		piece =  (Piece2D) part.getTransientData().get("piece");
		//
		String face = this.perspective.toString();
		String s=(String) piece.get("gcode_"+face);
		if(s==null ||s.isEmpty()) {
			s= "(     gcode editor part )";
			piece.put("gcode_"+face, s);
		}
		piece.setGcode(s);
		//
		m_bindingContext = initDataBindings();
		txtGcodeEditor.addModifyListener(modifyListener);
	}

	
	public Piece2D getPiece() {
		return piece;
	}

	public void setPiece(Piece2D piece) {
		this.piece = piece;
	}

	public static String getId() {
		return ID;
	}

	@Override
	public void setFocus() {
		txtGcodeEditor.setFocus();
	}

	public PlanUsinage getPerspective() {
		return perspective;
	}

	public void setPerspective(PlanUsinage perspective) {
		//save old
		String oldface = this.perspective.toString();
		String s1=(String) piece.get("gcode_"+oldface);
		if(s1==null) {
			s1= "(     gcode editor part )";
			piece.put("gcode_"+oldface,s1);
		}
		piece.put("gcode_"+oldface,piece.getGcode());
		
		txtGcodeEditor.removeModifyListener(modifyListener);
		//read new 
		String face=perspective.toString();

		String s=(String) piece.get("gcode_"+face);
		if(s==null) {
			s= "(     gcode editor part )";
			piece.put("gcode_"+face, s);
		}
		this.perspective = perspective;
		m_bindingContext.dispose();
		m_bindingContext = null;		
		piece.setGcode(s);
		m_bindingContext = initDataBindings();
		txtGcodeEditor.addModifyListener(modifyListener);
	}

	@Override
	@Persist
	public void doSave(IProgressMonitor monitor) {
		part.setDirty(false);
		this.dirty=false;
	}

	@Override	
	public void doSaveAs() {
	}

	@Override
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		// Initialize the editor part
		piece =  (Piece2D) part.getTransientData().get("piece");
		
	}

	@Override
	public boolean isDirty() {
		return dirty;
	}
	
	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}
	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}
	
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtGcodeEditorObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtGcodeEditor);
		IObservableValue gcodePieceObserveValue = BeanProperties.value("gcode").observe(piece);
		bindingContext.bindValue(observeTextTxtGcodeEditorObserveWidget, gcodePieceObserveValue, null, null);
		//
		return bindingContext;
	}
	
	
	@Override
	public boolean equals(Object obj) {
		if(obj instanceof GcodeEditorPart) {
			return	((GcodeEditorPart)obj).getPiece().equals(this.getPiece());
		}
		return super.equals(obj);
	}
	
	@PreDestroy
	public void dispose() {
		m_bindingContext.dispose();
		if(this.piece !=null) {
			this.piece.setGcode("");
		}
		super.dispose();
	}
	
	
	public Text getTxtGcodeEditor() {
		return txtGcodeEditor;
	}
}
