package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import dressing.model.Tirroir;
import dressing.model.evalutor.Equation;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;

public class TiroirDebitageFormulas extends DebitageFormulas{

	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		//
		if(parent instanceof Space3D && child instanceof Tirroir ) {
			Space3D space=(Space3D)parent;
			Tirroir tiroir=(Tirroir)child;
			TirroirType tiroirType=	tiroir.getTiroirType();
			TiroireFacadeType facadeType = tiroir.getTiroireFacadeType();
			FILL_TIRROIR_FROM_PARENT(space,equations);
			switch (tiroirType) {
			case  CLASSIC:
				ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", ""+tiroir.getHauteurext(), Equation.CALCULATION_FIRST_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @Parent.epaisseursecondaire@ - @usin.dosRainurePositionOffset@ - @usin.jeurainuredos@", Equation.CALCULATION_FIRST_AUTO,equations) ;
				//
				
				ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
				ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
				
				//
				ADDOrUpdateEquation("@this.epaisseursecondaire@", ""+tiroir.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.epaisseurprincipale@", ""+tiroir.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.epaisseurfacade@", ""+tiroir.getFacadeMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;			
				//
				if(tiroir.getTiroireFacadeType().equals(TiroireFacadeType.FACADE_EXTERIEUR_TIROIR)) {
					ADDOrUpdateEquation("@this.pi@", "@this.p@ ", Equation.CALCULATION_AUTO,equations);
				}else {
					ADDOrUpdateEquation("@this.pi@", "@Parent.pi@ - @this.epaisseurfacade@ - @Parent.epaisseursecondaire@ - @usin.dosRainurePositionOffset@ - @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
				}
				//
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posxi@", "@this.posx@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", ""+tiroir.getYpos(), Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@ + @Parent.epaisseursecondaire@ + @usin.dosRainurePositionOffset@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;		

				break;
			case  METABOX:
				ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", ""+tiroir.getHauteurext(), Equation.CALCULATION_FIRST_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @Parent.epaisseursecondaire@ - @usin.dosRainurePositionOffset@ - @usin.jeurainuredos@ -@usin.tiroirjeuDeriere@ -@retrait.bascaissoncuisine@", Equation.CALCULATION_FIRST_AUTO,equations) ;
				//
				
				ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
				ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
				
				//
				ADDOrUpdateEquation("@this.epaisseursecondaire@", ""+tiroir.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.epaisseurprincipale@", ""+tiroir.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.epaisseurfacade@", ""+tiroir.getFacadeMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;			
				//
				if(tiroir.getTiroireFacadeType().equals(TiroireFacadeType.FACADE_EXTERIEUR_TIROIR)) {
					ADDOrUpdateEquation("@this.pi@", "@this.p@ ", Equation.CALCULATION_AUTO,equations);
				}else {
					ADDOrUpdateEquation("@this.pi@", "@Parent.pi@ - @this.epaisseurfacade@ - @Parent.epaisseursecondaire@ - @usin.dosRainurePositionOffset@ - @usin.jeurainuredos@ -@usin.tiroirjeuDeriere@ -@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
				}
				//
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posxi@", "@this.posx@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", ""+tiroir.getYpos(), Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@ + @Parent.epaisseursecondaire@ + @usin.dosRainurePositionOffset@ + @usin.jeurainuredos@ +@usin.tiroirjeuDeriere@ +@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;		

				break;
			case  TENDENBOX:
				ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", ""+tiroir.getHauteurext(), Equation.CALCULATION_FIRST_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @Parent.epaisseursecondaire@ - @usin.dosRainurePositionOffset@ - @usin.jeurainuredos@ -@usin.tiroirjeuDeriere@ -@retrait.bascaissoncuisine@", Equation.CALCULATION_FIRST_AUTO,equations) ;
				//
				
				ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
				ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
				
				//
				ADDOrUpdateEquation("@this.epaisseursecondaire@", ""+tiroir.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.epaisseurprincipale@", ""+tiroir.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.epaisseurfacade@", ""+tiroir.getFacadeMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;			
				//
				if(tiroir.getTiroireFacadeType().equals(TiroireFacadeType.FACADE_EXTERIEUR_TIROIR)) {
					ADDOrUpdateEquation("@this.pi@", "@this.p@ ", Equation.CALCULATION_AUTO,equations);
				}else {
					ADDOrUpdateEquation("@this.pi@", "@Parent.pi@ - @this.epaisseurfacade@ - @Parent.epaisseursecondaire@ - @usin.dosRainurePositionOffset@ - @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
				}
				//
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posxi@", "@this.posx@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", ""+tiroir.getYpos(), Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@ + @Parent.epaisseursecondaire@ + @usin.dosRainurePositionOffset@ + @usin.jeurainuredos@ +@usin.tiroirjeuDeriere@ +@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;		

				break;	
			default:
				break;
			}
		}
		
		
	}
	
	
	
	private void FILL_TIRROIR_FROM_PARENT(Space3D space,ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@Parent.l@", ""+space.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.p@", ""+space.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+space.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.li@", ""+space.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.pi@", ""+space.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.hi@", ""+space.getHauteurint(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+space.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+space.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.posx@", ""+space.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+space.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+space.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		

	}
}
