package dressing.model;

import java.awt.image.BufferedImage;
import java.util.List;

import dressing.model.types.CuisineCaissonType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;
import dressing.model.usinage.Usinage;
import tech.frsdev.solids.Solide3D;

public class BlocTirroir extends CaissonCuisine{
	private TirroirType tiroirType=TirroirType.TENDENBOX;	
	private TiroireFacadeType facadetype=TiroireFacadeType.FACADE_EXTERIEUR_TIROIR;
	
	/**
	 * @return the facadetype
	 */
	public TiroireFacadeType getFacadetype() {
		return facadetype;
	}

	/**
	 * @param facadetype the facadetype to set
	 */
	public void setFacadetype(TiroireFacadeType facadetype) {
		TiroireFacadeType oldValue=this.facadetype;
		this.facadetype = facadetype;
		firePropertyChange("facadetype", oldValue, this.facadetype);
		
	}
	
	@Override
	public boolean canHold(DesignObject3D child) {
		if(child instanceof Tirroir || child instanceof Piece2D
				|| child instanceof Accessoire || child instanceof Usinage)
		{
			return true;
		}
		return false;
	}

	public TirroirType getTiroirType() {
		return tiroirType;
	}

	public void setTiroirType(TirroirType tiroirType) {
		TirroirType oldValue=this.tiroirType;
		this.tiroirType = tiroirType;
		firePropertyChange("tiroirType", oldValue, this.tiroirType);	
	}

	@Override
	public boolean isdrawable() {
		return false;
	}

	@Override
	public CuisineCaissonType getCaissoncuisineType() {
		return CuisineCaissonType.Bloc_Tiroir;
	}


}
