package supercad.p2.update;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class UpdateHandler {

	 private static String REPOSITORY_LOC = "https://cadp2site.webdemo.frsdev.ovh/apps/demotycho/update/";
		//private static String REPOSITORY_LOC = "";
		private IWorkbench workbench;

		    public static void setBuildNumber(String lastbuildNumber) {
		        REPOSITORY_LOC = "https://cadp2site.webdemo.frsdev.ovh/apps/demotycho/update/" + lastbuildNumber;
		        //REPOSITORY_LOC = getP2UpdateSiteUrl() + lastbuildNumber;
//		    	String REPOSITORY_LOC = Platform.getDebugOption("URL_P2_SITE_UPDATE");
		        System.out.println("URL de mise à jour configurée : " + REPOSITORY_LOC);
		        System.out.println("URL de mise à jour configurée : " + REPOSITORY_LOC);
		    }

		    public void execute(final IProvisioningAgent agent, IWorkbench workbench) {
		        this.workbench = workbench;
		        System.out.println("Début du processus de mise à jour");
		        Job updateJob = Job.create("Recherche de mises à jour", monitor -> {
		            IStatus status = performUpdates(agent, monitor);
		            if (!status.isOK()) {
		                Display.getDefault().asyncExec(() -> 
		                    MessageDialog.openError(null, "Erreur", "Échec de la mise à jour: " + status.getMessage())
		                );
		            }
		        });
		        updateJob.schedule();
		    }

		    private IStatus performUpdates(final IProvisioningAgent agent, IProgressMonitor monitor) {
		        final ProvisioningSession session = new ProvisioningSession(agent);
		        final UpdateOperation operation = new UpdateOperation(session);

		        try {
		            URI uri = new URI(REPOSITORY_LOC);
		            operation.getProvisioningContext().setArtifactRepositories(uri);
		            operation.getProvisioningContext().setMetadataRepositories(uri);

		            final IStatus status = operation.resolveModal(monitor);

		            if (status.getCode() == UpdateOperation.STATUS_NOTHING_TO_UPDATE) {
		                Display.getDefault().asyncExec(() -> 
		                    MessageDialog.openInformation(null, "Mise à jour", "Aucune mise à jour disponible.")
		                );
		                return Status.CANCEL_STATUS;
		            }

		            boolean userConfirmed = Display.getDefault().syncCall(() -> 
		                MessageDialog.openQuestion(
		                    null, 
		                    "Mise à jour disponible", 
		                    "Une mise à jour est disponible. Voulez-vous l'installer ?"
		                )
		            );

		            if (!userConfirmed) {
		                return Status.CANCEL_STATUS;
		            }

		            ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
		            if (provisioningJob == null) {
		                return Status.CANCEL_STATUS;
		            }

		            configureProvisioningJob(provisioningJob);
		            provisioningJob.schedule();
		            return Status.OK_STATUS;

		        } catch (URISyntaxException e) {
		            throw new OperationCanceledException("Emplacement du dépôt invalide: " + REPOSITORY_LOC);
		        }
		    }

		    private void configureProvisioningJob(ProvisioningJob provisioningJob) {
		        provisioningJob.addJobChangeListener(new JobChangeAdapter() {
		            @Override
		            public void done(IJobChangeEvent event) {
		                if (event.getResult().isOK()) {
		                    System.out.println("Mise à jour terminée avec succès, redémarrage de l'application...");
		                    Display.getDefault().asyncExec(() -> {
		                        // Demander confirmation avant redémarrage
		                        boolean restartConfirmed = MessageDialog.openQuestion(
		                            null,
		                            "Redémarrage nécessaire",
		                            "La mise à jour a été installée avec succès.\n" +
		                            "L'application doit redémarrer pour appliquer les changements.\n\n" +
		                            "Redémarrer maintenant ?"
		                        );
		                        
		                        if (restartConfirmed) {
		                            workbench.restart();
		                        }
		                    });
		                } else {
		                    Display.getDefault().asyncExec(() -> 
		                        MessageDialog.openError(
		                            null, 
		                            "Erreur", 
		                            "Échec de l'installation de la mise à jour:\n" + 
		                            event.getResult().getMessage()
		                        )
		                    );
		                }
		            }
		        });
		    }
}
