package dressing.ui.library;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import dressing.controller.EtagereCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.Caisson;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;

public class ImportModelWelcomePage extends WizardPage {
	PropertyChangeListener pcl;
	boolean serrorfound = true;
	boolean terrorfound = true;
	Cuisine cuisine;
	Space3D caisson;
	LibraryModelsTree modelTreeComposite;
	String caissonName;
	ISelectionChangedListener selectlistener;
	public ImportModelWelcomePage(String pageName, Cuisine cuisine) {
		super(pageName);
		setTitle("Model information");
		setDescription("S'il vous plais entrer le nom de votre model");
		setPageComplete(false);
		setCuisine(cuisine);
	}

	@Override
	public void createControl(Composite parent) {
		modelTreeComposite = new LibraryModelsTree(parent, SWT.BORDER);
		setCaissonName(getCuisine().getName());
		modelTreeComposite.setCaissonName(getCaissonName());
		setControl(modelTreeComposite);
		selectlistener =new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				  IStructuredSelection selection = (IStructuredSelection) event.getSelection();
			    if(selection!=null &&selection.size()==1
			    		&&( selection.getFirstElement() instanceof Caisson|| selection.getFirstElement() instanceof Space3DFree)) {
			    	caisson=(Space3D) selection.getFirstElement();
			    	setCaissonName(caisson.getName());
					modelTreeComposite.setCaissonName(caisson.getName());
			    	serrorfound = false;
			    	setPageComplete(true);
			    }else {
			    	serrorfound = true;
			    	setPageComplete(false);
			    }
			}
		};
		modelTreeComposite.addSelectionListner(selectlistener);
		modelTreeComposite.getCaissonNameTextField().addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				String caissonName = modelTreeComposite.getCaissonNameTextField().getText();
				if(caissonName==null ||caissonName.isEmpty() ) {
					terrorfound = true;
			    	setPageComplete(false);
				}else {
					setCaissonName(caissonName);
					terrorfound = false;
					setPageComplete(true);
				}
					
			}
		});
		String caissonName = modelTreeComposite.getCaissonNameTextField().getText();
		if(caissonName==null ||caissonName.isEmpty() ) {
			terrorfound = true;
		}else {
			terrorfound = false;
		}
		 IStructuredSelection selection = (IStructuredSelection) modelTreeComposite.getSelection();
		    if(selection!=null &&selection.size()==1
		    		&&(selection.getFirstElement() instanceof Caisson|| selection.getFirstElement() instanceof Space3DFree)) {
		    	serrorfound = false;
		    	setPageComplete(true);
		    }else {
		    	serrorfound = true;
		    	setPageComplete(false);
		    }
		
	}
	
	public Cuisine getCuisine() {
		return cuisine;
	}

	public void setCuisine(Cuisine cuisine) {
		this.cuisine = cuisine;
	}

	public Space3D getCaisson() {
		return caisson;
	}

	public String getCaissonName() {
		return caissonName;
	}

	public void setCaissonName(String caissonName) {
		this.caissonName = caissonName;
	}

	public void setCaisson(Space3D caisson) {
		this.caisson = caisson;
	}
	public void clearlistners() {
		modelTreeComposite.removeSelectionListner(selectlistener);
		modelTreeComposite.clearlistners();
	}

	@Override
	public boolean isPageComplete() {

		boolean b = !serrorfound&&!terrorfound;
		return b;
	}

}
