package org.frs.structures.grid;

public class Cell {
	
	private float x;
	private float y;
	private float width;
	private float height;
	private Object value;
	private float[] padding = new float[4];   				//top-bottom-left-right
	
	public Cell() {
		super();
	}
	
	public Cell(float width, float height, float...padding) {
		super();
		this.width = width;
		this.height = height;
		if(padding.length > 0)
			setPadding(padding);
	}
	
	public Cell(float x, float y, float width, float height, float...padding) {
		super();
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		if(padding.length > 0)
			setPadding(padding);
	}
	
	public float[] getPadding() {
		return padding;
	}
	
	public float getTopPadding(int side) {
		if(side > 3 || side < 0)
			return 0;
		return padding[side];
	}
	
	private void setPadding(float[] values) {
		if(values.length == 1) {
			this.padding = new float[] {values[0], values[0], values[0], values[0]};
		}else if(values.length == 2) {
			this.padding = new float[] {values[0], values[0], values[1], values[1]};
		}else if(values.length == 4) {
			this.padding = values;
		}
	}

	public float getX() {
		return x;
	}
	public void setX(float x) {
		this.x = x;
	}
	public float getY() {
		return y;
	}
	public void setY(float y) {
		this.y = y;
	}
	public float getWidth() {
		return width;
	}
	public void setWidth(float width) {
		this.width = width;
	}
	public float getHeight() {
		return height;
	}
	public void setHeight(float height) {
		this.height = height;
	}

	public Object get() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	@Override
	public String toString() {
		return "Cell [x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + ", value=" + value + "]";
	}
	
}
