package org.frs.svg;

import java.util.ArrayList;

import com.badlogic.gdx.math.Vector3;

public class Tetrahedron extends Geometry {
	
	private Vector3 v0, v1, v2, v3;
	
	public Tetrahedron(Vector3 summit, Triangle base) {
		super();
		this.v0 = summit;
		this.v1 = base.getV0();
		this.v2 = base.getV1();
		this.v3 = base.getV2();
	}
	
	public Tetrahedron(Vector3... vertices) {
		super();
		this.v0 = vertices[0];
		this.v1 = vertices[1];
		this.v2 = vertices[2];
		this.v3 = vertices[3];
	}

	@Override
	protected void defineMesh(int tesselation) {
		faces = new ArrayList<Triangle>();
		faces.add(new Triangle(v0, v1, v2));
		faces.add(new Triangle(v0, v2, v3));
		faces.add(new Triangle(v0, v3, v1));
		faces.add(new Triangle(v3, v1, v2));
		calculateLinearMesh();
	}	
}
