package org.frs.svg;

import java.util.ArrayList;
import java.util.Arrays;

import org.frs.svg.SvgDrawer.RENDERING_MODE;

import com.badlogic.gdx.math.Matrix4;

public class SVGRenderingTask {

	private final ArrayList<Geometry> renderables = new ArrayList<Geometry>();
	private RENDERING_MODE mode;
	private float lineThickness = 1.0f;
	
	public SVGRenderingTask(org.frs.svg.SvgDrawer.RENDERING_MODE mode, Geometry... renderables) {
		super();
		this.renderables.addAll(Arrays.asList(renderables));
		this.mode = mode;
	}
	
	public void addRenderable(Geometry... renderables) {
		this.renderables.addAll(Arrays.asList(renderables));
	}

	public ArrayList<Geometry> getRenderables() {
		return renderables;
	}

	public RENDERING_MODE getMode() {
		return mode;
	}

	public void setMode(RENDERING_MODE mode) {
		this.mode = mode;
	}

	public float getLineThickness() {
		return lineThickness;
	}

	public void setLineThickness(float lineThickness) {
		this.lineThickness = lineThickness;
	}
		
}
