package org.frs.svg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

public class Geometry {
	
	protected Matrix4 transform = new Matrix4();
	protected ArrayList<LineSegment> linearMesh;
	protected ArrayList<Triangle> faces;
	protected Vector3 color = new Vector3(0.5f, 0.5f, 0.5f);
	
	protected void defineMesh(int tesselation) {}
	
	public Geometry() {
		super();
	}
	
	public Geometry(ArrayList<LineSegment> linearMesh) {
		this.linearMesh = linearMesh;
	}
	
	public Geometry(LineSegment... lines) {
		super();
		this.linearMesh =  new ArrayList<LineSegment>();
		this.linearMesh.addAll(Arrays.asList(lines));
	}
	
	public Geometry(Triangle... faces) {
		super();
		this.faces =  new ArrayList<Triangle>();
		this.faces.addAll(Arrays.asList(faces));
	}

	public String print(ProjectionCamera camera) {
		return "";
	}
	
	public HashMap<Plane, ArrayList<Triangle>> sortFacesbyPlane(){
		HashMap<Plane, ArrayList<Triangle>> groups = new HashMap<Plane, ArrayList<Triangle>>();
		for(Triangle face: faces) {
			Plane facePlane = face.getPlane();
			ArrayList<Triangle> group = null;
 			for(Plane plane: groups.keySet()) {
				if(facePlane.equals(plane)) {
					group = groups.get(plane);
					break;
				}
			}
 			if(group == null) {
 				group = new ArrayList<Triangle>();
 				groups.put(facePlane, group);
 			}
 			group.add(face);
		}
		return groups;
	}
	
	public void calculateLinearMesh() {
		this.linearMesh = new ArrayList<LineSegment>();
		HashMap<Plane, ArrayList<Triangle>> facesbyPlane = sortFacesbyPlane();
		for(Plane plane: facesbyPlane.keySet()) {
			ArrayList<Triangle> coplanarfaces = facesbyPlane.get(plane);
			ArrayList<LineSegment> edges = new ArrayList<LineSegment>();
			for(Triangle triangle: coplanarfaces) {
				edges.addAll(Arrays.asList(triangle.getEdges()));
			}
			boolean finish;
			do {
				finish = true;
				for(int i = 0; i <  edges.size(); i++) {
					ArrayList<Integer> occurences = new ArrayList<Integer>();
					occurences.add(i);
					for(int j = i+1; j < edges.size(); j++) {
						if(edges.get(j).equals(edges.get(i)))
							occurences.add(j);
					}
					if(occurences.size() > 1) {
						for(int k = 0; k < occurences.size(); k++) {
							edges.remove(occurences.get(k) - k);
						}
						finish = false;
						break;
					}
				}
			}while(!finish);
			this.linearMesh.addAll(edges);
		}
	}
	
	
	
	

	public Matrix4 getTransform() {
		return transform;
	}

	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}

	public ArrayList<Triangle> getFaces() {
		return faces;
	}

	public ArrayList<LineSegment> getLinearMesh() {
		return linearMesh;
	}

	public Vector3 getColor() {
		return color;
	}

	public void setColor(Vector3 color) {
		this.color = color;
	}
	
	
	
	
	
	
	
	
	
}
