package org.frs.webserver.internal;

import javax.servlet.http.HttpServlet;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;



public class EmbeddedJettyServer {

	private Server server;
	private boolean running = false;
	private ServletContextHandler context;
	
	public EmbeddedJettyServer(String rootFolder) {		
		try {
			configure(rootFolder);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
    public void configure(String rootFolder) throws Exception {
        server = new Server(8080); // Port number
        // Configure a context handler for serving static content
        context = new ServletContextHandler(ServletContextHandler.SESSIONS);
        context.setContextPath("/");
        context.setResourceBase(rootFolder);// Set the path to your static files
        context.addServlet(DefaultServlet.class, "/");
        // Add the context to the server
        server.setHandler(new  HandlerList(context));
    }
    
    
    // Method to add a new servlet dynamically after server start
 	public void registerServlet(Class<? extends HttpServlet> servletClass, String pathSpec) throws Exception {
 		if (running) {
 			context.stop();
 			context.addServlet(servletClass, pathSpec);
 			context.start();
 		} else {
 			throw new IllegalStateException("Server is not running");
 		}
 	}
	
	public void startServer() {
		Thread thread = new Thread(() -> {
			try {
				System.out.println("jetty server starting");
				server.start();
				running = true;
			} catch (Exception e) {
				e.printStackTrace();
				running = false;
			}
		});
		
		thread.start();
	}
	
	public void stopServer() {
		try {
			System.out.println("stopping jetty server");
			server.stop();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public boolean isRunning() {
		return running;
	}
	

}
