package test;


import static org.junit.Assert.fail;

import java.util.List;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.Test;
import org.osgi.service.prefs.Preferences;

import com.google.common.reflect.Parameter;

import dressing.controller.DressingCreator;
import dressing.model.DesignException;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.ProjectParent;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.DosType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;
import dressing.ui.parts.ParametersPart;

class DressingCratortest {
ParametersPart part= new ParametersPart();

   
	@Test
	void testCreate() {
		ProjectParent parent  = ModelProvider.RootInstance();
		Project3D project3d= new Project3D();
		project3d.setFullpath("C:/Users/HP/Desktop/project.xml");
		project3d.setDirectory("C:/Users/HP/Desktop");
		project3d.setName("project");
		project3d.initafterread();
		ModelProvider model=new ModelProvider();
		List<Materiaux> materials= model.getMateriallist();
		if(parent!=null) {
			parent.addProject(project3d, false);

		}else
		{
			fail("project parent doit etre instansié"); // TODO
		}
		
		DressingCreator dressingC=new DressingCreator();
		dressingC.setAppartement("appartement");
		dressingC.setEtage("etage");
		dressingC.setName("dressing");
		dressingC.setParent(project3d);
		dressingC.setChantier(project3d.getName());
		dressingC.setHauteur(2500);
		dressingC.setLongeur(3000);
		dressingC.setProfondeur(650);
		//////
		dressingC.setCaissoncount(3);
		//
		dressingC.setCaissonMontageType(CaissonMontageType.CAISSON_MONTAGE_I);
		//
		dressingC.setDostype(DosType.DOSINTERIEUR);
		//
		dressingC.setPorttype(PortType.FRANCAISE);
		//
		dressingC.setPositionCalculationtype(PositionCalculationType.PROPORTIONAL);
		//
		dressingC.setSeparationposition(300);
		//
		dressingC.setSeprationaxe(SeprationAxe.XAXIS);
		//
		dressingC.setSepratortransversal(true);
		//
		dressingC.setWithporte(true);
		//
		dressingC.setWithseprator(true);
		//
		dressingC.setBasematerial(materials.get(1));
		dressingC.setBackmaterial(materials.get(2));
		
		//
		try {
			dressingC.create();
		} catch (DesignException e) {

			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			// TODO Auto-generated catch block
			fail(e.getMessage());
		}
		
		
	}

}
