package model.caisson;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import dressing.controller.DressingCreator;
import dressing.model.Caisson;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.types.CaissonType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.Zone3DType;
import utils.ParametersUtils;

public class CheckCaisson extends CommonCaissonDressing {
	protected void checkCaissonTypes(DressingCreator drcreator) {
		checkCanHold(drcreator.getDressingInstance());
		int caissoncounter = 0;
		int caissonlongeurCounter = 0;
		assertNotNull(drcreator.getDressingInstance());
		assertEquals(drcreator.getCaissoncount(), drcreator.getDressingInstance().getChilds().size());
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			caissonlongeurCounter += caisson.getLongeurext();
			assertEquals(Caisson.class, caisson.getClass());
			assertNotNull(caisson.getChilds());
			assertEquals(drcreator.getCaissonMontageType(), ((Caisson) caisson).getCaissonMontageType());
			assertEquals(drcreator.getDressingInstance().getBasematerial(), ((Caisson) caisson).getBasematerial());
			assertEquals(drcreator.getDressingInstance().getBackmaterial(), ((Caisson) caisson).getBackmaterial());
			assertEquals(drcreator.getLongeur() / drcreator.getCaissoncount(), ((Caisson) caisson).getLongeurext(),
					ParametersUtils.epsilon);
			assertEquals(drcreator.getHauteur(), ((Caisson) caisson).getHauteurext(), ParametersUtils.epsilon);
			assertEquals(drcreator.getProfondeur(), ((Caisson) caisson).getProfondeurext(), ParametersUtils.epsilon);
			assertEquals(drcreator.getPorttype(), ((Caisson) caisson).getPorttype());
			assertEquals(drcreator.getDressingInstance(), ((Caisson) caisson).getParentdesign());
			assertEquals(drcreator.getDressingInstance(), caisson.getParentdesign());

			if (drcreator.getCaissoncount() == 1) {
				if (caissoncounter == 0) {
					assertEquals(CaissonType.MONO_CAISSON, ((Caisson) caisson).getCuissontype());
				}
			}
			if (drcreator.getCaissoncount() == 2) {
				if (caissoncounter == 0) {
					assertEquals(CaissonType.EXTREME_GAUCHE, ((Caisson) caisson).getCuissontype());
				} else if (caissoncounter == 1) {
					assertEquals(CaissonType.EXTREME_DROITE, ((Caisson) caisson).getCuissontype());
				}
			}
			if (drcreator.getCaissoncount() == 3) {
				if (caissoncounter == 0) {
					assertEquals(CaissonType.EXTREME_GAUCHE, ((Caisson) caisson).getCuissontype());
				} else if (caissoncounter == 1) {
					assertEquals(CaissonType.MILIEU, ((Caisson) caisson).getCuissontype());
				} else if (caissoncounter == 2) {
					assertEquals(CaissonType.EXTREME_DROITE, ((Caisson) caisson).getCuissontype());
				}
			}

			caissoncounter++;
		}
		assertEquals(drcreator.getDressingInstance().getLongeurext(), caissonlongeurCounter, ParametersUtils.epsilon);

	}

	protected void CheckCaissonPortetypes(DressingCreator drcreator) {
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			assertEquals(drcreator.getPorttype(), ((Caisson) caisson).getPorttype());
			int caissonportecount = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (drcreator.isWithporte()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE)) {
							caissonportecount++;
						}
					}
				}
			}
			
			//tester l'existence du porte Francaise2V
			int caissonporte2Vcount = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (drcreator.isWithporte()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_DROITE)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_GAUCHE)) {
							caissonporte2Vcount++;
						}
					}
				}
			}
			//tester l'existence du porte Francaise2H
			int caissonporte2Hcount = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (drcreator.isWithporte()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_BAS)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_HAUT)) {
							caissonporte2Hcount++;
						}
					}
				}
			}

			if (drcreator.isWithporte()) {
				if (drcreator.getPorttype().equals(PortType.FRANCAISE)) {
					assertEquals(1, caissonportecount);
				} else if (drcreator.getPorttype().equals(PortType.FRANCAISE2V)) {
					assertEquals(2, caissonporte2Vcount);
				} else if (drcreator.getPorttype().equals(PortType.FRANCAISE2H)) {
					assertEquals(2, caissonporte2Hcount);
				}

			}
		}

	}

	protected void CheckPositionsPieceCaisson(DressingCreator drcreator) {
		// tester les positions des cote, bas, haut et dos du caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						assertEquals(0, piece.getZpos(), ParametersUtils.epsilon);
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR)) {
						assertEquals(-caisson.getBackmaterial().getEpaisseur(), piece.getZpos(),
								ParametersUtils.epsilon);
						assertEquals(0, piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(0, piece.getXpos(), ParametersUtils.epsilon);
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						assertEquals(ParametersUtils.dosRainurePositionOffset, piece.getZpos(),
								ParametersUtils.epsilon);
						assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
								piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
								piece.getXpos(), ParametersUtils.epsilon);
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_GAUCHE)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_DROITE)) {
						assertEquals(caisson.getProfondeurext(), piece.getZpos(), ParametersUtils.epsilon);
					}
				}
			}
		}

		// tester les positions des dos dans le separator dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						assertNotNull(((Separator) piece).getChilds());
						for (DesignObject3D space : ((Separator) piece).getChilds()) {
							assertNotNull(space.getChilds());

							for (DesignObject3D piece2d : space.getChilds()) {
								if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
									if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										fail("une dos dans un zone de type ZONE_HAUT dans un separateur de sepaxe egale a Z est non supporter");
									}
								}
								if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
									assertEquals(ParametersUtils.dosRainurePositionOffset, piece2d.getZpos(),
											ParametersUtils.epsilon);
									assertEquals(
											caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
											piece2d.getYpos(), ParametersUtils.epsilon);
									assertEquals(
											caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
											piece2d.getXpos(), ParametersUtils.epsilon);

								}

							}
						}
					}
				}
			}
		}
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	/**
	 * tester si le parent able to hold the child 
	 * 
	 */
	protected void checkCanHold(DesignObject3D parent) {
		for (DesignObject3D child : parent.getChilds()) {
			assertEquals(true, parent.canHold(child));
			checkCanHold(child);
		}	
	}
}
