package utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JOptionPane;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class UpdateMaterialNames {
    public static void main(String[] args) {
        String inputFilePath = "C:/ProgramData/supercad/materials.json";
        String outputFilePath = "materials_updated.json";
        
        // Mapping of original names to user-friendly French names
        Map<String, String> marbleNameUpdates = new HashMap<String, String>();
        marbleNameUpdates.put("marble-speckled-bl", "Marbre Moucheté");
        marbleNameUpdates.put("pebbled-counter-bl", "Comptoir Galet");
        marbleNameUpdates.put("speckled-countertop1-bl", "Plan de Travail Moucheté");
        marbleNameUpdates.put("streaked-marble-bl", "Marbre Strié");
        marbleNameUpdates.put("stringy-marble-bl", "Marbre Filamentaire");
        marbleNameUpdates.put("white-marble-bl", "Marbre Blanc");
        marbleNameUpdates.put("granitesmooth1-bl", "Granit Lisse 1");
        marbleNameUpdates.put("granitesmooth2", "Granit Lisse 2");
        marbleNameUpdates.put("granitesmooth3", "Granit Lisse 3");
        marbleNameUpdates.put("granitesmooth4", "Granit Lisse 4");
        marbleNameUpdates.put("armani-marble-bl", "Marbre Armani");
        marbleNameUpdates.put("cloudy-veined-quartz-bl", "Quartz Veiné Nuageux");
        marbleNameUpdates.put("cloudy-veined-quartz-light-bl", "Quartz Veiné Nuageux Clair");
        marbleNameUpdates.put("fleshy-granite1-bl", "Granit Chair");
        marbleNameUpdates.put("gray-granite-flecks-bl", "Granit Gris Moucheté");
        marbleNameUpdates.put("gray-polished-granite-bl", "Granit Gris Poli");
        marbleNameUpdates.put("goldenonyx_1-2K", "Onyx Doré");
        marbleNameUpdates.put("carrara", "Marbre Blanc Carrara");
        marbleNameUpdates.put("portoro", "Marbre Portoro");
        marbleNameUpdates.put("redonyx_2-2K", "Onyx Rouge");
        marbleNameUpdates.put("greyvision_1-2K", "Vision Grise");
        marbleNameUpdates.put("fusion_1-2K", "Fusion");
        marbleNameUpdates.put("grigioperlato_1-2K", "Grigio Perlato");
        marbleNameUpdates.put("forestbrown_1-2K", "Marbre Forêt Brune");
        marbleNameUpdates.put("almond-speckled-granite-bl", "Granit Amande Moucheté");
    	JSONParser jsonParser = new JSONParser();
		JSONArray jsonArray = new JSONArray();
		File jsonOutputFile=	new File(inputFilePath);
		if (jsonOutputFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(jsonOutputFile))) {
                StringBuilder content = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
//                jsonArray =  JSONArray.fromObject(content.toString());
                jsonArray =  (JSONArray) jsonParser.parse(content.toString());
            } catch (Exception ex) {
                ex.printStackTrace();
            }
		}else {
			System.out.println(jsonArray);
		}
		for (Object node : jsonArray) {
		    if (((JSONObject) node).containsKey("category") && "MARBLE".equals(((JSONObject) node).get("category"))) {
		        String originalName = (String) ((JSONObject) node).get("name");
		        if (marbleNameUpdates.containsKey(originalName)) {
		        	((JSONObject) node).put("name", marbleNameUpdates.get(originalName));
		        }
		    }
		}
         
         
         System.out.println("Updated materials saved to: " + outputFilePath);
        try (FileWriter file = new FileWriter(jsonOutputFile)) {
            file.write(jsonArray.toJSONString());
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        
    }
}
