package utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import param.Option;
import param.OptionGroup;
import param.impl.OptionImpl;

public class OptionCombinator {

	public OptionCombinator() {
		// TODO Auto-generated constructor stub
	}
	public static List<List<Option>> generateAllOptionCombinations(List<OptionGroup> optionGroups, List<Option> excludedOptions) {
        List<List<Option>> result = new ArrayList<>();
        backtrack(optionGroups, 0, new ArrayList<>(), result,excludedOptions);
        return result;
    }

    private static void backtrack(List<OptionGroup> groups, int index, List<Option> current, List<List<Option>> result, List<Option> excludedOptions) {
        if (index == groups.size()) {
            result.add(new ArrayList<>(current));
            return;
        }

        OptionGroup group = groups.get(index);
        List<Option> options=new ArrayList<>(group.getOptions());
        options.removeAll(excludedOptions);
        for (Option option : options) {
            current.add(option);
            backtrack(groups, index + 1, current, result,excludedOptions);
            current.remove(current.size() - 1); // backtrack
        }
    }
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		OptionImpl op1 = new OptionImpl();
		op1.setName("Small");
		OptionImpl op2 = new OptionImpl();
		op2.setName("Medium");
		OptionImpl op21 = new OptionImpl();
		op21.setName("Red");
		OptionImpl op22 = new OptionImpl();
		op22.setName("Blue");
//		List<OptionGroup> groups = Arrays.asList(
//			    new OptionGroup("Size", Arrays.asList(op1, op2)),
//			    new OptionGroup("Color", Arrays.asList(op21, op22))
//			);

//			List<List<Option>> combinations = OptionCombinator.generateAllOptionCombinations(groups);
//
//			for (List<Option> combo : combinations) {
//			    System.out.println(combo.stream().map(Option::getName).toList());
//			}
	}

}
