package unbboolean.solids;

import org.jogamp.vecmath.Point3d;

/**
 * Class containing default coordinates for the primitive solids
 * 
 * @author Danilo Balby Silva Castanheira (danbalby@yahoo.com)
 */
public class DefaultCoordinates 
{
	public static final Point3d[] DEFAULT_BOX_VERTICES = new Point3d[]{
			new Point3d(-0.5, -0.5, -0.5),
			new Point3d(0.5, -0.5, -0.5),
			new Point3d(-0.5, 0.5, -0.5),
			new Point3d(0.5, 0.5, -0.5),
			new Point3d(-0.5, -0.5, 0.5),
			new Point3d(0.5, -0.5, 0.5),
			new Point3d(-0.5, 0.5, 0.5),	
			new Point3d(0.5, 0.5, 0.5)
	};
	
	public static final int[] DEFAULT_BOX_COORDINATES = new int[]{
			0, 2, 3,
			3, 1, 0,
			4, 5, 7,
			7, 6, 4,
			0, 1, 5,
			5, 4, 0,
			1, 3, 7,
			7, 5, 1,
			3, 2, 6,
			6, 7, 3,
			2, 0, 4,
			4, 6, 2
	};
	
	public static final Point3d[] DEFAULT_CONE_VERTICES = new Point3d[]{
			new Point3d(0.0, -0.5, 0.0),
			new Point3d(1.0, -0.5, 0.0),
			new Point3d(0.9659, -0.5, -0.2588),
			new Point3d(0.866, -0.5, -0.5),
			new Point3d(0.7071, -0.5, -0.7071),
			new Point3d(0.5, -0.5, -0.866),
			new Point3d(0.2588, -0.5, -0.9659),
			new Point3d(-0.0, -0.5, -1.0),
			new Point3d(-0.2588, -0.5, -0.9659),
			new Point3d(-0.5, -0.5, -0.866),
			new Point3d(-0.7071, -0.5, -0.7071),
			new Point3d(-0.866, -0.5, -0.5),
			new Point3d(-0.9659, -0.5, -0.2588),
			new Point3d(-1.0, -0.5, 0.0),
			new Point3d(-0.9659, -0.5, 0.2588),
			new Point3d(-0.866, -0.5, 0.5),
			new Point3d(-0.7071, -0.5, 0.7071),
			new Point3d(-0.5, -0.5, 0.866),
			new Point3d(-0.2588, -0.5, 0.9659),
			new Point3d(0.0, -0.5, 1.0),
			new Point3d(0.2588, -0.5, 0.9659),
			new Point3d(0.5, -0.5, 0.866),
			new Point3d(0.7071, -0.5, 0.7071),
			new Point3d(0.866, -0.5, 0.5),
			new Point3d(0.9659, -0.5, 0.2588),
			new Point3d(0.8, -0.3, -0.0),
			new Point3d(0.7727, -0.3, -0.2071),
			new Point3d(0.6928, -0.3, -0.4),
			new Point3d(0.5657, -0.3, -0.5657),
			new Point3d(0.4, -0.3, -0.6928),
			new Point3d(0.2071, -0.3, -0.7727),
			new Point3d(-0.0, -0.3, -0.8),
			new Point3d(-0.2071, -0.3, -0.7727),
			new Point3d(-0.4, -0.3, -0.6928),
			new Point3d(-0.5657, -0.3, -0.5657),
			new Point3d(-0.6928, -0.3, -0.4),
			new Point3d(-0.7727, -0.3, -0.2071),
			new Point3d(-0.8, -0.3, 0.0),
			new Point3d(-0.7727, -0.3, 0.2071),
			new Point3d(-0.6928, -0.3, 0.4),
			new Point3d(-0.5657, -0.3, 0.5657),
			new Point3d(-0.4, -0.3, 0.6928),
			new Point3d(-0.2071, -0.3, 0.7727),
			new Point3d(0.0, -0.3, 0.8),
			new Point3d(0.2071, -0.3, 0.7727),
			new Point3d(0.4, -0.3, 0.6928),
			new Point3d(0.5657, -0.3, 0.5657),
			new Point3d(0.6928, -0.3, 0.4),
			new Point3d(0.7727, -0.3, 0.2071),
			new Point3d(0.6, -0.1, -0.0),
			new Point3d(0.5796, -0.1, -0.1553),
			new Point3d(0.5196, -0.1, -0.3),
			new Point3d(0.4243, -0.1, -0.4243),
			new Point3d(0.3, -0.1, -0.5196),
			new Point3d(0.1553, -0.1, -0.5796),
			new Point3d(-0.0, -0.1, -0.6),
			new Point3d(-0.1553, -0.1, -0.5796),
			new Point3d(-0.3, -0.1, -0.5196),
			new Point3d(-0.4243, -0.1, -0.4243),
			new Point3d(-0.5196, -0.1, -0.3),
			new Point3d(-0.5796, -0.1, -0.1553),
			new Point3d(-0.6, -0.1, 0.0),
			new Point3d(-0.5796, -0.1, 0.1553),
			new Point3d(-0.5196, -0.1, 0.3),
			new Point3d(-0.4243, -0.1, 0.4243),
			new Point3d(-0.3, -0.1, 0.5196),
			new Point3d(-0.1553, -0.1, 0.5796),
			new Point3d(0.0, -0.1, 0.6),
			new Point3d(0.1553, -0.1, 0.5796),
			new Point3d(0.3, -0.1, 0.5196),
			new Point3d(0.4243, -0.1, 0.4243),
			new Point3d(0.5196, -0.1, 0.3),
			new Point3d(0.5796, -0.1, 0.1553),
			new Point3d(0.4, 0.1, -0.0),
			new Point3d(0.3864, 0.1, -0.1035),
			new Point3d(0.3464, 0.1, -0.2),
			new Point3d(0.2828, 0.1, -0.2828),
			new Point3d(0.2, 0.1, -0.3464),
			new Point3d(0.1035, 0.1, -0.3864),
			new Point3d(-0.0, 0.1, -0.4),
			new Point3d(-0.1035, 0.1, -0.3864),
			new Point3d(-0.2, 0.1, -0.3464),
			new Point3d(-0.2828, 0.1, -0.2828),
			new Point3d(-0.3464, 0.1, -0.2),
			new Point3d(-0.3864, 0.1, -0.1035),
			new Point3d(-0.4, 0.1, 0.0),
			new Point3d(-0.3864, 0.1, 0.1035),
			new Point3d(-0.3464, 0.1, 0.2),
			new Point3d(-0.2828, 0.1, 0.2828),
			new Point3d(-0.2, 0.1, 0.3464),
			new Point3d(-0.1035, 0.1, 0.3864),
			new Point3d(0.0, 0.1, 0.4),
			new Point3d(0.1035, 0.1, 0.3864),
			new Point3d(0.2, 0.1, 0.3464),
			new Point3d(0.2828, 0.1, 0.2828),
			new Point3d(0.3464, 0.1, 0.2),
			new Point3d(0.3864, 0.1, 0.1035),
			new Point3d(0.2, 0.3, -0.0),
			new Point3d(0.1932, 0.3, -0.0518),
			new Point3d(0.1732, 0.3, -0.1),
			new Point3d(0.1414, 0.3, -0.1414),
			new Point3d(0.1, 0.3, -0.1732),
			new Point3d(0.0518, 0.3, -0.1932),
			new Point3d(-0.0, 0.3, -0.2),
			new Point3d(-0.0518, 0.3, -0.1932),
			new Point3d(-0.1, 0.3, -0.1732),
			new Point3d(-0.1414, 0.3, -0.1414),
			new Point3d(-0.1732, 0.3, -0.1),
			new Point3d(-0.1932, 0.3, -0.0518),
			new Point3d(-0.2, 0.3, -0.0),
			new Point3d(-0.1932, 0.3, 0.0518),
			new Point3d(-0.1732, 0.3, 0.1),
			new Point3d(-0.1414, 0.3, 0.1414),
			new Point3d(-0.1, 0.3, 0.1732),
			new Point3d(-0.0518, 0.3, 0.1932),
			new Point3d(0.0, 0.3, 0.2),
			new Point3d(0.0518, 0.3, 0.1932),
			new Point3d(0.1, 0.3, 0.1732),
			new Point3d(0.1414, 0.3, 0.1414),
			new Point3d(0.1732, 0.3, 0.1),
			new Point3d(0.1932, 0.3, 0.0518),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0),
			new Point3d(0.0, 0.5, -0.0)
	};
	
	public static final int[] DEFAULT_CONE_COORDINATES = new int[]{
			0, 2, 1,
			0, 3, 2,
			0, 4, 3,
			0, 5, 4,
			0, 6, 5,
			0, 7, 6,
			0, 8, 7,
			0, 9, 8,
			0, 10, 9,
			0, 11, 10,
			0, 12, 11,
			0, 13, 12,
			0, 14, 13,
			0, 15, 14,
			0, 16, 15,
			0, 17, 16,
			0, 18, 17,
			0, 19, 18,
			0, 20, 19,
			0, 21, 20,
			0, 22, 21,
			0, 23, 22,
			0, 24, 23,
			0, 1, 24,
			1, 26, 25,
			1, 2, 26,
			2, 27, 26,
			2, 3, 27,
			3, 28, 27,
			3, 4, 28,
			4, 29, 28,
			4, 5, 29,
			5, 30, 29,
			5, 6, 30,
			6, 31, 30,
			6, 7, 31,
			7, 32, 31,
			7, 8, 32,
			8, 33, 32,
			8, 9, 33,
			9, 34, 33,
			9, 10, 34,
			10, 35, 34,
			10, 11, 35,
			11, 36, 35,
			11, 12, 36,
			12, 37, 36,
			12, 13, 37,
			13, 38, 37,
			13, 14, 38,
			14, 39, 38,
			14, 15, 39,
			15, 40, 39,
			15, 16, 40,
			16, 41, 40,
			16, 17, 41,
			17, 42, 41,
			17, 18, 42,
			18, 43, 42,
			18, 19, 43,
			19, 44, 43,
			19, 20, 44,
			20, 45, 44,
			20, 21, 45,
			21, 46, 45,
			21, 22, 46,
			22, 47, 46,
			22, 23, 47,
			23, 48, 47,
			23, 24, 48,
			24, 25, 48,
			24, 1, 25,
			25, 50, 49,
			25, 26, 50,
			26, 51, 50,
			26, 27, 51,
			27, 52, 51,
			27, 28, 52,
			28, 53, 52,
			28, 29, 53,
			29, 54, 53,
			29, 30, 54,
			30, 55, 54,
			30, 31, 55,
			31, 56, 55,
			31, 32, 56,
			32, 57, 56,
			32, 33, 57,
			33, 58, 57,
			33, 34, 58,
			34, 59, 58,
			34, 35, 59,
			35, 60, 59,
			35, 36, 60,
			36, 61, 60,
			36, 37, 61,
			37, 62, 61,
			37, 38, 62,
			38, 63, 62,
			38, 39, 63,
			39, 64, 63,
			39, 40, 64,
			40, 65, 64,
			40, 41, 65,
			41, 66, 65,
			41, 42, 66,
			42, 67, 66,
			42, 43, 67,
			43, 68, 67,
			43, 44, 68,
			44, 69, 68,
			44, 45, 69,
			45, 70, 69,
			45, 46, 70,
			46, 71, 70,
			46, 47, 71,
			47, 72, 71,
			47, 48, 72,
			48, 49, 72,
			48, 25, 49,
			49, 74, 73,
			49, 50, 74,
			50, 75, 74,
			50, 51, 75,
			51, 76, 75,
			51, 52, 76,
			52, 77, 76,
			52, 53, 77,
			53, 78, 77,
			53, 54, 78,
			54, 79, 78,
			54, 55, 79,
			55, 80, 79,
			55, 56, 80,
			56, 81, 80,
			56, 57, 81,
			57, 82, 81,
			57, 58, 82,
			58, 83, 82,
			58, 59, 83,
			59, 84, 83,
			59, 60, 84,
			60, 85, 84,
			60, 61, 85,
			61, 86, 85,
			61, 62, 86,
			62, 87, 86,
			62, 63, 87,
			63, 88, 87,
			63, 64, 88,
			64, 89, 88,
			64, 65, 89,
			65, 90, 89,
			65, 66, 90,
			66, 91, 90,
			66, 67, 91,
			67, 92, 91,
			67, 68, 92,
			68, 93, 92,
			68, 69, 93,
			69, 94, 93,
			69, 70, 94,
			70, 95, 94,
			70, 71, 95,
			71, 96, 95,
			71, 72, 96,
			72, 73, 96,
			72, 49, 73,
			73, 98, 97,
			73, 74, 98,
			74, 99, 98,
			74, 75, 99,
			75, 100, 99,
			75, 76, 100,
			76, 101, 100,
			76, 77, 101,
			77, 102, 101,
			77, 78, 102,
			78, 103, 102,
			78, 79, 103,
			79, 104, 103,
			79, 80, 104,
			80, 105, 104,
			80, 81, 105,
			81, 106, 105,
			81, 82, 106,
			82, 107, 106,
			82, 83, 107,
			83, 108, 107,
			83, 84, 108,
			84, 109, 108,
			84, 85, 109,
			85, 110, 109,
			85, 86, 110,
			86, 111, 110,
			86, 87, 111,
			87, 112, 111,
			87, 88, 112,
			88, 113, 112,
			88, 89, 113,
			89, 114, 113,
			89, 90, 114,
			90, 115, 114,
			90, 91, 115,
			91, 116, 115,
			91, 92, 116,
			92, 117, 116,
			92, 93, 117,
			93, 118, 117,
			93, 94, 118,
			94, 119, 118,
			94, 95, 119,
			95, 120, 119,
			95, 96, 120,
			96, 97, 120,
			96, 73, 97,
			97, 122, 121,
			97, 98, 122,
			98, 123, 122,
			98, 99, 123,
			99, 124, 123,
			99, 100, 124,
			100, 125, 124,
			100, 101, 125,
			101, 126, 125,
			101, 102, 126,
			102, 127, 126,
			102, 103, 127,
			103, 128, 127,
			103, 104, 128,
			104, 129, 128,
			104, 105, 129,
			105, 130, 129,
			105, 106, 130,
			106, 131, 130,
			106, 107, 131,
			107, 132, 131,
			107, 108, 132,
			108, 133, 132,
			108, 109, 133,
			109, 134, 133,
			109, 110, 134,
			110, 135, 134,
			110, 111, 135,
			111, 136, 135,
			111, 112, 136,
			112, 137, 136,
			112, 113, 137,
			113, 138, 137,
			113, 114, 138,
			114, 139, 138,
			114, 115, 139,
			115, 140, 139,
			115, 116, 140,
			116, 141, 140,
			116, 117, 141,
			117, 142, 141,
			117, 118, 142,
			118, 143, 142,
			118, 119, 143,
			119, 144, 143,
			119, 120, 144,
			120, 121, 144,
			120, 97, 121,
			145, 121, 122,
			145, 122, 123,
			145, 123, 124,
			145, 124, 125,
			145, 125, 126,
			145, 126, 127,
			145, 127, 128,
			145, 128, 129,
			145, 129, 130,
			145, 130, 131,
			145, 131, 132,
			145, 132, 133,
			145, 133, 134,
			145, 134, 135,
			145, 135, 136,
			145, 136, 137,
			145, 137, 138,
			145, 138, 139,
			145, 139, 140,
			145, 140, 141,
			145, 141, 142,
			145, 142, 143,
			145, 143, 144,
			145, 144, 121	
	};
	
	public static final Point3d[] DEFAULT_CYLINDER_VERTICES = new Point3d[]{
			new Point3d(0.0, 0.5, 0.0),
			new Point3d(1.0, 0.5, 0.0),
			new Point3d(0.9397, 0.5, 0.342),
			new Point3d(0.766, 0.5, 0.6428),
			new Point3d(0.5, 0.5, 0.866),
			new Point3d(0.1736, 0.5, 0.9848),
			new Point3d(-0.1736, 0.5, 0.9848),
			new Point3d(-0.5, 0.5, 0.866),
			new Point3d(-0.766, 0.5, 0.6428),
			new Point3d(-0.9397, 0.5, 0.342),
			new Point3d(-1.0, 0.5, -0.0),
			new Point3d(-0.9397, 0.5, -0.342),
			new Point3d(-0.766, 0.5, -0.6428),
			new Point3d(-0.5, 0.5, -0.866),
			new Point3d(-0.1736, 0.5, -0.9848),
			new Point3d(0.1736, 0.5, -0.9848),
			new Point3d(0.5, 0.5, -0.866),
			new Point3d(0.766, 0.5, -0.6428),
			new Point3d(0.9397, 0.5, -0.342),
			new Point3d(1.0, 0.3, -0.0),
			new Point3d(0.9397, 0.3, 0.342),
			new Point3d(0.766, 0.3, 0.6428),
			new Point3d(0.5, 0.3, 0.866),
			new Point3d(0.1736, 0.3, 0.9848),
			new Point3d(-0.1736, 0.3, 0.9848),
			new Point3d(-0.5, 0.3, 0.866),
			new Point3d(-0.766, 0.3, 0.6428),
			new Point3d(-0.9397, 0.3, 0.342),
			new Point3d(-1.0, 0.3, -0.0),
			new Point3d(-0.9397, 0.3, -0.342),
			new Point3d(-0.766, 0.3, -0.6428),
			new Point3d(-0.5, 0.3, -0.866),
			new Point3d(-0.1736, 0.3, -0.9848),
			new Point3d(0.1736, 0.3, -0.9848),
			new Point3d(0.5, 0.3, -0.866),
			new Point3d(0.766, 0.3, -0.6428),
			new Point3d(0.9397, 0.3, -0.342),
			new Point3d(1.0, 0.1, -0.0),
			new Point3d(0.9397, 0.1, 0.342),
			new Point3d(0.766, 0.1, 0.6428),
			new Point3d(0.5, 0.1, 0.866),
			new Point3d(0.1736, 0.1, 0.9848),
			new Point3d(-0.1736, 0.1, 0.9848),
			new Point3d(-0.5, 0.1, 0.866),
			new Point3d(-0.766, 0.1, 0.6428),
			new Point3d(-0.9397, 0.1, 0.342),
			new Point3d(-1.0, 0.1, -0.0),
			new Point3d(-0.9397, 0.1, -0.342),
			new Point3d(-0.766, 0.1, -0.6428),
			new Point3d(-0.5, 0.1, -0.866),
			new Point3d(-0.1736, 0.1, -0.9848),
			new Point3d(0.1736, 0.1, -0.9848),
			new Point3d(0.5, 0.1, -0.866),
			new Point3d(0.766, 0.1, -0.6428),
			new Point3d(0.9397, 0.1, -0.342),
			new Point3d(1.0, -0.1, -0.0),
			new Point3d(0.9397, -0.1, 0.342),
			new Point3d(0.766, -0.1, 0.6428),
			new Point3d(0.5, -0.1, 0.866),
			new Point3d(0.1736, -0.1, 0.9848),
			new Point3d(-0.1736, -0.1, 0.9848),
			new Point3d(-0.5, -0.1, 0.866),
			new Point3d(-0.766, -0.1, 0.6428),
			new Point3d(-0.9397, -0.1, 0.342),
			new Point3d(-1.0, -0.1, -0.0),
			new Point3d(-0.9397, -0.1, -0.342),
			new Point3d(-0.766, -0.1, -0.6428),
			new Point3d(-0.5, -0.1, -0.866),
			new Point3d(-0.1736, -0.1, -0.9848),
			new Point3d(0.1736, -0.1, -0.9848),
			new Point3d(0.5, -0.1, -0.866),
			new Point3d(0.766, -0.1, -0.6428),
			new Point3d(0.9397, -0.1, -0.342),
			new Point3d(1.0, -0.3, -0.0),
			new Point3d(0.9397, -0.3, 0.342),
			new Point3d(0.766, -0.3, 0.6428),
			new Point3d(0.5, -0.3, 0.866),
			new Point3d(0.1736, -0.3, 0.9848),
			new Point3d(-0.1736, -0.3, 0.9848),
			new Point3d(-0.5, -0.3, 0.866),
			new Point3d(-0.766, -0.3, 0.6428),
			new Point3d(-0.9397, -0.3, 0.342),
			new Point3d(-1.0, -0.3, -0.0),
			new Point3d(-0.9397, -0.3, -0.342),
			new Point3d(-0.766, -0.3, -0.6428),
			new Point3d(-0.5, -0.3, -0.866),
			new Point3d(-0.1736, -0.3, -0.9848),
			new Point3d(0.1736, -0.3, -0.9848),
			new Point3d(0.5, -0.3, -0.866),
			new Point3d(0.766, -0.3, -0.6428),
			new Point3d(0.9397, -0.3, -0.342),
			new Point3d(1.0, -0.5, -0.0),
			new Point3d(0.9397, -0.5, 0.342),
			new Point3d(0.766, -0.5, 0.6428),
			new Point3d(0.5, -0.5, 0.866),
			new Point3d(0.1736, -0.5, 0.9848),
			new Point3d(-0.1736, -0.5, 0.9848),
			new Point3d(-0.5, -0.5, 0.866),
			new Point3d(-0.766, -0.5, 0.6428),
			new Point3d(-0.9397, -0.5, 0.342),
			new Point3d(-1.0, -0.5, -0.0),
			new Point3d(-0.9397, -0.5, -0.342),
			new Point3d(-0.766, -0.5, -0.6428),
			new Point3d(-0.5, -0.5, -0.866),
			new Point3d(-0.1736, -0.5, -0.9848),
			new Point3d(0.1736, -0.5, -0.9848),
			new Point3d(0.5, -0.5, -0.866),
			new Point3d(0.766, -0.5, -0.6428),
			new Point3d(0.9397, -0.5, -0.342),
			new Point3d(0.0, -0.5, -0.0)	
	};
	
	public static final int[] DEFAULT_CYLINDER_COORDINATES = new int[]{
			0, 2, 1,
			0, 3, 2,
			0, 4, 3,
			0, 5, 4,
			0, 6, 5,
			0, 7, 6,
			0, 8, 7,
			0, 9, 8,
			0, 10, 9,
			0, 11, 10,
			0, 12, 11,
			0, 13, 12,
			0, 14, 13,
			0, 15, 14,
			0, 16, 15,
			0, 17, 16,
			0, 18, 17,
			0, 1, 18,
			1, 20, 19,
			1, 2, 20,
			2, 21, 20,
			2, 3, 21,
			3, 22, 21,
			3, 4, 22,
			4, 23, 22,
			4, 5, 23,
			5, 24, 23,
			5, 6, 24,
			6, 25, 24,
			6, 7, 25,
			7, 26, 25,
			7, 8, 26,
			8, 27, 26,
			8, 9, 27,
			9, 28, 27,
			9, 10, 28,
			10, 29, 28,
			10, 11, 29,
			11, 30, 29,
			11, 12, 30,
			12, 31, 30,
			12, 13, 31,
			13, 32, 31,
			13, 14, 32,
			14, 33, 32,
			14, 15, 33,
			15, 34, 33,
			15, 16, 34,
			16, 35, 34,
			16, 17, 35,
			17, 36, 35,
			17, 18, 36,
			18, 19, 36,
			18, 1, 19,
			19, 38, 37,
			19, 20, 38,
			20, 39, 38,
			20, 21, 39,
			21, 40, 39,
			21, 22, 40,
			22, 41, 40,
			22, 23, 41,
			23, 42, 41,
			23, 24, 42,
			24, 43, 42,
			24, 25, 43,
			25, 44, 43,
			25, 26, 44,
			26, 45, 44,
			26, 27, 45,
			27, 46, 45,
			27, 28, 46,
			28, 47, 46,
			28, 29, 47,
			29, 48, 47,
			29, 30, 48,
			30, 49, 48,
			30, 31, 49,
			31, 50, 49,
			31, 32, 50,
			32, 51, 50,
			32, 33, 51,
			33, 52, 51,
			33, 34, 52,
			34, 53, 52,
			34, 35, 53,
			35, 54, 53,
			35, 36, 54,
			36, 37, 54,
			36, 19, 37,
			37, 56, 55,
			37, 38, 56,
			38, 57, 56,
			38, 39, 57,
			39, 58, 57,
			39, 40, 58,
			40, 59, 58,
			40, 41, 59,
			41, 60, 59,
			41, 42, 60,
			42, 61, 60,
			42, 43, 61,
			43, 62, 61,
			43, 44, 62,
			44, 63, 62,
			44, 45, 63,
			45, 64, 63,
			45, 46, 64,
			46, 65, 64,
			46, 47, 65,
			47, 66, 65,
			47, 48, 66,
			48, 67, 66,
			48, 49, 67,
			49, 68, 67,
			49, 50, 68,
			50, 69, 68,
			50, 51, 69,
			51, 70, 69,
			51, 52, 70,
			52, 71, 70,
			52, 53, 71,
			53, 72, 71,
			53, 54, 72,
			54, 55, 72,
			54, 37, 55,
			55, 74, 73,
			55, 56, 74,
			56, 75, 74,
			56, 57, 75,
			57, 76, 75,
			57, 58, 76,
			58, 77, 76,
			58, 59, 77,
			59, 78, 77,
			59, 60, 78,
			60, 79, 78,
			60, 61, 79,
			61, 80, 79,
			61, 62, 80,
			62, 81, 80,
			62, 63, 81,
			63, 82, 81,
			63, 64, 82,
			64, 83, 82,
			64, 65, 83,
			65, 84, 83,
			65, 66, 84,
			66, 85, 84,
			66, 67, 85,
			67, 86, 85,
			67, 68, 86,
			68, 87, 86,
			68, 69, 87,
			69, 88, 87,
			69, 70, 88,
			70, 89, 88,
			70, 71, 89,
			71, 90, 89,
			71, 72, 90,
			72, 73, 90,
			72, 55, 73,
			73, 92, 91,
			73, 74, 92,
			74, 93, 92,
			74, 75, 93,
			75, 94, 93,
			75, 76, 94,
			76, 95, 94,
			76, 77, 95,
			77, 96, 95,
			77, 78, 96,
			78, 97, 96,
			78, 79, 97,
			79, 98, 97,
			79, 80, 98,
			80, 99, 98,
			80, 81, 99,
			81, 100, 99,
			81, 82, 100,
			82, 101, 100,
			82, 83, 101,
			83, 102, 101,
			83, 84, 102,
			84, 103, 102,
			84, 85, 103,
			85, 104, 103,
			85, 86, 104,
			86, 105, 104,
			86, 87, 105,
			87, 106, 105,
			87, 88, 106,
			88, 107, 106,
			88, 89, 107,
			89, 108, 107,
			89, 90, 108,
			90, 91, 108,
			90, 73, 91,
			109, 91, 92,
			109, 92, 93,
			109, 93, 94,
			109, 94, 95,
			109, 95, 96,
			109, 96, 97,
			109, 97, 98,
			109, 98, 99,
			109, 99, 100,
			109, 100, 101,
			109, 101, 102,
			109, 102, 103,
			109, 103, 104,
			109, 104, 105,
			109, 105, 106,
			109, 106, 107,
			109, 107, 108,
			109, 108, 91			
	};
			
	public static final Point3d[] DEFAULT_SPHERE_VERTICES = new Point3d[]{
			new Point3d(0.0, 0.0, 1.0),
			new Point3d(-0.0, 0.1951, 0.9808),
			new Point3d(-0.0381, 0.1913, 0.9808),
			new Point3d(-0.0747, 0.1802, 0.9808),
			new Point3d(-0.1084, 0.1622, 0.9808),
			new Point3d(-0.1379, 0.1379, 0.9808),
			new Point3d(-0.1622, 0.1084, 0.9808),
			new Point3d(-0.1802, 0.0747, 0.9808),
			new Point3d(-0.1913, 0.0381, 0.9808),
			new Point3d(-0.1951, -0.0, 0.9808),
			new Point3d(-0.1913, -0.0381, 0.9808),
			new Point3d(-0.1802, -0.0747, 0.9808),
			new Point3d(-0.1622, -0.1084, 0.9808),
			new Point3d(-0.1379, -0.1379, 0.9808),
			new Point3d(-0.1084, -0.1622, 0.9808),
			new Point3d(-0.0747, -0.1802, 0.9808),
			new Point3d(-0.0381, -0.1913, 0.9808),
			new Point3d(0.0, -0.1951, 0.9808),
			new Point3d(0.0381, -0.1913, 0.9808),
			new Point3d(0.0747, -0.1802, 0.9808),
			new Point3d(0.1084, -0.1622, 0.9808),
			new Point3d(0.1379, -0.1379, 0.9808),
			new Point3d(0.1622, -0.1084, 0.9808),
			new Point3d(0.1802, -0.0747, 0.9808),
			new Point3d(0.1913, -0.0381, 0.9808),
			new Point3d(0.1951, 0.0, 0.9808),
			new Point3d(0.1913, 0.0381, 0.9808),
			new Point3d(0.1802, 0.0747, 0.9808),
			new Point3d(0.1622, 0.1084, 0.9808),
			new Point3d(0.1379, 0.1379, 0.9808),
			new Point3d(0.1084, 0.1622, 0.9808),
			new Point3d(0.0747, 0.1802, 0.9808),
			new Point3d(0.0381, 0.1913, 0.9808),
			new Point3d(-0.0, 0.3827, 0.9239),
			new Point3d(-0.0747, 0.3753, 0.9239),
			new Point3d(-0.1464, 0.3536, 0.9239),
			new Point3d(-0.2126, 0.3182, 0.9239),
			new Point3d(-0.2706, 0.2706, 0.9239),
			new Point3d(-0.3182, 0.2126, 0.9239),
			new Point3d(-0.3536, 0.1464, 0.9239),
			new Point3d(-0.3753, 0.0747, 0.9239),
			new Point3d(-0.3827, -0.0, 0.9239),
			new Point3d(-0.3753, -0.0747, 0.9239),
			new Point3d(-0.3536, -0.1464, 0.9239),
			new Point3d(-0.3182, -0.2126, 0.9239),
			new Point3d(-0.2706, -0.2706, 0.9239),
			new Point3d(-0.2126, -0.3182, 0.9239),
			new Point3d(-0.1464, -0.3536, 0.9239),
			new Point3d(-0.0747, -0.3753, 0.9239),
			new Point3d(0.0, -0.3827, 0.9239),
			new Point3d(0.0747, -0.3753, 0.9239),
			new Point3d(0.1464, -0.3536, 0.9239),
			new Point3d(0.2126, -0.3182, 0.9239),
			new Point3d(0.2706, -0.2706, 0.9239),
			new Point3d(0.3182, -0.2126, 0.9239),
			new Point3d(0.3536, -0.1464, 0.9239),
			new Point3d(0.3753, -0.0747, 0.9239),
			new Point3d(0.3827, 0.0, 0.9239),
			new Point3d(0.3753, 0.0747, 0.9239),
			new Point3d(0.3536, 0.1464, 0.9239),
			new Point3d(0.3182, 0.2126, 0.9239),
			new Point3d(0.2706, 0.2706, 0.9239),
			new Point3d(0.2126, 0.3182, 0.9239),
			new Point3d(0.1464, 0.3536, 0.9239),
			new Point3d(0.0747, 0.3753, 0.9239),
			new Point3d(-0.0, 0.5556, 0.8315),
			new Point3d(-0.1084, 0.5449, 0.8315),
			new Point3d(-0.2126, 0.5133, 0.8315),
			new Point3d(-0.3087, 0.4619, 0.8315),
			new Point3d(-0.3928, 0.3928, 0.8315),
			new Point3d(-0.4619, 0.3087, 0.8315),
			new Point3d(-0.5133, 0.2126, 0.8315),
			new Point3d(-0.5449, 0.1084, 0.8315),
			new Point3d(-0.5556, -0.0, 0.8315),
			new Point3d(-0.5449, -0.1084, 0.8315),
			new Point3d(-0.5133, -0.2126, 0.8315),
			new Point3d(-0.4619, -0.3087, 0.8315),
			new Point3d(-0.3928, -0.3928, 0.8315),
			new Point3d(-0.3087, -0.4619, 0.8315),
			new Point3d(-0.2126, -0.5133, 0.8315),
			new Point3d(-0.1084, -0.5449, 0.8315),
			new Point3d(0.0, -0.5556, 0.8315),
			new Point3d(0.1084, -0.5449, 0.8315),
			new Point3d(0.2126, -0.5133, 0.8315),
			new Point3d(0.3087, -0.4619, 0.8315),
			new Point3d(0.3928, -0.3928, 0.8315),
			new Point3d(0.4619, -0.3087, 0.8315),
			new Point3d(0.5133, -0.2126, 0.8315),
			new Point3d(0.5449, -0.1084, 0.8315),
			new Point3d(0.5556, 0.0, 0.8315),
			new Point3d(0.5449, 0.1084, 0.8315),
			new Point3d(0.5133, 0.2126, 0.8315),
			new Point3d(0.4619, 0.3087, 0.8315),
			new Point3d(0.3928, 0.3928, 0.8315),
			new Point3d(0.3087, 0.4619, 0.8315),
			new Point3d(0.2126, 0.5133, 0.8315),
			new Point3d(0.1084, 0.5449, 0.8315),
			new Point3d(-0.0, 0.7071, 0.7071),
			new Point3d(-0.1379, 0.6935, 0.7071),
			new Point3d(-0.2706, 0.6533, 0.7071),
			new Point3d(-0.3928, 0.5879, 0.7071),
			new Point3d(-0.5, 0.5, 0.7071),
			new Point3d(-0.5879, 0.3928, 0.7071),
			new Point3d(-0.6533, 0.2706, 0.7071),
			new Point3d(-0.6935, 0.1379, 0.7071),
			new Point3d(-0.7071, -0.0, 0.7071),
			new Point3d(-0.6935, -0.1379, 0.7071),
			new Point3d(-0.6533, -0.2706, 0.7071),
			new Point3d(-0.5879, -0.3928, 0.7071),
			new Point3d(-0.5, -0.5, 0.7071),
			new Point3d(-0.3928, -0.5879, 0.7071),
			new Point3d(-0.2706, -0.6533, 0.7071),
			new Point3d(-0.1379, -0.6935, 0.7071),
			new Point3d(0.0, -0.7071, 0.7071),
			new Point3d(0.1379, -0.6935, 0.7071),
			new Point3d(0.2706, -0.6533, 0.7071),
			new Point3d(0.3928, -0.5879, 0.7071),
			new Point3d(0.5, -0.5, 0.7071),
			new Point3d(0.5879, -0.3928, 0.7071),
			new Point3d(0.6533, -0.2706, 0.7071),
			new Point3d(0.6935, -0.1379, 0.7071),
			new Point3d(0.7071, 0.0, 0.7071),
			new Point3d(0.6935, 0.1379, 0.7071),
			new Point3d(0.6533, 0.2706, 0.7071),
			new Point3d(0.5879, 0.3928, 0.7071),
			new Point3d(0.5, 0.5, 0.7071),
			new Point3d(0.3928, 0.5879, 0.7071),
			new Point3d(0.2706, 0.6533, 0.7071),
			new Point3d(0.1379, 0.6935, 0.7071),
			new Point3d(-0.0, 0.8315, 0.5556),
			new Point3d(-0.1622, 0.8155, 0.5556),
			new Point3d(-0.3182, 0.7682, 0.5556),
			new Point3d(-0.4619, 0.6913, 0.5556),
			new Point3d(-0.5879, 0.5879, 0.5556),
			new Point3d(-0.6913, 0.4619, 0.5556),
			new Point3d(-0.7682, 0.3182, 0.5556),
			new Point3d(-0.8155, 0.1622, 0.5556),
			new Point3d(-0.8315, -0.0, 0.5556),
			new Point3d(-0.8155, -0.1622, 0.5556),
			new Point3d(-0.7682, -0.3182, 0.5556),
			new Point3d(-0.6913, -0.4619, 0.5556),
			new Point3d(-0.5879, -0.5879, 0.5556),
			new Point3d(-0.4619, -0.6913, 0.5556),
			new Point3d(-0.3182, -0.7682, 0.5556),
			new Point3d(-0.1622, -0.8155, 0.5556),
			new Point3d(0.0, -0.8315, 0.5556),
			new Point3d(0.1622, -0.8155, 0.5556),
			new Point3d(0.3182, -0.7682, 0.5556),
			new Point3d(0.4619, -0.6913, 0.5556),
			new Point3d(0.5879, -0.5879, 0.5556),
			new Point3d(0.6913, -0.4619, 0.5556),
			new Point3d(0.7682, -0.3182, 0.5556),
			new Point3d(0.8155, -0.1622, 0.5556),
			new Point3d(0.8315, 0.0, 0.5556),
			new Point3d(0.8155, 0.1622, 0.5556),
			new Point3d(0.7682, 0.3182, 0.5556),
			new Point3d(0.6913, 0.4619, 0.5556),
			new Point3d(0.5879, 0.5879, 0.5556),
			new Point3d(0.4619, 0.6913, 0.5556),
			new Point3d(0.3182, 0.7682, 0.5556),
			new Point3d(0.1622, 0.8155, 0.5556),
			new Point3d(-0.0, 0.9239, 0.3827),
			new Point3d(-0.1802, 0.9061, 0.3827),
			new Point3d(-0.3536, 0.8536, 0.3827),
			new Point3d(-0.5133, 0.7682, 0.3827),
			new Point3d(-0.6533, 0.6533, 0.3827),
			new Point3d(-0.7682, 0.5133, 0.3827),
			new Point3d(-0.8536, 0.3536, 0.3827),
			new Point3d(-0.9061, 0.1802, 0.3827),
			new Point3d(-0.9239, -0.0, 0.3827),
			new Point3d(-0.9061, -0.1802, 0.3827),
			new Point3d(-0.8536, -0.3536, 0.3827),
			new Point3d(-0.7682, -0.5133, 0.3827),
			new Point3d(-0.6533, -0.6533, 0.3827),
			new Point3d(-0.5133, -0.7682, 0.3827),
			new Point3d(-0.3536, -0.8536, 0.3827),
			new Point3d(-0.1802, -0.9061, 0.3827),
			new Point3d(0.0, -0.9239, 0.3827),
			new Point3d(0.1802, -0.9061, 0.3827),
			new Point3d(0.3536, -0.8536, 0.3827),
			new Point3d(0.5133, -0.7682, 0.3827),
			new Point3d(0.6533, -0.6533, 0.3827),
			new Point3d(0.7682, -0.5133, 0.3827),
			new Point3d(0.8536, -0.3536, 0.3827),
			new Point3d(0.9061, -0.1802, 0.3827),
			new Point3d(0.9239, 0.0, 0.3827),
			new Point3d(0.9061, 0.1802, 0.3827),
			new Point3d(0.8536, 0.3536, 0.3827),
			new Point3d(0.7682, 0.5133, 0.3827),
			new Point3d(0.6533, 0.6533, 0.3827),
			new Point3d(0.5133, 0.7682, 0.3827),
			new Point3d(0.3536, 0.8536, 0.3827),
			new Point3d(0.1802, 0.9061, 0.3827),
			new Point3d(-0.0, 0.9808, 0.1951),
			new Point3d(-0.1913, 0.9619, 0.1951),
			new Point3d(-0.3753, 0.9061, 0.1951),
			new Point3d(-0.5449, 0.8155, 0.1951),
			new Point3d(-0.6935, 0.6935, 0.1951),
			new Point3d(-0.8155, 0.5449, 0.1951),
			new Point3d(-0.9061, 0.3753, 0.1951),
			new Point3d(-0.9619, 0.1913, 0.1951),
			new Point3d(-0.9808, -0.0, 0.1951),
			new Point3d(-0.9619, -0.1913, 0.1951),
			new Point3d(-0.9061, -0.3753, 0.1951),
			new Point3d(-0.8155, -0.5449, 0.1951),
			new Point3d(-0.6935, -0.6935, 0.1951),
			new Point3d(-0.5449, -0.8155, 0.1951),
			new Point3d(-0.3753, -0.9061, 0.1951),
			new Point3d(-0.1913, -0.9619, 0.1951),
			new Point3d(0.0, -0.9808, 0.1951),
			new Point3d(0.1913, -0.9619, 0.1951),
			new Point3d(0.3753, -0.9061, 0.1951),
			new Point3d(0.5449, -0.8155, 0.1951),
			new Point3d(0.6935, -0.6935, 0.1951),
			new Point3d(0.8155, -0.5449, 0.1951),
			new Point3d(0.9061, -0.3753, 0.1951),
			new Point3d(0.9619, -0.1913, 0.1951),
			new Point3d(0.9808, 0.0, 0.1951),
			new Point3d(0.9619, 0.1913, 0.1951),
			new Point3d(0.9061, 0.3753, 0.1951),
			new Point3d(0.8155, 0.5449, 0.1951),
			new Point3d(0.6935, 0.6935, 0.1951),
			new Point3d(0.5449, 0.8155, 0.1951),
			new Point3d(0.3753, 0.9061, 0.1951),
			new Point3d(0.1913, 0.9619, 0.1951),
			new Point3d(-0.0, 1.0, -0.0),
			new Point3d(-0.1951, 0.9808, -0.0),
			new Point3d(-0.3827, 0.9239, -0.0),
			new Point3d(-0.5556, 0.8315, -0.0),
			new Point3d(-0.7071, 0.7071, -0.0),
			new Point3d(-0.8315, 0.5556, -0.0),
			new Point3d(-0.9239, 0.3827, -0.0),
			new Point3d(-0.9808, 0.1951, -0.0),
			new Point3d(-1.0, -0.0, -0.0),
			new Point3d(-0.9808, -0.1951, -0.0),
			new Point3d(-0.9239, -0.3827, -0.0),
			new Point3d(-0.8315, -0.5556, -0.0),
			new Point3d(-0.7071, -0.7071, -0.0),
			new Point3d(-0.5556, -0.8315, -0.0),
			new Point3d(-0.3827, -0.9239, -0.0),
			new Point3d(-0.1951, -0.9808, -0.0),
			new Point3d(0.0, -1.0, -0.0),
			new Point3d(0.1951, -0.9808, -0.0),
			new Point3d(0.3827, -0.9239, -0.0),
			new Point3d(0.5556, -0.8315, -0.0),
			new Point3d(0.7071, -0.7071, -0.0),
			new Point3d(0.8315, -0.5556, -0.0),
			new Point3d(0.9239, -0.3827, -0.0),
			new Point3d(0.9808, -0.1951, -0.0),
			new Point3d(1.0, 0.0, -0.0),
			new Point3d(0.9808, 0.1951, -0.0),
			new Point3d(0.9239, 0.3827, -0.0),
			new Point3d(0.8315, 0.5556, -0.0),
			new Point3d(0.7071, 0.7071, -0.0),
			new Point3d(0.5556, 0.8315, -0.0),
			new Point3d(0.3827, 0.9239, -0.0),
			new Point3d(0.1951, 0.9808, -0.0),
			new Point3d(-0.0, 0.9808, -0.1951),
			new Point3d(-0.1913, 0.9619, -0.1951),
			new Point3d(-0.3753, 0.9061, -0.1951),
			new Point3d(-0.5449, 0.8155, -0.1951),
			new Point3d(-0.6935, 0.6935, -0.1951),
			new Point3d(-0.8155, 0.5449, -0.1951),
			new Point3d(-0.9061, 0.3753, -0.1951),
			new Point3d(-0.9619, 0.1913, -0.1951),
			new Point3d(-0.9808, -0.0, -0.1951),
			new Point3d(-0.9619, -0.1913, -0.1951),
			new Point3d(-0.9061, -0.3753, -0.1951),
			new Point3d(-0.8155, -0.5449, -0.1951),
			new Point3d(-0.6935, -0.6935, -0.1951),
			new Point3d(-0.5449, -0.8155, -0.1951),
			new Point3d(-0.3753, -0.9061, -0.1951),
			new Point3d(-0.1913, -0.9619, -0.1951),
			new Point3d(0.0, -0.9808, -0.1951),
			new Point3d(0.1913, -0.9619, -0.1951),
			new Point3d(0.3753, -0.9061, -0.1951),
			new Point3d(0.5449, -0.8155, -0.1951),
			new Point3d(0.6935, -0.6935, -0.1951),
			new Point3d(0.8155, -0.5449, -0.1951),
			new Point3d(0.9061, -0.3753, -0.1951),
			new Point3d(0.9619, -0.1913, -0.1951),
			new Point3d(0.9808, 0.0, -0.1951),
			new Point3d(0.9619, 0.1913, -0.1951),
			new Point3d(0.9061, 0.3753, -0.1951),
			new Point3d(0.8155, 0.5449, -0.1951),
			new Point3d(0.6935, 0.6935, -0.1951),
			new Point3d(0.5449, 0.8155, -0.1951),
			new Point3d(0.3753, 0.9061, -0.1951),
			new Point3d(0.1913, 0.9619, -0.1951),
			new Point3d(-0.0, 0.9239, -0.3827),
			new Point3d(-0.1802, 0.9061, -0.3827),
			new Point3d(-0.3536, 0.8536, -0.3827),
			new Point3d(-0.5133, 0.7682, -0.3827),
			new Point3d(-0.6533, 0.6533, -0.3827),
			new Point3d(-0.7682, 0.5133, -0.3827),
			new Point3d(-0.8536, 0.3536, -0.3827),
			new Point3d(-0.9061, 0.1802, -0.3827),
			new Point3d(-0.9239, -0.0, -0.3827),
			new Point3d(-0.9061, -0.1802, -0.3827),
			new Point3d(-0.8536, -0.3536, -0.3827),
			new Point3d(-0.7682, -0.5133, -0.3827),
			new Point3d(-0.6533, -0.6533, -0.3827),
			new Point3d(-0.5133, -0.7682, -0.3827),
			new Point3d(-0.3536, -0.8536, -0.3827),
			new Point3d(-0.1802, -0.9061, -0.3827),
			new Point3d(0.0, -0.9239, -0.3827),
			new Point3d(0.1802, -0.9061, -0.3827),
			new Point3d(0.3536, -0.8536, -0.3827),
			new Point3d(0.5133, -0.7682, -0.3827),
			new Point3d(0.6533, -0.6533, -0.3827),
			new Point3d(0.7682, -0.5133, -0.3827),
			new Point3d(0.8536, -0.3536, -0.3827),
			new Point3d(0.9061, -0.1802, -0.3827),
			new Point3d(0.9239, 0.0, -0.3827),
			new Point3d(0.9061, 0.1802, -0.3827),
			new Point3d(0.8536, 0.3536, -0.3827),
			new Point3d(0.7682, 0.5133, -0.3827),
			new Point3d(0.6533, 0.6533, -0.3827),
			new Point3d(0.5133, 0.7682, -0.3827),
			new Point3d(0.3536, 0.8536, -0.3827),
			new Point3d(0.1802, 0.9061, -0.3827),
			new Point3d(-0.0, 0.8315, -0.5556),
			new Point3d(-0.1622, 0.8155, -0.5556),
			new Point3d(-0.3182, 0.7682, -0.5556),
			new Point3d(-0.4619, 0.6913, -0.5556),
			new Point3d(-0.5879, 0.5879, -0.5556),
			new Point3d(-0.6913, 0.4619, -0.5556),
			new Point3d(-0.7682, 0.3182, -0.5556),
			new Point3d(-0.8155, 0.1622, -0.5556),
			new Point3d(-0.8315, -0.0, -0.5556),
			new Point3d(-0.8155, -0.1622, -0.5556),
			new Point3d(-0.7682, -0.3182, -0.5556),
			new Point3d(-0.6913, -0.4619, -0.5556),
			new Point3d(-0.5879, -0.5879, -0.5556),
			new Point3d(-0.4619, -0.6913, -0.5556),
			new Point3d(-0.3182, -0.7682, -0.5556),
			new Point3d(-0.1622, -0.8155, -0.5556),
			new Point3d(0.0, -0.8315, -0.5556),
			new Point3d(0.1622, -0.8155, -0.5556),
			new Point3d(0.3182, -0.7682, -0.5556),
			new Point3d(0.4619, -0.6913, -0.5556),
			new Point3d(0.5879, -0.5879, -0.5556),
			new Point3d(0.6913, -0.4619, -0.5556),
			new Point3d(0.7682, -0.3182, -0.5556),
			new Point3d(0.8155, -0.1622, -0.5556),
			new Point3d(0.8315, 0.0, -0.5556),
			new Point3d(0.8155, 0.1622, -0.5556),
			new Point3d(0.7682, 0.3182, -0.5556),
			new Point3d(0.6913, 0.4619, -0.5556),
			new Point3d(0.5879, 0.5879, -0.5556),
			new Point3d(0.4619, 0.6913, -0.5556),
			new Point3d(0.3182, 0.7682, -0.5556),
			new Point3d(0.1622, 0.8155, -0.5556),
			new Point3d(-0.0, 0.7071, -0.7071),
			new Point3d(-0.1379, 0.6935, -0.7071),
			new Point3d(-0.2706, 0.6533, -0.7071),
			new Point3d(-0.3928, 0.5879, -0.7071),
			new Point3d(-0.5, 0.5, -0.7071),
			new Point3d(-0.5879, 0.3928, -0.7071),
			new Point3d(-0.6533, 0.2706, -0.7071),
			new Point3d(-0.6935, 0.1379, -0.7071),
			new Point3d(-0.7071, -0.0, -0.7071),
			new Point3d(-0.6935, -0.1379, -0.7071),
			new Point3d(-0.6533, -0.2706, -0.7071),
			new Point3d(-0.5879, -0.3928, -0.7071),
			new Point3d(-0.5, -0.5, -0.7071),
			new Point3d(-0.3928, -0.5879, -0.7071),
			new Point3d(-0.2706, -0.6533, -0.7071),
			new Point3d(-0.1379, -0.6935, -0.7071),
			new Point3d(0.0, -0.7071, -0.7071),
			new Point3d(0.1379, -0.6935, -0.7071),
			new Point3d(0.2706, -0.6533, -0.7071),
			new Point3d(0.3928, -0.5879, -0.7071),
			new Point3d(0.5, -0.5, -0.7071),
			new Point3d(0.5879, -0.3928, -0.7071),
			new Point3d(0.6533, -0.2706, -0.7071),
			new Point3d(0.6935, -0.1379, -0.7071),
			new Point3d(0.7071, 0.0, -0.7071),
			new Point3d(0.6935, 0.1379, -0.7071),
			new Point3d(0.6533, 0.2706, -0.7071),
			new Point3d(0.5879, 0.3928, -0.7071),
			new Point3d(0.5, 0.5, -0.7071),
			new Point3d(0.3928, 0.5879, -0.7071),
			new Point3d(0.2706, 0.6533, -0.7071),
			new Point3d(0.1379, 0.6935, -0.7071),
			new Point3d(-0.0, 0.5556, -0.8315),
			new Point3d(-0.1084, 0.5449, -0.8315),
			new Point3d(-0.2126, 0.5133, -0.8315),
			new Point3d(-0.3087, 0.4619, -0.8315),
			new Point3d(-0.3928, 0.3928, -0.8315),
			new Point3d(-0.4619, 0.3087, -0.8315),
			new Point3d(-0.5133, 0.2126, -0.8315),
			new Point3d(-0.5449, 0.1084, -0.8315),
			new Point3d(-0.5556, -0.0, -0.8315),
			new Point3d(-0.5449, -0.1084, -0.8315),
			new Point3d(-0.5133, -0.2126, -0.8315),
			new Point3d(-0.4619, -0.3087, -0.8315),
			new Point3d(-0.3928, -0.3928, -0.8315),
			new Point3d(-0.3087, -0.4619, -0.8315),
			new Point3d(-0.2126, -0.5133, -0.8315),
			new Point3d(-0.1084, -0.5449, -0.8315),
			new Point3d(0.0, -0.5556, -0.8315),
			new Point3d(0.1084, -0.5449, -0.8315),
			new Point3d(0.2126, -0.5133, -0.8315),
			new Point3d(0.3087, -0.4619, -0.8315),
			new Point3d(0.3928, -0.3928, -0.8315),
			new Point3d(0.4619, -0.3087, -0.8315),
			new Point3d(0.5133, -0.2126, -0.8315),
			new Point3d(0.5449, -0.1084, -0.8315),
			new Point3d(0.5556, 0.0, -0.8315),
			new Point3d(0.5449, 0.1084, -0.8315),
			new Point3d(0.5133, 0.2126, -0.8315),
			new Point3d(0.4619, 0.3087, -0.8315),
			new Point3d(0.3928, 0.3928, -0.8315),
			new Point3d(0.3087, 0.4619, -0.8315),
			new Point3d(0.2126, 0.5133, -0.8315),
			new Point3d(0.1084, 0.5449, -0.8315),
			new Point3d(-0.0, 0.3827, -0.9239),
			new Point3d(-0.0747, 0.3753, -0.9239),
			new Point3d(-0.1464, 0.3536, -0.9239),
			new Point3d(-0.2126, 0.3182, -0.9239),
			new Point3d(-0.2706, 0.2706, -0.9239),
			new Point3d(-0.3182, 0.2126, -0.9239),
			new Point3d(-0.3536, 0.1464, -0.9239),
			new Point3d(-0.3753, 0.0747, -0.9239),
			new Point3d(-0.3827, -0.0, -0.9239),
			new Point3d(-0.3753, -0.0747, -0.9239),
			new Point3d(-0.3536, -0.1464, -0.9239),
			new Point3d(-0.3182, -0.2126, -0.9239),
			new Point3d(-0.2706, -0.2706, -0.9239),
			new Point3d(-0.2126, -0.3182, -0.9239),
			new Point3d(-0.1464, -0.3536, -0.9239),
			new Point3d(-0.0747, -0.3753, -0.9239),
			new Point3d(0.0, -0.3827, -0.9239),
			new Point3d(0.0747, -0.3753, -0.9239),
			new Point3d(0.1464, -0.3536, -0.9239),
			new Point3d(0.2126, -0.3182, -0.9239),
			new Point3d(0.2706, -0.2706, -0.9239),
			new Point3d(0.3182, -0.2126, -0.9239),
			new Point3d(0.3536, -0.1464, -0.9239),
			new Point3d(0.3753, -0.0747, -0.9239),
			new Point3d(0.3827, 0.0, -0.9239),
			new Point3d(0.3753, 0.0747, -0.9239),
			new Point3d(0.3536, 0.1464, -0.9239),
			new Point3d(0.3182, 0.2126, -0.9239),
			new Point3d(0.2706, 0.2706, -0.9239),
			new Point3d(0.2126, 0.3182, -0.9239),
			new Point3d(0.1464, 0.3536, -0.9239),
			new Point3d(0.0747, 0.3753, -0.9239),
			new Point3d(-0.0, 0.1951, -0.9808),
			new Point3d(-0.0381, 0.1913, -0.9808),
			new Point3d(-0.0747, 0.1802, -0.9808),
			new Point3d(-0.1084, 0.1622, -0.9808),
			new Point3d(-0.1379, 0.1379, -0.9808),
			new Point3d(-0.1622, 0.1084, -0.9808),
			new Point3d(-0.1802, 0.0747, -0.9808),
			new Point3d(-0.1913, 0.0381, -0.9808),
			new Point3d(-0.1951, -0.0, -0.9808),
			new Point3d(-0.1913, -0.0381, -0.9808),
			new Point3d(-0.1802, -0.0747, -0.9808),
			new Point3d(-0.1622, -0.1084, -0.9808),
			new Point3d(-0.1379, -0.1379, -0.9808),
			new Point3d(-0.1084, -0.1622, -0.9808),
			new Point3d(-0.0747, -0.1802, -0.9808),
			new Point3d(-0.0381, -0.1913, -0.9808),
			new Point3d(0.0, -0.1951, -0.9808),
			new Point3d(0.0381, -0.1913, -0.9808),
			new Point3d(0.0747, -0.1802, -0.9808),
			new Point3d(0.1084, -0.1622, -0.9808),
			new Point3d(0.1379, -0.1379, -0.9808),
			new Point3d(0.1622, -0.1084, -0.9808),
			new Point3d(0.1802, -0.0747, -0.9808),
			new Point3d(0.1913, -0.0381, -0.9808),
			new Point3d(0.1951, 0.0, -0.9808),
			new Point3d(0.1913, 0.0381, -0.9808),
			new Point3d(0.1802, 0.0747, -0.9808),
			new Point3d(0.1622, 0.1084, -0.9808),
			new Point3d(0.1379, 0.1379, -0.9808),
			new Point3d(0.1084, 0.1622, -0.9808),
			new Point3d(0.0747, 0.1802, -0.9808),
			new Point3d(0.0381, 0.1913, -0.9808),
			new Point3d(0.0, 0.0, -1.0)
	};
			
	public static final int[] DEFAULT_SPHERE_COORDINATES = new int[]{
			0, 1, 2,
			0, 2, 3,
			0, 3, 4,
			0, 4, 5,
			0, 5, 6,
			0, 6, 7,
			0, 7, 8,
			0, 8, 9,
			0, 9, 10,
			0, 10, 11,
			0, 11, 12,
			0, 12, 13,
			0, 13, 14,
			0, 14, 15,
			0, 15, 16,
			0, 16, 17,
			0, 17, 18,
			0, 18, 19,
			0, 19, 20,
			0, 20, 21,
			0, 21, 22,
			0, 22, 23,
			0, 23, 24,
			0, 24, 25,
			0, 25, 26,
			0, 26, 27,
			0, 27, 28,
			0, 28, 29,
			0, 29, 30,
			0, 30, 31,
			0, 31, 32,
			0, 32, 1,
			1, 33, 34,
			1, 34, 2,
			2, 34, 35,
			2, 35, 3,
			3, 35, 36,
			3, 36, 4,
			4, 36, 37,
			4, 37, 5,
			5, 37, 38,
			5, 38, 6,
			6, 38, 39,
			6, 39, 7,
			7, 39, 40,
			7, 40, 8,
			8, 40, 41,
			8, 41, 9,
			9, 41, 42,
			9, 42, 10,
			10, 42, 43,
			10, 43, 11,
			11, 43, 44,
			11, 44, 12,
			12, 44, 45,
			12, 45, 13,
			13, 45, 46,
			13, 46, 14,
			14, 46, 47,
			14, 47, 15,
			15, 47, 48,
			15, 48, 16,
			16, 48, 49,
			16, 49, 17,
			17, 49, 50,
			17, 50, 18,
			18, 50, 51,
			18, 51, 19,
			19, 51, 52,
			19, 52, 20,
			20, 52, 53,
			20, 53, 21,
			21, 53, 54,
			21, 54, 22,
			22, 54, 55,
			22, 55, 23,
			23, 55, 56,
			23, 56, 24,
			24, 56, 57,
			24, 57, 25,
			25, 57, 58,
			25, 58, 26,
			26, 58, 59,
			26, 59, 27,
			27, 59, 60,
			27, 60, 28,
			28, 60, 61,
			28, 61, 29,
			29, 61, 62,
			29, 62, 30,
			30, 62, 63,
			30, 63, 31,
			31, 63, 64,
			31, 64, 32,
			32, 64, 33,
			32, 33, 1,
			33, 65, 66,
			33, 66, 34,
			34, 66, 67,
			34, 67, 35,
			35, 67, 68,
			35, 68, 36,
			36, 68, 69,
			36, 69, 37,
			37, 69, 70,
			37, 70, 38,
			38, 70, 71,
			38, 71, 39,
			39, 71, 72,
			39, 72, 40,
			40, 72, 73,
			40, 73, 41,
			41, 73, 74,
			41, 74, 42,
			42, 74, 75,
			42, 75, 43,
			43, 75, 76,
			43, 76, 44,
			44, 76, 77,
			44, 77, 45,
			45, 77, 78,
			45, 78, 46,
			46, 78, 79,
			46, 79, 47,
			47, 79, 80,
			47, 80, 48,
			48, 80, 81,
			48, 81, 49,
			49, 81, 82,
			49, 82, 50,
			50, 82, 83,
			50, 83, 51,
			51, 83, 84,
			51, 84, 52,
			52, 84, 85,
			52, 85, 53,
			53, 85, 86,
			53, 86, 54,
			54, 86, 87,
			54, 87, 55,
			55, 87, 88,
			55, 88, 56,
			56, 88, 89,
			56, 89, 57,
			57, 89, 90,
			57, 90, 58,
			58, 90, 91,
			58, 91, 59,
			59, 91, 92,
			59, 92, 60,
			60, 92, 93,
			60, 93, 61,
			61, 93, 94,
			61, 94, 62,
			62, 94, 95,
			62, 95, 63,
			63, 95, 96,
			63, 96, 64,
			64, 96, 65,
			64, 65, 33,
			65, 97, 98,
			65, 98, 66,
			66, 98, 99,
			66, 99, 67,
			67, 99, 100,
			67, 100, 68,
			68, 100, 101,
			68, 101, 69,
			69, 101, 102,
			69, 102, 70,
			70, 102, 103,
			70, 103, 71,
			71, 103, 104,
			71, 104, 72,
			72, 104, 105,
			72, 105, 73,
			73, 105, 106,
			73, 106, 74,
			74, 106, 107,
			74, 107, 75,
			75, 107, 108,
			75, 108, 76,
			76, 108, 109,
			76, 109, 77,
			77, 109, 110,
			77, 110, 78,
			78, 110, 111,
			78, 111, 79,
			79, 111, 112,
			79, 112, 80,
			80, 112, 113,
			80, 113, 81,
			81, 113, 114,
			81, 114, 82,
			82, 114, 115,
			82, 115, 83,
			83, 115, 116,
			83, 116, 84,
			84, 116, 117,
			84, 117, 85,
			85, 117, 118,
			85, 118, 86,
			86, 118, 119,
			86, 119, 87,
			87, 119, 120,
			87, 120, 88,
			88, 120, 121,
			88, 121, 89,
			89, 121, 122,
			89, 122, 90,
			90, 122, 123,
			90, 123, 91,
			91, 123, 124,
			91, 124, 92,
			92, 124, 125,
			92, 125, 93,
			93, 125, 126,
			93, 126, 94,
			94, 126, 127,
			94, 127, 95,
			95, 127, 128,
			95, 128, 96,
			96, 128, 97,
			96, 97, 65,
			97, 129, 130,
			97, 130, 98,
			98, 130, 131,
			98, 131, 99,
			99, 131, 132,
			99, 132, 100,
			100, 132, 133,
			100, 133, 101,
			101, 133, 134,
			101, 134, 102,
			102, 134, 135,
			102, 135, 103,
			103, 135, 136,
			103, 136, 104,
			104, 136, 137,
			104, 137, 105,
			105, 137, 138,
			105, 138, 106,
			106, 138, 139,
			106, 139, 107,
			107, 139, 140,
			107, 140, 108,
			108, 140, 141,
			108, 141, 109,
			109, 141, 142,
			109, 142, 110,
			110, 142, 143,
			110, 143, 111,
			111, 143, 144,
			111, 144, 112,
			112, 144, 145,
			112, 145, 113,
			113, 145, 146,
			113, 146, 114,
			114, 146, 147,
			114, 147, 115,
			115, 147, 148,
			115, 148, 116,
			116, 148, 149,
			116, 149, 117,
			117, 149, 150,
			117, 150, 118,
			118, 150, 151,
			118, 151, 119,
			119, 151, 152,
			119, 152, 120,
			120, 152, 153,
			120, 153, 121,
			121, 153, 154,
			121, 154, 122,
			122, 154, 155,
			122, 155, 123,
			123, 155, 156,
			123, 156, 124,
			124, 156, 157,
			124, 157, 125,
			125, 157, 158,
			125, 158, 126,
			126, 158, 159,
			126, 159, 127,
			127, 159, 160,
			127, 160, 128,
			128, 160, 129,
			128, 129, 97,
			129, 161, 162,
			129, 162, 130,
			130, 162, 163,
			130, 163, 131,
			131, 163, 164,
			131, 164, 132,
			132, 164, 165,
			132, 165, 133,
			133, 165, 166,
			133, 166, 134,
			134, 166, 167,
			134, 167, 135,
			135, 167, 168,
			135, 168, 136,
			136, 168, 169,
			136, 169, 137,
			137, 169, 170,
			137, 170, 138,
			138, 170, 171,
			138, 171, 139,
			139, 171, 172,
			139, 172, 140,
			140, 172, 173,
			140, 173, 141,
			141, 173, 174,
			141, 174, 142,
			142, 174, 175,
			142, 175, 143,
			143, 175, 176,
			143, 176, 144,
			144, 176, 177,
			144, 177, 145,
			145, 177, 178,
			145, 178, 146,
			146, 178, 179,
			146, 179, 147,
			147, 179, 180,
			147, 180, 148,
			148, 180, 181,
			148, 181, 149,
			149, 181, 182,
			149, 182, 150,
			150, 182, 183,
			150, 183, 151,
			151, 183, 184,
			151, 184, 152,
			152, 184, 185,
			152, 185, 153,
			153, 185, 186,
			153, 186, 154,
			154, 186, 187,
			154, 187, 155,
			155, 187, 188,
			155, 188, 156,
			156, 188, 189,
			156, 189, 157,
			157, 189, 190,
			157, 190, 158,
			158, 190, 191,
			158, 191, 159,
			159, 191, 192,
			159, 192, 160,
			160, 192, 161,
			160, 161, 129,
			161, 193, 194,
			161, 194, 162,
			162, 194, 195,
			162, 195, 163,
			163, 195, 196,
			163, 196, 164,
			164, 196, 197,
			164, 197, 165,
			165, 197, 198,
			165, 198, 166,
			166, 198, 199,
			166, 199, 167,
			167, 199, 200,
			167, 200, 168,
			168, 200, 201,
			168, 201, 169,
			169, 201, 202,
			169, 202, 170,
			170, 202, 203,
			170, 203, 171,
			171, 203, 204,
			171, 204, 172,
			172, 204, 205,
			172, 205, 173,
			173, 205, 206,
			173, 206, 174,
			174, 206, 207,
			174, 207, 175,
			175, 207, 208,
			175, 208, 176,
			176, 208, 209,
			176, 209, 177,
			177, 209, 210,
			177, 210, 178,
			178, 210, 211,
			178, 211, 179,
			179, 211, 212,
			179, 212, 180,
			180, 212, 213,
			180, 213, 181,
			181, 213, 214,
			181, 214, 182,
			182, 214, 215,
			182, 215, 183,
			183, 215, 216,
			183, 216, 184,
			184, 216, 217,
			184, 217, 185,
			185, 217, 218,
			185, 218, 186,
			186, 218, 219,
			186, 219, 187,
			187, 219, 220,
			187, 220, 188,
			188, 220, 221,
			188, 221, 189,
			189, 221, 222,
			189, 222, 190,
			190, 222, 223,
			190, 223, 191,
			191, 223, 224,
			191, 224, 192,
			192, 224, 193,
			192, 193, 161,
			193, 225, 226,
			193, 226, 194,
			194, 226, 227,
			194, 227, 195,
			195, 227, 228,
			195, 228, 196,
			196, 228, 229,
			196, 229, 197,
			197, 229, 230,
			197, 230, 198,
			198, 230, 231,
			198, 231, 199,
			199, 231, 232,
			199, 232, 200,
			200, 232, 233,
			200, 233, 201,
			201, 233, 234,
			201, 234, 202,
			202, 234, 235,
			202, 235, 203,
			203, 235, 236,
			203, 236, 204,
			204, 236, 237,
			204, 237, 205,
			205, 237, 238,
			205, 238, 206,
			206, 238, 239,
			206, 239, 207,
			207, 239, 240,
			207, 240, 208,
			208, 240, 241,
			208, 241, 209,
			209, 241, 242,
			209, 242, 210,
			210, 242, 243,
			210, 243, 211,
			211, 243, 244,
			211, 244, 212,
			212, 244, 245,
			212, 245, 213,
			213, 245, 246,
			213, 246, 214,
			214, 246, 247,
			214, 247, 215,
			215, 247, 248,
			215, 248, 216,
			216, 248, 249,
			216, 249, 217,
			217, 249, 250,
			217, 250, 218,
			218, 250, 251,
			218, 251, 219,
			219, 251, 252,
			219, 252, 220,
			220, 252, 253,
			220, 253, 221,
			221, 253, 254,
			221, 254, 222,
			222, 254, 255,
			222, 255, 223,
			223, 255, 256,
			223, 256, 224,
			224, 256, 225,
			224, 225, 193,
			225, 257, 258,
			225, 258, 226,
			226, 258, 259,
			226, 259, 227,
			227, 259, 260,
			227, 260, 228,
			228, 260, 261,
			228, 261, 229,
			229, 261, 262,
			229, 262, 230,
			230, 262, 263,
			230, 263, 231,
			231, 263, 264,
			231, 264, 232,
			232, 264, 265,
			232, 265, 233,
			233, 265, 266,
			233, 266, 234,
			234, 266, 267,
			234, 267, 235,
			235, 267, 268,
			235, 268, 236,
			236, 268, 269,
			236, 269, 237,
			237, 269, 270,
			237, 270, 238,
			238, 270, 271,
			238, 271, 239,
			239, 271, 272,
			239, 272, 240,
			240, 272, 273,
			240, 273, 241,
			241, 273, 274,
			241, 274, 242,
			242, 274, 275,
			242, 275, 243,
			243, 275, 276,
			243, 276, 244,
			244, 276, 277,
			244, 277, 245,
			245, 277, 278,
			245, 278, 246,
			246, 278, 279,
			246, 279, 247,
			247, 279, 280,
			247, 280, 248,
			248, 280, 281,
			248, 281, 249,
			249, 281, 282,
			249, 282, 250,
			250, 282, 283,
			250, 283, 251,
			251, 283, 284,
			251, 284, 252,
			252, 284, 285,
			252, 285, 253,
			253, 285, 286,
			253, 286, 254,
			254, 286, 287,
			254, 287, 255,
			255, 287, 288,
			255, 288, 256,
			256, 288, 257,
			256, 257, 225,
			257, 289, 290,
			257, 290, 258,
			258, 290, 291,
			258, 291, 259,
			259, 291, 292,
			259, 292, 260,
			260, 292, 293,
			260, 293, 261,
			261, 293, 294,
			261, 294, 262,
			262, 294, 295,
			262, 295, 263,
			263, 295, 296,
			263, 296, 264,
			264, 296, 297,
			264, 297, 265,
			265, 297, 298,
			265, 298, 266,
			266, 298, 299,
			266, 299, 267,
			267, 299, 300,
			267, 300, 268,
			268, 300, 301,
			268, 301, 269,
			269, 301, 302,
			269, 302, 270,
			270, 302, 303,
			270, 303, 271,
			271, 303, 304,
			271, 304, 272,
			272, 304, 305,
			272, 305, 273,
			273, 305, 306,
			273, 306, 274,
			274, 306, 307,
			274, 307, 275,
			275, 307, 308,
			275, 308, 276,
			276, 308, 309,
			276, 309, 277,
			277, 309, 310,
			277, 310, 278,
			278, 310, 311,
			278, 311, 279,
			279, 311, 312,
			279, 312, 280,
			280, 312, 313,
			280, 313, 281,
			281, 313, 314,
			281, 314, 282,
			282, 314, 315,
			282, 315, 283,
			283, 315, 316,
			283, 316, 284,
			284, 316, 317,
			284, 317, 285,
			285, 317, 318,
			285, 318, 286,
			286, 318, 319,
			286, 319, 287,
			287, 319, 320,
			287, 320, 288,
			288, 320, 289,
			288, 289, 257,
			289, 321, 322,
			289, 322, 290,
			290, 322, 323,
			290, 323, 291,
			291, 323, 324,
			291, 324, 292,
			292, 324, 325,
			292, 325, 293,
			293, 325, 326,
			293, 326, 294,
			294, 326, 327,
			294, 327, 295,
			295, 327, 328,
			295, 328, 296,
			296, 328, 329,
			296, 329, 297,
			297, 329, 330,
			297, 330, 298,
			298, 330, 331,
			298, 331, 299,
			299, 331, 332,
			299, 332, 300,
			300, 332, 333,
			300, 333, 301,
			301, 333, 334,
			301, 334, 302,
			302, 334, 335,
			302, 335, 303,
			303, 335, 336,
			303, 336, 304,
			304, 336, 337,
			304, 337, 305,
			305, 337, 338,
			305, 338, 306,
			306, 338, 339,
			306, 339, 307,
			307, 339, 340,
			307, 340, 308,
			308, 340, 341,
			308, 341, 309,
			309, 341, 342,
			309, 342, 310,
			310, 342, 343,
			310, 343, 311,
			311, 343, 344,
			311, 344, 312,
			312, 344, 345,
			312, 345, 313,
			313, 345, 346,
			313, 346, 314,
			314, 346, 347,
			314, 347, 315,
			315, 347, 348,
			315, 348, 316,
			316, 348, 349,
			316, 349, 317,
			317, 349, 350,
			317, 350, 318,
			318, 350, 351,
			318, 351, 319,
			319, 351, 352,
			319, 352, 320,
			320, 352, 321,
			320, 321, 289,
			321, 353, 354,
			321, 354, 322,
			322, 354, 355,
			322, 355, 323,
			323, 355, 356,
			323, 356, 324,
			324, 356, 357,
			324, 357, 325,
			325, 357, 358,
			325, 358, 326,
			326, 358, 359,
			326, 359, 327,
			327, 359, 360,
			327, 360, 328,
			328, 360, 361,
			328, 361, 329,
			329, 361, 362,
			329, 362, 330,
			330, 362, 363,
			330, 363, 331,
			331, 363, 364,
			331, 364, 332,
			332, 364, 365,
			332, 365, 333,
			333, 365, 366,
			333, 366, 334,
			334, 366, 367,
			334, 367, 335,
			335, 367, 368,
			335, 368, 336,
			336, 368, 369,
			336, 369, 337,
			337, 369, 370,
			337, 370, 338,
			338, 370, 371,
			338, 371, 339,
			339, 371, 372,
			339, 372, 340,
			340, 372, 373,
			340, 373, 341,
			341, 373, 374,
			341, 374, 342,
			342, 374, 375,
			342, 375, 343,
			343, 375, 376,
			343, 376, 344,
			344, 376, 377,
			344, 377, 345,
			345, 377, 378,
			345, 378, 346,
			346, 378, 379,
			346, 379, 347,
			347, 379, 380,
			347, 380, 348,
			348, 380, 381,
			348, 381, 349,
			349, 381, 382,
			349, 382, 350,
			350, 382, 383,
			350, 383, 351,
			351, 383, 384,
			351, 384, 352,
			352, 384, 353,
			352, 353, 321,
			353, 385, 386,
			353, 386, 354,
			354, 386, 387,
			354, 387, 355,
			355, 387, 388,
			355, 388, 356,
			356, 388, 389,
			356, 389, 357,
			357, 389, 390,
			357, 390, 358,
			358, 390, 391,
			358, 391, 359,
			359, 391, 392,
			359, 392, 360,
			360, 392, 393,
			360, 393, 361,
			361, 393, 394,
			361, 394, 362,
			362, 394, 395,
			362, 395, 363,
			363, 395, 396,
			363, 396, 364,
			364, 396, 397,
			364, 397, 365,
			365, 397, 398,
			365, 398, 366,
			366, 398, 399,
			366, 399, 367,
			367, 399, 400,
			367, 400, 368,
			368, 400, 401,
			368, 401, 369,
			369, 401, 402,
			369, 402, 370,
			370, 402, 403,
			370, 403, 371,
			371, 403, 404,
			371, 404, 372,
			372, 404, 405,
			372, 405, 373,
			373, 405, 406,
			373, 406, 374,
			374, 406, 407,
			374, 407, 375,
			375, 407, 408,
			375, 408, 376,
			376, 408, 409,
			376, 409, 377,
			377, 409, 410,
			377, 410, 378,
			378, 410, 411,
			378, 411, 379,
			379, 411, 412,
			379, 412, 380,
			380, 412, 413,
			380, 413, 381,
			381, 413, 414,
			381, 414, 382,
			382, 414, 415,
			382, 415, 383,
			383, 415, 416,
			383, 416, 384,
			384, 416, 385,
			384, 385, 353,
			385, 417, 418,
			385, 418, 386,
			386, 418, 419,
			386, 419, 387,
			387, 419, 420,
			387, 420, 388,
			388, 420, 421,
			388, 421, 389,
			389, 421, 422,
			389, 422, 390,
			390, 422, 423,
			390, 423, 391,
			391, 423, 424,
			391, 424, 392,
			392, 424, 425,
			392, 425, 393,
			393, 425, 426,
			393, 426, 394,
			394, 426, 427,
			394, 427, 395,
			395, 427, 428,
			395, 428, 396,
			396, 428, 429,
			396, 429, 397,
			397, 429, 430,
			397, 430, 398,
			398, 430, 431,
			398, 431, 399,
			399, 431, 432,
			399, 432, 400,
			400, 432, 433,
			400, 433, 401,
			401, 433, 434,
			401, 434, 402,
			402, 434, 435,
			402, 435, 403,
			403, 435, 436,
			403, 436, 404,
			404, 436, 437,
			404, 437, 405,
			405, 437, 438,
			405, 438, 406,
			406, 438, 439,
			406, 439, 407,
			407, 439, 440,
			407, 440, 408,
			408, 440, 441,
			408, 441, 409,
			409, 441, 442,
			409, 442, 410,
			410, 442, 443,
			410, 443, 411,
			411, 443, 444,
			411, 444, 412,
			412, 444, 445,
			412, 445, 413,
			413, 445, 446,
			413, 446, 414,
			414, 446, 447,
			414, 447, 415,
			415, 447, 448,
			415, 448, 416,
			416, 448, 417,
			416, 417, 385,
			417, 449, 450,
			417, 450, 418,
			418, 450, 451,
			418, 451, 419,
			419, 451, 452,
			419, 452, 420,
			420, 452, 453,
			420, 453, 421,
			421, 453, 454,
			421, 454, 422,
			422, 454, 455,
			422, 455, 423,
			423, 455, 456,
			423, 456, 424,
			424, 456, 457,
			424, 457, 425,
			425, 457, 458,
			425, 458, 426,
			426, 458, 459,
			426, 459, 427,
			427, 459, 460,
			427, 460, 428,
			428, 460, 461,
			428, 461, 429,
			429, 461, 462,
			429, 462, 430,
			430, 462, 463,
			430, 463, 431,
			431, 463, 464,
			431, 464, 432,
			432, 464, 465,
			432, 465, 433,
			433, 465, 466,
			433, 466, 434,
			434, 466, 467,
			434, 467, 435,
			435, 467, 468,
			435, 468, 436,
			436, 468, 469,
			436, 469, 437,
			437, 469, 470,
			437, 470, 438,
			438, 470, 471,
			438, 471, 439,
			439, 471, 472,
			439, 472, 440,
			440, 472, 473,
			440, 473, 441,
			441, 473, 474,
			441, 474, 442,
			442, 474, 475,
			442, 475, 443,
			443, 475, 476,
			443, 476, 444,
			444, 476, 477,
			444, 477, 445,
			445, 477, 478,
			445, 478, 446,
			446, 478, 479,
			446, 479, 447,
			447, 479, 480,
			447, 480, 448,
			448, 480, 449,
			448, 449, 417,
			481, 450, 449,
			481, 451, 450,
			481, 452, 451,
			481, 453, 452,
			481, 454, 453,
			481, 455, 454,
			481, 456, 455,
			481, 457, 456,
			481, 458, 457,
			481, 459, 458,
			481, 460, 459,
			481, 461, 460,
			481, 462, 461,
			481, 463, 462,
			481, 464, 463,
			481, 465, 464,
			481, 466, 465,
			481, 467, 466,
			481, 468, 467,
			481, 469, 468,
			481, 470, 469,
			481, 471, 470,
			481, 472, 471,
			481, 473, 472,
			481, 474, 473,
			481, 475, 474,
			481, 476, 475,
			481, 477, 476,
			481, 478, 477,
			481, 479, 478,
			481, 480, 479,
			481, 449, 480
	};
}