package test;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.WorkspaceConfiguration;

import java.io.File;
import java.util.regex.Pattern;

public class FolderNavigation {
    
    private Shell shell;
    private Composite composite;
    private String currentFolder;
	private Shell popup;
	private Image arrow_down;
	private Image arrow_right;
	private File popupFolder=null;
    public FolderNavigation(Display display) {
        shell = new Shell(display);
        shell.setText("Folder Navigation");
        shell.setSize(800, 600);
        currentFolder = "C:\\ProgramData\\supercad\\icons"; // Default to user home folder
        composite = new Composite(shell, SWT.NONE);
        composite.setLayout(new RowLayout(SWT.HORIZONTAL));
		arrow_down = new Image(display, WorkspaceConfiguration.ICONS + File.separator + "down-arrow_16.png");
		arrow_right = new Image(display, WorkspaceConfiguration.ICONS + File.separator + "right-arrow_16.png");

        createNavigationBar();
        
    }
    
    private void createNavigationBar() {
        // Dispose previous contents
        composite.dispose();  
        
        // Create new composite and layout
        composite = new Composite(shell, SWT.NONE);
        composite.setLayout(new RowLayout(SWT.HORIZONTAL));

        createFileButtons(new File(currentFolder));

        // Create folder buttons for current folder
        composite.pack();
        shell.layout();  // Ensure layout is refreshed
    }
	
	private void createFileButtons(final File currentFolderFile) {
		if(currentFolderFile.getParentFile()!=null) {
			createFileButtons(currentFolderFile.getParentFile());
		}
		Button button = new Button(composite, SWT.PUSH);
		String folderName=currentFolderFile.getName();
		if(folderName==null||folderName.isEmpty()) {
			folderName=currentFolderFile.getPath();
			folderName=folderName.substring(0, folderName.lastIndexOf(File.separatorChar));
		}
		button.setText(folderName);
		button.addListener(SWT.Selection, e -> {
		    currentFolder = currentFolderFile.getAbsolutePath();  // Use tempPath as the new current folder
		    createNavigationBar();  // Recreate navigation bar with updated path
		    if(popup!=null && !popup.isDisposed()) {
	    		popup.dispose();
	    	}
		});
		// Right arrow button to show child folders
		Button arrowButton = new Button(composite, SWT.PUSH );
		// Using SWT's built-in arrow image
		arrowButton.setImage(arrow_right);
		arrowButton.setSize(16, 16);
		arrowButton.addListener(SWT.Selection, e -> {
			if(popup!=null && !popup.isDisposed() && currentFolderFile!=null && popupFolder!=null && popupFolder.equals(currentFolderFile)) {
				popup.dispose();
				arrowButton.setImage(arrow_right);
			}else
		    {
				arrowButton.setImage(arrow_down);
				showChildFolders(currentFolderFile,arrowButton.getLocation().x,arrowButton.getLocation().y+arrowButton.getSize().y);
		    }
		});
	}

    private void showChildFolders(File folder, int x,int y) {
    	if(popup!=null && !popup.isDisposed()) {
    		popup.dispose();
    	}
    	popupFolder=folder;
        popup = new Shell(shell,   SWT.NO_TRIM | SWT.ON_TOP);
        popup.setText("Child Folders of " + folder.getName());
        popup.setSize(250, 400);
        
        popup.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
        popup.setLayout(new RowLayout(SWT.VERTICAL));
        
        popup.setLocation(x+shell.getLocation().x,y+shell.getLocation().y+50);
        ScrolledComposite container = new ScrolledComposite(popup, SWT.V_SCROLL);
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		
		container.setAlwaysShowScrollBars(true);
        Composite childComposite = new Composite(container, SWT.NONE);
        childComposite.setLayout(new RowLayout(SWT.VERTICAL));
        childComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

        File[] subFolders = folder.listFiles();
        if (subFolders != null && subFolders.length > 0) {
            for (File subFolder : subFolders) {
                Button folderButton = new Button(childComposite, SWT.PUSH);
                folderButton.setText(subFolder.getName());
                folderButton.addListener(SWT.Selection, e -> {
                    currentFolder = subFolder.getAbsolutePath();
                    createNavigationBar();  // Update the navigation bar
                    popup.dispose();
                });
            }
        }
        childComposite.pack();
        container.setContent(childComposite);
		container.setMinSize(childComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
        childComposite.pack();
        container.pack();
        popup.layout();
        popup.setSize(container.computeSize(SWT.DEFAULT, SWT.DEFAULT).x,600);
        shell.addListener(SWT.FOCUSED, e->{
        	popup.setVisible(false);
        });
        
        popup.open();
    }
    
    public void open() {
//        createNavigationBar();
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay()!=null &&!shell.getDisplay().readAndDispatch()) {
                shell.getDisplay().sleep();
            }
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        FolderNavigation app = new FolderNavigation(display);
        app.open();
//        display.dispose();
    }
}
