package tech.frsdev.solids;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Vector3d;

import com.badlogic.gdx.math.Vector3;

import dressing.model.types.Orientation;

public interface Solide3D 
{
	double getXSize();
	double getYSize();
	double getZSize();
	double getXPosition();
	double getYPosition();
	double getZPosition();
	double getXPosABS();
	double getYPosABS();
	double getZPosABS();
	List<Solide3D> getChildren();
	Solide3D getParent();
	BufferedImage getImage();
	boolean isdrawable();
	Boolean isSelected();
	boolean isVisible();
	abstract void setSelected(Boolean selected) ;
	default Boolean isHighlighted() {
		return isSelected();
		
	}
	default double getVolume() {
		return getXSize()*getYSize()* getZSize();
		
	}

	default  double gettransparency()
	{
		return  1;
	}
	default boolean  hasMember(Solide3D sld) {
		if(sld==null)
			return false;
		if(this.equals(sld))
			return true;
		for(Solide3D child : getChildren())
		{
			if(child.hasMember(sld))
			{
				return true;
			}
		}
		return false;
	}
	default boolean  isDirectlyDelatable()
	{
			return true;
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le X
	 * Comme les cote et les seprateurs verticlae
	 */
	public default boolean isVerticallPiece()
	{
		return this.getXSize()<this.getYSize() && this.getXSize()<this.getZSize();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Y
	 * Comme les les etageres
	 */
	public default boolean isHorizontalePiece()
	{
		return this.getYSize()<this.getXSize() && this.getYSize()<this.getZSize();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Z
	 * Comme le dos
	 */
	public default boolean isProfondPiece()
	{
		return this.getZSize()<this.getXSize() && this.getZSize()<this.getYSize();
	}
	
	public default Orientation getPieceOrientation() {
		if (isHorizontalePiece()) {
			return Orientation.HORIZONTAL;
		} else if (isProfondPiece()) {
			return Orientation.PROUFOUND;
		} else {
			return Orientation.VERTICAL;
		}
	}
	public AxisAngle4d getRotation();
	public default Vector3d getDeviate() {
		float x=0;
		float y=0;
		float z=0;
//		if (getParent() != null ) {
////			if (this instanceof Piece2D) {
//			float dev=200.0f;
//				if (isHorizontalePiece()) {
//					if ((((DesignObject3D)this).getYPosABS()  + getYSize() / 2)<= ((DesignObject3D)this).getRoot().getYSize() / 2) {
//						y = (float) ( -dev);//+(Math.abs((getYPosition()+ getYSize() -(getParent().getYSize() / 2))))*0.01f);
//					} else {
//						y = (float) (dev);//+(Math.abs((getYPosition()+ getYSize() -(getParent().getYSize() / 2))))*0.01f);
//					}
//				}
//				if (!(this instanceof Space3D)&& isProfondPiece()) {
//					if ((((DesignObject3D)this).getZPosABS()+ getZSize() / 2)  <= ((DesignObject3D)this).getRoot().getZSize() / 2) {
//						z = (float) (-dev);//*Math.abs((getZPosition()+ getZSize() -(getParent().getZSize() / 2))))*0.01f;
//					} else {
//						z = (float) (dev);//*Math.abs((getZPosition()+ getZSize() -(getParent().getZSize() / 2))))*0.01f;
//					}
//				}
//					if ((((DesignObject3D)this).getXPosABS()  + getXSize() / 2) <= ((DesignObject3D)this).getRoot().getXSize() / 2) {
//						x = (float) (-dev);//*Math.abs((getXPosition()+ getXSize() -(getParent().getXSize() / 2))))*0.01f;
//					} else {
//						x = (float) (dev);//*Math.abs((getXPosition()+ getXSize() -(getParent().getXSize() / 2))))*0.01f;
//					}
//					if (isVerticallPiece()) {
//						x*=2;
//					}
//
////			}
////			x += getParent().getDeviate().x;
////			y += getParent().getDeviate().y;
////			z += getParent().getDeviate().z;
//		}
//		else if(getParent()!=null) {
//			if(getYPosition()+getYSize()/2<=getParent().getYSize()/2)
//			{
//				y=-500.0f;
//			}else {
//				y=500.0f;
//			}
//			if(getZPosition()+getZSize()/2<=getParent().getZSize()/2)
//			{
//				z=-500.0f;
//			}else {
//				z=500.0f;
//			}
//			if(getXPosition()+getXSize()/2<=getParent().getXSize()/2)
//			{
//				x=-500.0f;
//			}else {
//				x=500.0f;
//			}
//		}
			Vector3d deviate=new Vector3d(x,y,z);
			if(getParent()!=null)
			{
				deviate.add(getParent().getDeviate());
			}
		return deviate;
	}
	public default void openFacade(boolean open){
		for (Solide3D child : getChildren()) {
			child.openFacade(open);
		}
	}
	
	public default Vector3 getSize() {
		return new Vector3((float) getXSize(), (float) getYSize(), (float) getZSize());
	}
	
	public default Vector3 getPosition() {
		return new Vector3((float) getXPosition(), (float) getYPosition(), (float) getZPosition());
	}
	
	default public <T extends Solide3D> void  getChildrenByType( Class<T> clazz, ArrayList<T> out) {
		for(Solide3D solid: getChildren()) {
			if(clazz.isInstance(solid))
				out.add((T) solid);
			solid.getChildrenByType(clazz, out);
		}
	}
}
