package tech.frsdev.solids;

/* Auteur: Nicolas JANEY */ /* nicolas.janey@univ-fcomte.fr */ /* Novembre 2001 */ import java.applet.Applet;
import java.awt.*;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.AmbientLight;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.DirectionalLight;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.RotationInterpolator;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Texture2D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.applet.MainFrame;
import org.jogamp.java3d.utils.geometry.Box;
import org.jogamp.java3d.utils.geometry.Cylinder;
import org.jogamp.java3d.utils.image.TextureLoader;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3f;
import org.jogamp.vecmath.AxisAngle4d;
import java.net.*;

public class SimpleTransparency extends Applet {
	static boolean applet = true;
	private String base;

	private Texture chercheTexture(String s) {
		if (applet) {
			try {
				String adresse = base + s;
				URL u1 = new URL(adresse);
				return (new TextureLoader(u1, this).getTexture());
			} catch (MalformedURLException e) {
				return (new Texture2D());
			}
		} else
			try {
				return (new TextureLoader(ImageIO.read(new File("pictures/color.jpg")), this).getTexture());
			} catch (IOException e) {
				return null;
			}
	}

	public BranchGroup createSceneGraph(SimpleUniverse u) {
		BranchGroup objRoot = new BranchGroup();
		BoundingSphere largeBounds;
		largeBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
		{
			Vector3f ldir = new Vector3f(1.0F, 1.0F, -2.0F);
			Color3f lcouldl = new Color3f(1.0F, 1.0F, 1.0F);
			DirectionalLight dl = new DirectionalLight(lcouldl, ldir);
			dl.setInfluencingBounds(largeBounds);
			objRoot.addChild(dl);
		}
		{
			Color3f lcoulal = new Color3f(0.3F, 0.3F, 0.1F);
			AmbientLight al = new AmbientLight(lcoulal);
			al.setInfluencingBounds(largeBounds);
			objRoot.addChild(al);
		}
		{
			TransformGroup objTrans = new TransformGroup();
			objRoot.addChild(objTrans);
			Transform3D t3D = new Transform3D();
			t3D.setTranslation(new Vector3f(0.0f, 0.0f, -5.0f));
			objTrans.setTransform(t3D);
			Appearance a = new Appearance();
			Texture t = chercheTexture("Bois.jpg");
			a.setTexture(t);
			objTrans.addChild(new Box(3.0F, 3.0F, 0.1F, Box.GENERATE_TEXTURE_COORDS, a));
		}
		{
			TransformGroup objTrans1 = new TransformGroup();
			objRoot.addChild(objTrans1);
			objTrans1.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
			Transform3D yAxis = new Transform3D();
			Alpha rotationAlpha;
			rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE, 0, 0, 4000, 0, 0, 0, 0, 0);
			RotationInterpolator rotator;
			rotator = new RotationInterpolator(rotationAlpha, objTrans1, yAxis, 0.0f, (float) Math.PI * 2.0f);
			rotator.setSchedulingBounds(largeBounds);
			objTrans1.addChild(rotator);
			Appearance a = new Appearance();
			Material m = new Material();
			m.setDiffuseColor(0.1f, 0.9f, 0.9f);
			m.setSpecularColor(1.0f, 0.0f, 0.0f);
			m.setAmbientColor(0.9f, 0.9f, 0.9f);
			m.setShininess(25.0f);
			a.setMaterial(m);
			TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.NICEST, 0.7F);
			a.setTransparencyAttributes(ta);
			TransformGroup objTrans2 = new TransformGroup();
			objTrans1.addChild(objTrans2);
			Transform3D t3D = new Transform3D();
			t3D.setRotation(new AxisAngle4d(1.0, 1.0, 0.0, Math.PI / 5.0));
			objTrans2.setTransform(t3D);
			objTrans2.addChild(new Cylinder(0.5F, 1.0F, 1, 50, 50, a));
		}
		objRoot.compile();
		return objRoot;
	}

	public void lanceJava3D() {
		setLayout(new BorderLayout());
		GraphicsConfiguration config;
		config = SimpleUniverse.getPreferredConfiguration();
		Canvas3D c = new Canvas3D(config);
		add("Center", c);
		SimpleUniverse u = new SimpleUniverse(c);
		BranchGroup scene = createSceneGraph(u);
		u.getViewingPlatform().setNominalViewingTransform();
		u.addBranchGraph(scene);
	}

	public void init() {
		if (applet) {
			URL url = this.getCodeBase();
			base = url.toString();
			lanceJava3D();
		}
	}

	public SimpleTransparency() {
		if (!applet) {
			lanceJava3D();
		}
	}

	public static void main(String[] args) {
		applet = false;
		new MainFrame(new SimpleTransparency(), 300, 250);
	}
}