package tech.frsdev.j3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;
import dressing.model.Point3D;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.types.PieceType;
import tech.frsdev.solids.Solide3D;

public class DressingDrawer {

	private Solide3D solide3d;
	ArrayList<Piece2D> piecelist = new ArrayList<Piece2D>();
	ArrayList<Space3D> spaceslist = new ArrayList<Space3D>();
	ArrayList<Mesure> mesuresX = new ArrayList<Mesure>();
	ArrayList<Mesure> mesuresY = new ArrayList<Mesure>();
	public DressingDrawer(Solide3D solide3d) {
		super();
		this.solide3d = solide3d;
	}
	
	public void draw(Graphics2D g)
	{
		piecelist.clear();
		spaceslist.clear();
		mesuresX.clear();		
		mesuresY.clear();
		g.scale(0.15, 0.15);
		g.translate(800, solide3d.getYSize()+100);
		drawchilds(g,this.solide3d);	
//		genrateMesureBetweenPieces(piecelist, mesuresX,Mesure.MESUREX);
		genrateMesureBetweenSapces(spaceslist, mesuresX, Mesure.MESUREX);
		drawmesures(g,mesuresX);
//		genrateMesureBetweenPieces(piecelist, mesuresY,Mesure.MESUREY);
		genrateMesureBetweenSapces(spaceslist, mesuresY, Mesure.MESUREY);
		drawmesures(g,mesuresY);
	    g.translate(-800, -solide3d.getYSize()+100);
	    g.scale(1/0.15,1/ 0.15);
	    
		
		
		
		int debug = 0;
		debug++;
	}
	private void drawmesures(Graphics2D g, ArrayList<Mesure> mesures) {
		// TODO Auto-generated method stub
		g.setFont(g.getFont().deriveFont(40.0f)); 
		int levelsize=50;
		for(Mesure  m : mesures)
		{
			if(m.getAxe()==Mesure.MESUREX)
			{
				PlanUsinage perspect = PlanUsinage.FRONT;
				BasicStroke strk = new BasicStroke(3);
				Point3D  p3d = m.getConvertedPoin1tIn2D(perspect);
				Point p = new Point((int)p3d.getX(), (int)p3d.getY());		
				g.setColor(Color.BLACK);	
				g.setStroke(strk);		
				g.drawString(""+(int)m.getValue()+"", p.x+(int)m.getValue()/2,  100+m.getLevel()*levelsize);
				g.drawLine(p.x, 60+m.getLevel()*levelsize, p.x+(int)m.getValue(), 60+m.getLevel()*levelsize);
				g.drawLine(p.x, 40+m.getLevel()*levelsize, p.x, 80+m.getLevel()*levelsize);
				g.drawLine(p.x+(int)m.getValue(), 40+m.getLevel()*levelsize,p.x+(int)m.getValue(), 80+m.getLevel()*levelsize);
	
			
			}
			else if(m.getAxe()==Mesure.MESUREY)
			{
				PlanUsinage perspect = PlanUsinage.FRONT;
				BasicStroke strk = new BasicStroke(3);
				Point3D  p3d = m.getConvertedPoin1tIn2D(perspect);
				Point p = new Point((int)p3d.getX(), (int)p3d.getY());		
				g.setColor(Color.BLACK);	
				g.setStroke(strk);		
				g.rotate(Math.PI/2);
				g.drawString(""+(int)m.getValue()+"", p.y-(int)m.getValue()/2 , 100 + m.getLevel()*levelsize );				
				g.rotate(-Math.PI/2);
				
				g.drawLine(-60-m.getLevel()*levelsize, p.y, -60-m.getLevel()*levelsize, p.y-(int)m.getValue());
				g.drawLine(-40-m.getLevel()*levelsize,p.y, -80-m.getLevel()*levelsize,p.y);
				g.drawLine(-40-m.getLevel()*levelsize,p.y-(int)m.getValue(), -80-m.getLevel()*levelsize,p.y-(int)m.getValue());
			
			}
		}
	}

	private  void drawchilds(Graphics2D g,Solide3D solide3d)
	{
		for(Solide3D sld: solide3d.getChildren())
		{
			if(sld instanceof Piece2D)
			{
				if(!((Piece2D) sld).getPiecetype().equals(PieceType.DOS_INTERIEUR))
				{
					drawpiece((Piece2D)sld,g);
					piecelist.add((Piece2D)sld);
				}
				
			}
			else if(sld instanceof Space3D)
			{
				spaceslist.add((Space3D) sld);
			}
				
		   if(sld.getChildren().size()>0)
			{
				drawchilds(g,sld);
			}
		}
		

	}

	
	
	
	private void drawpiece(Piece2D sld, Graphics2D g) {
		// TODO Auto-generated method stub
		PlanUsinage perspect = PlanUsinage.FRONT;
		BasicStroke strk = new BasicStroke(3);

		
		int dimx = (int) sld.getWidth(perspect);
		int dimy = (int) sld.getHight(perspect);
		Point3D  p3d = sld.getConvertedPointIn2D(perspect);
		Point p = new Point((int)p3d.getX(), (int)p3d.getY());		
		g.setColor(Color.BLACK);	
		g.setStroke(strk);		
		g.drawRect(p.x, p.y, dimx, dimy);

		
	}

	private void genrateMesureBetweenSapces(List<Space3D> spaces,List<Mesure> mesures,int mesureaxe)
	{
		//sort spaces 
		if(mesureaxe== Mesure.MESUREY)
		{
			Collections.sort(spaces, new Comparator<Space3D>() {

				@Override
				public int compare(Space3D o1, Space3D o2) {
					// TODO Auto-generated method stub
					if(o1.getXPosABS()>o2.getXPosABS())
					{
						return 1;
					}
					else if(o1.getXPosABS()<o2.getXPosABS())
					{
						return -1;
					}
					return 0;
				}
			});
		}

		for(int i=0;i<spaces.size();i++)
		{
			Space3D space = spaces.get(i);
			if(mesureaxe== Mesure.MESUREY)
			{
				double ecartexterneinterneY = (space.getHauteurext()-space.getHauteurint())/2;
				if(space instanceof Space3DFree)
				{
					Point3D p1 =new Point3D(space.getXPosABS(), space.getYPosABS(), space.getYpos());
					Point3D p2 =new Point3D(space.getXPosABS(), space.getYPosABS()+space.getHauteurext(), space.getYpos());
					Mesure m  = new Mesure(p1, p2, Mesure.MESUREY, p2.getY() - p1.getY(),0);
					if(!mesures.contains(m))
					mesures.add(m);
				}
				else
				{
					Point3D p1 =new Point3D(space.getXPosABS(), space.getYPosABS()+ecartexterneinterneY, space.getYpos());
					Point3D p2 =new Point3D(space.getXPosABS(), space.getYPosABS()+space.getHauteurint()+ecartexterneinterneY, space.getYpos());
					Mesure m  = new Mesure(p1, p2, Mesure.MESUREY, p2.getY() - p1.getY(),0);
					if(!mesures.contains(m))
					mesures.add(m);
				}
				generateMesuresBetweenEtagere(space,mesures);
			}
			else if(mesureaxe==Mesure.MESUREX)
			{
				double ecartexterneinterneX = (space.getLongeurext()-space.getLongeurint())/2;
				if(space instanceof Space3DFree )
				{
					Point3D p1 =new Point3D(space.getXPosABS(), space.getYPosABS(), space.getYpos());
					Point3D p2 =new Point3D(space.getXPosABS()+space.getLongeurext(), space.getYPosABS(), space.getYpos());
					Mesure m  = new Mesure(p1, p2, Mesure.MESUREX, p2.getX() - p1.getX(),0);
					if(!mesures.contains(m))
					mesures.add(m);
				}
				else
				{
					Point3D p1 =new Point3D(space.getXPosABS()+ecartexterneinterneX, space.getYPosABS(), space.getYpos());
					Point3D p2 =new Point3D(space.getXPosABS()+ecartexterneinterneX+space.getLongeurint(), space.getYPosABS(), space.getYpos());
					Mesure m  = new Mesure(p1, p2, Mesure.MESUREX, p2.getX() - p1.getX(),0);
					if(!mesures.contains(m))
					mesures.add(m);
				}
			}

			


		}
		organiseSpacelevels2(mesures,mesureaxe);
//		organiseSpacelevels(mesures,mesureaxe);
//		organiseSpacelevels(mesures,mesureaxe);
	}
	private void generateMesuresBetweenEtagere(Space3D space, List<Mesure> mesures) {
		// TODO Auto-generated method stub
		if(space.getChilds().isEmpty())
			return;
		
		List<Piece2D> etagres = new ArrayList<Piece2D>();
		
		
		if(etagres.isEmpty())
			return;
		
		Collections.sort(etagres, new Comparator<Piece2D>() {

			@Override
			public int compare(Piece2D o1, Piece2D o2) {
				// TODO Auto-generated method stub
			
				if(o1.getYPosABS()<o2.getYPosABS())
				{
					return -1;
				}
				else if( o1.getYPosABS()>o2.getYPosABS())
				{
					return 1;
				}
				else
				{
					return 0;
				}
				
			}
		});
		
		double ecartexterneinterneY = (space.getHauteurext()-space.getHauteurint())/2;
		for(int i=0;i<etagres.size();i++)
		{
			Piece2D piece= etagres.get(i);
			if(i==0) //la premiere distance
			{
				Point3D p1 =new Point3D(space.getXPosABS(), space.getYPosABS()+ecartexterneinterneY, space.getZpos());
				Point3D p2 =new Point3D(space.getXPosABS(), piece.getYPosABS(), space.getZpos());
				Mesure m  = new Mesure(p1, p2, Mesure.MESUREY, p2.getY() - p1.getY(),0);
				if(!mesures.contains(m))
				mesures.add(m);
			}
		    if(i==etagres.size()-1) //la derniere distance
		    {
				
				Point3D p1 =new Point3D(space.getXPosABS(), piece.getYPosABS()+ecartexterneinterneY, space.getZpos());
				Point3D p2 =new Point3D(space.getXPosABS(), space.getYPosABS()+space.getHauteurint()+ecartexterneinterneY, space.getZpos());
				Mesure m  = new Mesure(p1, p2, Mesure.MESUREY, p2.getY() - p1.getY(),0);
				if(!mesures.contains(m))
				mesures.add(m);
		    }
		    if(i>0 ) //une piece au milieu 
		    {
		    	Piece2D pieceavant= etagres.get(i-1);
		    	Point3D p1 =new Point3D(space.getXPosABS(), pieceavant.getYPosABS()+ecartexterneinterneY, space.getZpos());
		    	Point3D p2 =new Point3D(space.getXPosABS(), piece.getYPosABS(), space.getZpos());
				
				Mesure m  = new Mesure(p1, p2, Mesure.MESUREY, p2.getY() - p1.getY(),0);
				if(!mesures.contains(m))
				mesures.add(m);
		    }
		}
		
		int debug=0;
		debug++;
	}

	private void organiseSpacelevels2(List<Mesure> mesures, int mesureaxe)
	{
		Collections.sort(mesures, new Comparator<Mesure>() {

			@Override
			public int compare(Mesure o1, Mesure o2) {
				// TODO Auto-generated method stub
				if(mesureaxe==Mesure.MESUREY)
				{
					if(o1.getPoint1().getX()>o2.getPoint1().getX())
					{
						return -1;
					}
					else if(o1.getPoint1().getX()<o2.getPoint1().getX())
					{
						return 1;
					}
					if(Math.abs(o1.getValue())>Math.abs(o2.getValue()))
					{
						return 1 ;
					}
					else if(Math.abs(o1.getValue())<Math.abs(o2.getValue()))
					{
						return -1;
					}
				}		
				else if(mesureaxe==Mesure.MESUREX)
				{
					if(o1.getPoint1().getY()>o2.getPoint1().getY())
					{
						return -1;
					}
					else if(o1.getPoint1().getY()<o2.getPoint1().getY())
					{
						return 1;
					}
					if(Math.abs(o1.getValue())>Math.abs(o2.getValue()))
					{
						return 1 ;
					}
					else if(Math.abs(o1.getValue())<Math.abs(o2.getValue()))
					{
						return -1;
					}
				}

				
				return 0;
			}});
		
		
		if(mesureaxe==Mesure.MESUREY)
		{
			int level = 0 ;
			Double lastx=null;
			for(int i=0;i<mesures.size();i++)
			{
					Mesure m0 = mesures.get(i);
					m0.setLevel(level);
				    if(lastx!=null)
				    {
				    	if(m0.getPoint1().getX()<lastx)
				    	{
				    		level++;
				    		m0.setLevel(level);
				    	}
				    	else if(i>1)
				    	{
				    		for(int j=0;j<i;j++)
				    		{
					    		Mesure m1 = mesures.get(j);
								if(m1.intersect(m0) && m1.getLevel()==m0.getLevel() && !m1.equals(m0))
								{
									level++;
						    		m0.setLevel(level);
						    		break;
								}
				    		}

				    	}
				    }

				    lastx = m0.getPoint1().getX();
					
			}
		}

		
		if(mesureaxe==Mesure.MESUREX)
		{
			int level = 0 ;
			Double lasty=null;
			for(int i=0;i<mesures.size();i++)
			{
					Mesure m0 = mesures.get(i);
					m0.setLevel(level);
				    if(lasty!=null)
				    {
				    	if(m0.getPoint1().getY()<lasty)
				    	{
				    		level++;
				    		m0.setLevel(level);
				    	}
				    	else if(i>1)
				    	{
				    		for(int j=0;j<i;j++)
				    		{
					    		Mesure m1 = mesures.get(j);
								if(m1.intersect(m0) && m1.getLevel()==m0.getLevel() && !m1.equals(m0))
								{
									level++;
						    		m0.setLevel(level);
						    		break;
								}
				    		}

				    	}
				    }

				    lasty = m0.getPoint1().getY();
					
			}
		}


		
		
		int debug=0;
		debug++;
	}
	
	private void organiseSpacelevels(List<Mesure> mesures, int mesureaxe)
	{
		Collections.sort(mesures, new Comparator<Mesure>() {

			@Override
			public int compare(Mesure o1, Mesure o2) {
				if(Math.abs(o1.getValue())>Math.abs(o2.getValue()))
					{
						return -1 ;
					}
					else if(Math.abs(o1.getValue())<Math.abs(o2.getValue()))
					{
						return 1;
					}
				
				return 0;
			}});
		
		int level = 0 ;
		
		if( mesures.size()>=2)
		{
			for(int i=1;i<mesures.size();i++)
			{
				Mesure m0 = mesures.get(i);
				for(Mesure m1 : mesures)
				{
					
					if(m1.intersect(m0) && m1.getLevel()==m0.getLevel() && !m1.equals(m0))
					{
						if(Math.abs(m1.getValue())<=Math.abs(m0.getValue()))
						m1.setLevel(m1.getLevel()-1);		
						else
						m0.setLevel(m0.getLevel()-1);			
						continue;
					}
				}
				
			}
		}


		
		
		int debug=0;
		debug++;
	}
	
	
	private void genrateMesureBetweenPieces(List<Piece2D> pieces,List<Mesure> mesures,int mesureaxe)
	{
		//sort collections
		
		if(mesureaxe==Mesure.MESUREX)
		{
			Collections.sort(pieces, new Comparator<Piece2D>() {

				@Override
				public int compare(Piece2D o1, Piece2D o2) {
					// TODO Auto-generated method stub
				
					if(o1.getXPosABS()<o2.getXPosABS())
					{
						return -1;
					}
					else if(o1.getXPosABS()==o2.getXPosABS())
					{
						return 0 ;
					}
					else
					{
						return 1;
						
					}
					
				}
			});
		}
		else if (mesureaxe==Mesure.MESUREY)
		{
			Collections.sort(pieces, new Comparator<Piece2D>() {

				@Override
				public int compare(Piece2D o1, Piece2D o2) {
					// TODO Auto-generated method stub
				
					if(o1.getYPosABS()<o2.getYPosABS())
					{
						return -1;
					}
					else if( o1.getYPosABS()>o2.getYPosABS())
					{
						return 1;
					}
					else
					{
						return 0;
					}
					
				}
			});
		}
		else
		{
			return; //non supporte
		}
			
		int i=0;
		REFPIECE:while(true)
		{
			
				if(i==pieces.size()-1)
					break;
				
				Piece2D sld1 = pieces.get(i);			
				SECONDPIECE:for(int j=i;j<pieces.size();j++)
				{
					Piece2D sld2 = pieces.get(j);
					if(sld1.equals(sld2))
						continue SECONDPIECE; //voire la prochaine piece sld2  SECONDPIECE
					
					
			
			}
			i++;
			
		}
		organiselevels(mesures,mesureaxe);
	}

	private void organiselevels(List<Mesure> mesures, int mesureaxe) {
		// TODO Auto-generated method stub
		
		Collections.sort(mesures, new Comparator<Mesure>() {

			@Override
			public int compare(Mesure o1, Mesure o2) {
				// TODO Auto-generated method stub
				if(o1.getValue()>o2.getValue())
				{
					return 1;					
				}
				else if(o1.getValue()<o2.getValue())
				{
					return -1;		
				}
				else
				{
					return 0;
				}
				
			}});
		
		
		
		A:for (Mesure m1  : mesures)
		{
			B:for (Mesure m2  : mesures)
			{
				if(!m1.equals(m2))
				{
					if(m1.intersect(m2))
					{
						if(Math.abs(m1.getValue())<Math.abs(m2.getValue()))
						{
							m2.setLevel(m1.getLevel()+1);	
						}
						else
						{
							m1.setLevel(m2.getLevel()+1);	
						}
										
					}
				}

			}
		}
		
		int debug=0;
		debug++;
		
	}
}

class Mesure
{
	public static final int MESUREX=0;
	public static final int MESUREY=1;
	public static final int MESUREZ=2;
	private Point3D point1;
	private Point3D point2;
	private int axe = MESUREX;
	private int level=8;
	private double value;
	private double ytranslate=0; //to convert from 3d to 2d
	
	public Mesure(Point3D point1, Point3D point2, int axe, double value,double ytranslate) {
		super();
		this.point1 = point1;
		this.point2 = point2;
		this.axe = axe;
		this.value = value;
		this.ytranslate = ytranslate;
	}
	public boolean intersect(Mesure m2) {
		// TODO Auto-generated method stub
		if(m2.getAxe()==MESUREX && this.getAxe()==MESUREX)
		{
			if(m2.getPoint2().getX()>this.getPoint1().getX())
			{
				double mesure1 = Math.abs(m2.getValue());
				double mesure2 = Math.abs(this.getValue());
				
				double total = Math.abs(m2.getPoint2().getX() - this.getPoint1().getX()) ; 
				if(total<mesure1+mesure2)
				{
					return true;
				}
			}

		}
		else if(m2.getAxe()==MESUREY && this.getAxe()==MESUREY)
		{
			if(m2.getPoint2().getY()>this.getPoint1().getY())
			{
				double mesure1 = Math.abs(m2.getValue());
				double mesure2 = Math.abs(this.getValue());
				
				double total = Math.abs(m2.getPoint2().getY() - this.getPoint1().getY()) ; 
				if(total<mesure1+mesure2)
				{
					return true;
				}
			}

		}
		return false;
	}
	/**
	 * Retouner le point la plus proche de 0,0
	 * @return
	 */
	public Point3D getPoint1() {
		return point1;
	}
	public void setPoint1(Point3D point1) {
		this.point1 = point1;
	}
	/**
	 * Retouner le point la plus eloigné de 0,0
	 * @return
	 */
	public Point3D getPoint2() {
		return point2;
	}
	public void setPoint2(Point3D point2) {
		this.point2 = point2;
	}
	public int getAxe() {
		return axe;
	}
	public void setAxe(int axe) {
		this.axe = axe;
	}
	public double getValue() {
		return value;
	}
	public void setValue(double value) {
		this.value = value;
	}
	public void setLevel(int level) {
		this.level = level;
	}
	public int getLevel() {
		return level;
	}
	/***
	 * Cette methode retourne le point par rapport au repore 2D
	 * @return
	 */
	public Point3D getConvertedPoin1tIn2D(PlanUsinage persp)
	{

		return convert(this.point1,persp);
		
	}
	/***
	 * Cette methode retourne le point par rapport au repore 2D
	 * @return
	 */
	public Point3D getConvertedPoin2tIn2D(PlanUsinage persp)
	{

		return convert(this.point2,persp);
		
	}
	private Point3D convert(Point3D point,PlanUsinage persp)
	{
		Point3D p = new Point3D();
		switch (persp) {
		case FRONT:
			p.setX(point.getX());
			p.setY(-point.getY() - this.ytranslate);
			p.setZ(0);
			break;

		default:
			
			break;
		}
		return p; 
	}
	
	@Override
	public boolean equals(Object obj) {
		// TODO Auto-generated method stub
		boolean equal =  super.equals(obj);
		if(equal==true)
			return  true;
		else {
			Mesure m = (Mesure) obj;
			if(this.value==m.value)
			{
				if(this.axe==m.axe)
				{
					if(this.axe==MESUREX)
					{
						if(m.point1.getX()==this.point1.getX() && m.point2.getX()==this.point2.getX())
						{
							return true;
						}
						if(m.point1.getX()==this.point2.getX() && m.point2.getX()==this.point1.getX())
						{
							return true;
						}
					}
					else if(this.axe==MESUREY)
					{
						if(m.point1.getY()==this.point1.getY() && m.point2.getY()==this.point2.getY())
						{
							return true;
						}
						if(m.point1.getY()==this.point2.getY() && m.point2.getY()==this.point1.getY())
						{
							return true;
						}
					}
				}
				
			}
		}
		return false;
	}
}
