package tech.frsdev.j3d;

import java.awt.image.BufferedImage;
import java.util.Iterator;

import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Texture2D;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.geometry.Box;
import org.jogamp.java3d.utils.image.TextureLoader;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.types.PieceType;
import tech.frsdev.solids.Solide3D;

public class BoxDraw extends TransformGroup{

	Solide3D solid;
	double refSize;
	float x,y,z;
	float dimxinit,dimyinit,dimzinit;
	Box box ;
	BranchGroup holdingbox;
	Vector3f vector= new Vector3f(0, 0, 0);
	Transform3D transform = new Transform3D();
	Appearance apparence = new Appearance();
	boolean selected=false;
	MousePieceTranslateBehavoiur mt =null;
	public static final ColoringAttributes SELECTION_COLOR_ATTRUBITE = new ColoringAttributes(new Color3f(90, 235, 60), ColoringAttributes.ALLOW_COLOR_WRITE);
	public static final TransparencyAttributes SPACE_SELCTED_TRANSPARENCY_ATRR = new TransparencyAttributes(TransparencyAttributes.NICEST, 0.7F);
	public static final TransparencyAttributes SPACE_UNSELCTED_TRANSPARENCY_ATRR = new TransparencyAttributes(TransparencyAttributes.NICEST, 1F);
	
     private boolean drawcorquis=false;
	public BoxDraw(Solide3D solid, double refsize) {
		super();
		this.solid = solid;
		this.refSize = refsize;

		init();
	}
	private void init()
	{

		this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		this.setCapability(TransformGroup.ALLOW_PARENT_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		this.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);

		if (solid!=null &&solid.isSelected() && solid.isdrawable())
		{
			apparence.setColoringAttributes(SELECTION_COLOR_ATTRUBITE);
			TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.NICEST, 0.2F);
			apparence.setTransparencyAttributes(ta);
		}
		else
		{
//			
			addTexture(apparence, solid.getImage());

//			apparence.setMaterial(mat);
			TransparencyAttributes taq = new TransparencyAttributes(TransparencyAttributes.SCREEN_DOOR|TransparencyAttributes.NICEST, (float) solid.gettransparency());
			apparence.setTransparencyAttributes(taq);
			
			
		}

		if(!solid.isdrawable())
		{
			apparence.setColoringAttributes(SELECTION_COLOR_ATTRUBITE);
			apparence.setTransparencyAttributes(SPACE_UNSELCTED_TRANSPARENCY_ATRR);
		}

		PolygonAttributes pl = new PolygonAttributes();
		pl.setPolygonMode(PolygonAttributes.POLYGON_FILL);	
		apparence.setPolygonAttributes(pl);

		
		
		apparence.setCapability(Appearance.ALLOW_COLORING_ATTRIBUTES_WRITE);
		apparence.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);
		dimxinit =(float) (solid.getXSize() / refSize);
		dimyinit =(float) (solid.getYSize() / refSize);
		dimzinit = (float) (solid.getZSize() / refSize);
		regenreatebox(dimxinit, dimyinit, dimzinit);
		boolean mousemovsupport = false;
		double xfactor=0;
		double yfactor=0;
		if( solid instanceof Piece2D)
		{
			Piece2D p = (Piece2D)solid;
			if(p.getPiecetype().equals(PieceType.ETAGERE_FIXE) || p.getPiecetype().equals(PieceType.ETAGERE_MOBILE)
			   || p.getPiecetype().equals(PieceType.HAUT_CUISSON) )
			{
				mousemovsupport = true;
				yfactor=0.003;
			}
			else if(p.getPiecetype().equals(PieceType.GAUCHE_CUISSON)  || p.getPiecetype().equals(PieceType.DROITE_CUISSON))
			{
				mousemovsupport = true;
				xfactor=0.003;
			}
				
		}
		if(mousemovsupport){
            mt = new MousePieceTranslateBehavoiur(this);
			mt.setSchedulingBounds(new BoundingBox());
			mt.setFactor(xfactor, yfactor);
			mt.setEnable(false);
			this.addChild(mt);

		}
		

	}
	
	
	void addTexture(Appearance app, BufferedImage textureName) {
		if(textureName!=null)
		{
			TextureLoader loader = new TextureLoader(textureName);
			ImageComponent2D image = loader.getImage();

			Texture2D texture = new Texture2D(Texture.BASE_LEVEL, Texture.RGBA, image.getWidth(), image.getHeight());
			texture.setImage(0, image);
			texture.setEnable(true);
			texture.setMagFilter(Texture.BASE_LEVEL_LINEAR);
			texture.setMinFilter(Texture.BASE_LEVEL_LINEAR);
			
			app.setTexture(texture);
			TextureAttributes textureAt = new TextureAttributes();
			textureAt.setTextureMode(TextureAttributes.COMBINE);
			app.setTextureAttributes(textureAt);

		}
	
	}
	
	public Box getBox() {
		return box;
	}
	private void redraw()
	{
		DesignObject3D designsolid = (DesignObject3D) solid;
		System.out.println("Redraw :"+designsolid.getName());
		float dimx = (float) (solid.getXSize() / refSize);
		float dimy = (float) (solid.getYSize() / refSize);
		float dimz = (float) (solid.getZSize() / refSize);
		
//		 if(dimx!=dimxinit || dimy!=dimyinit || dimz!=dimzinit)
//		 {
//			 regenreatebox(dimx,dimy,dimz);
//		 }
//		 else
		 {
			 x = (float) (designsolid.getXPosABS() *2   + solid.getXSize())/(float)refSize;
			 y = (float) (designsolid.getYPosABS() *2   + solid.getYSize())/(float)refSize;
			 z = (float) (designsolid.getZPosABS() *2   + solid.getZSize())/(float)refSize;

			 vector.set(x,y, z);
			 Vector3d scale  =  new Vector3d();
			 transform.getScale(scale);
			 transform.setScale(new Vector3d(dimx/dimxinit, dimy/dimyinit, dimz/dimzinit));
			 transform.setTranslation(vector);
			 this.setTransform(transform);
		 }

	}
	
	private void regenreatebox(float dimx, float dimy, float dimz) {
		// TODO Auto-generated method stub
		dimxinit = dimx;
		dimyinit = dimy;
		dimzinit = dimz;
		DesignObject3D designsolid = (DesignObject3D) solid;
		if(box!=null && holdingbox!=null)
		{
			box.setUserData(null);
			this.removeChild(holdingbox);
		}
		
		
		Appearance appearancedebug = new Appearance();
		ColoringAttributes coloringAttributesdebug = new ColoringAttributes();
		coloringAttributesdebug.setColor(new Color3f(1,1,1));
		appearancedebug.setColoringAttributes(coloringAttributesdebug);
		appearancedebug.setTransparencyAttributes(new TransparencyAttributes(TransparencyAttributes.FASTEST, 1));
		
	    box = new Box(dimxinit,dimyinit ,dimzinit , Box.GENERATE_TEXTURE_COORDS | Box.GENERATE_NORMALS| Box.FRONT, appearancedebug);
		box.setName(solid.isdrawable()?"Piece":"Espace 3D");
		box.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		box.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		box.setCapability(Box.ALLOW_CHILDREN_READ);
		box.setCapability(Box.ALLOW_PARENT_READ);
		box.setCapability(BranchGroup.ALLOW_DETACH);
		Iterator<Node> shapes  = box.getAllChildren();
		while(shapes.hasNext())
		{
			Node node = shapes.next();
			node.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
			node.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		}
		box.setUserData(this);
		box.setName(designsolid.isdrawable()?"Piece":"Espace 3D");
		
		 x = (float) (designsolid.getXPosABS() *2   + solid.getXSize())/(float)refSize;
		 y = (float) (designsolid.getYPosABS() *2   + solid.getYSize())/(float)refSize;
		 z = (float) (designsolid.getZPosABS() *2   + solid.getZSize())/(float)refSize;

		 vector.set(x,y, z);

		transform.setTranslation(vector);
		holdingbox = new BranchGroup();
		holdingbox.setCapability(BranchGroup.ALLOW_DETACH);
		holdingbox.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
		holdingbox.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		holdingbox.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
		holdingbox.setCapability(BranchGroup.ALLOW_PARENT_READ);
		holdingbox.addChild(box);
		//ADD Line Draw
		//back line
		
		if(!isDrawcorquis())
		{
			box.setAppearance(this.apparence);
		}
		
		boolean lindraw = true;
			if(solid instanceof Piece2D)
			{
				if(!((Piece2D) solid).getPiecetype().equals(PieceType.DOS_INTERIEUR))
				{
		
					if(lindraw)
					{
						//vue derierre
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f(0,0,0));
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							appearanceGreen.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE,0));
							LineArray lineX = new LineArray(8, LineArray.COORDINATES);
							lineX.setCoordinate(0, new Point3f(xp0, yp0, zp0));
							lineX.setCoordinate(1, new Point3f((float) (solid.getXSize()/refSize)  , yp0, zp0));
							
							lineX.setCoordinate(2, new Point3f((float) (solid.getXSize()/refSize)  , yp0, zp0));
							lineX.setCoordinate(3, new Point3f((float) (solid.getXSize()/refSize)  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							
							lineX.setCoordinate(4, new Point3f((float) (solid.getXSize()/refSize)  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							lineX.setCoordinate(5, new Point3f(xp0  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							
							lineX.setCoordinate(6, new Point3f(xp0  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							lineX.setCoordinate(7, new Point3f(xp0, yp0, zp0));
							

							holdingbox.addChild(new Shape3D(lineX,appearanceGreen));
						}

						
						//vue de face
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = + (float) (solid.getZSize()/((float)refSize));
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f(0,0,0));
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							
							LineArray lineX = new LineArray(8, LineArray.COORDINATES);
							lineX.setCoordinate(0, new Point3f(xp0, yp0, zp0));
							lineX.setCoordinate(1, new Point3f((float) (solid.getXSize()/refSize)  , yp0, zp0));
							
							lineX.setCoordinate(2, new Point3f((float) (solid.getXSize()/refSize)  , yp0, zp0));
							lineX.setCoordinate(3, new Point3f((float) (solid.getXSize()/refSize)  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							
							lineX.setCoordinate(4, new Point3f((float) (solid.getXSize()/refSize)  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							lineX.setCoordinate(5, new Point3f(xp0  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							
							lineX.setCoordinate(6, new Point3f(xp0  ,  (float) (solid.getYSize()/((float)refSize)), zp0));
							lineX.setCoordinate(7, new Point3f(xp0, yp0, zp0));
							holdingbox.addChild(new Shape3D(lineX,appearanceGreen));
						}
						
						
						
						//vue de gauche 
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f(0,0,0));
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							
							LineArray lineX = new LineArray(8, LineArray.COORDINATES);
							lineX.setCoordinate(0, new Point3f(xp0, yp0, zp0));
							lineX.setCoordinate(1, new Point3f(xp0  , yp0, -zp0));
							
							lineX.setCoordinate(2, new Point3f(xp0  , yp0, -zp0));
							lineX.setCoordinate(3, new Point3f(xp0  , -yp0, -zp0));
//							
							lineX.setCoordinate(4, new Point3f(xp0  , -yp0, -zp0));
							lineX.setCoordinate(5, new Point3f(xp0  , -yp0, zp0));
//							
							lineX.setCoordinate(6, new Point3f(xp0  , -yp0, zp0));
							lineX.setCoordinate(7, new Point3f(xp0, yp0, zp0));
							holdingbox.addChild(new Shape3D(lineX,appearanceGreen));
						}
						
						//vue de droite 
						{
							float xp0 =  (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f(0,0,0));
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							
							LineArray lineX = new LineArray(8, LineArray.COORDINATES);
							lineX.setCoordinate(0, new Point3f(xp0, yp0, zp0));
							lineX.setCoordinate(1, new Point3f(xp0  , yp0, -zp0));
							
							lineX.setCoordinate(2, new Point3f(xp0  , yp0, -zp0));
							lineX.setCoordinate(3, new Point3f(xp0  , -yp0, -zp0));
//							
							lineX.setCoordinate(4, new Point3f(xp0  , -yp0, -zp0));
							lineX.setCoordinate(5, new Point3f(xp0  , -yp0, zp0));
//							
							lineX.setCoordinate(6, new Point3f(xp0  , -yp0, zp0));
							lineX.setCoordinate(7, new Point3f(xp0, yp0, zp0));
							holdingbox.addChild(new Shape3D(lineX,appearanceGreen));
						}
						
					}
					else
					{
						//vue derierre
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f());
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							QuadArray polygon1 = new QuadArray (4, QuadArray.COORDINATES);
					    	polygon1.setCoordinate (0, new Point3f (xp0, yp0, zp0));
					    	polygon1.setCoordinate (1, new Point3f (-xp0, yp0, zp0));
					    	polygon1.setCoordinate (2, new Point3f (-xp0, -yp0, zp0));
					    	polygon1.setCoordinate (3, new Point3f (xp0, -yp0, zp0));
					    	
					    	holdingbox.addChild(new Shape3D(polygon1,appearanceGreen));
						}
						
						//vue face
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f());
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							QuadArray polygon1 = new QuadArray (4, QuadArray.COORDINATES);
					    	polygon1.setCoordinate (0, new Point3f (xp0, yp0, -zp0));
					    	polygon1.setCoordinate (1, new Point3f (-xp0, yp0, -zp0));
					    	polygon1.setCoordinate (2, new Point3f (-xp0, -yp0, -zp0));
					    	polygon1.setCoordinate (3, new Point3f (xp0, -yp0, -zp0));
					    	
					    	holdingbox.addChild(new Shape3D(polygon1,appearanceGreen));
						}
						//vue gauche
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f());
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							QuadArray polygon1 = new QuadArray (4, QuadArray.COORDINATES);
					    	polygon1.setCoordinate (0, new Point3f (xp0, yp0, zp0));
					    	polygon1.setCoordinate (1, new Point3f (xp0, yp0, -zp0));
					    	polygon1.setCoordinate (2, new Point3f (xp0, -yp0, -zp0));
					    	polygon1.setCoordinate (3, new Point3f (xp0, -yp0, zp0));
					    	
					    	holdingbox.addChild(new Shape3D(polygon1,appearanceGreen));
						}
						
						//vue droite
						{
							float xp0 = - (float) (solid.getXSize()/((float)refSize));
							float yp0 = - (float) (solid.getYSize()/((float)refSize));
							float zp0 = - (float) (solid.getZSize()/((float)refSize));
							
							Appearance appearanceGreen = new Appearance();
							ColoringAttributes coloringAttributesGreen = new ColoringAttributes();
							coloringAttributesGreen.setColor(new Color3f());
							appearanceGreen.setColoringAttributes(coloringAttributesGreen);
							QuadArray polygon1 = new QuadArray (4, QuadArray.COORDINATES);
					    	polygon1.setCoordinate (0, new Point3f (-xp0, yp0, zp0));
					    	polygon1.setCoordinate (1, new Point3f (-xp0, yp0, -zp0));
					    	polygon1.setCoordinate (2, new Point3f (-xp0, -yp0, -zp0));
					    	polygon1.setCoordinate (3, new Point3f (-xp0, -yp0, zp0));
					    	
					    	holdingbox.addChild(new Shape3D(polygon1,appearanceGreen));
						}
					}
					
					
					
					
				}


			}
		
		this.addChild(holdingbox );
		this.setTransform(transform);
		
	}
	
	private void regenreateboxwithrelativetranslation(float dimx, float dimy, float dimz) {
		// TODO Auto-generated method stub
		dimxinit = dimx;
		dimyinit = dimy;
		dimzinit = dimz;
		if(box!=null && holdingbox!=null)
		{
			box.setUserData(null);
			this.removeChild(holdingbox);
		}
	    box = new Box(dimxinit,dimyinit ,dimzinit , Box.GENERATE_TEXTURE_COORDS | Box.GENERATE_NORMALS| Box.FRONT, apparence);
		box.setName(solid.isdrawable()?"Piece":"Espace 3D");
		box.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		box.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		box.setCapability(Box.ALLOW_CHILDREN_READ);
		box.setCapability(Box.ALLOW_PARENT_READ);
		box.setCapability(BranchGroup.ALLOW_DETACH);
		Iterator<Node> shapes  = box.getAllChildren();
		while(shapes.hasNext())
		{
			Node node = shapes.next();
			node.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
			node.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		}
		box.setUserData(this);
		box.setName(solid.isdrawable()?"Piece":"Espace 3D");
		
		 x = (float) (solid.getXPosition() *2   - solid.getParent().getXSize() + solid.getXSize())/(float)refSize;
		 y = (float) (solid.getYPosition() *2 - solid.getParent().getYSize() + solid.getYSize())/(float)refSize;
		 z = (float) (solid.getZPosition() *2  - solid.getParent().getZSize() + solid.getZSize())/(float)refSize;
		 vector.set(x, y, z);

		transform.setTranslation(vector);
		holdingbox = new BranchGroup();
		holdingbox.setCapability(BranchGroup.ALLOW_DETACH);
		holdingbox.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
		holdingbox.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		holdingbox.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
		holdingbox.setCapability(BranchGroup.ALLOW_PARENT_READ);
		holdingbox.addChild(box);
		this.addChild(holdingbox );
		this.setTransform(transform);
		
	}
	public void redrewall()
	{
		Node node  = holdingbox.getParent().getParent().getParent();
		TransformGroup tg  = (TransformGroup) node;
		Iterator<Node> shapes = tg.getAllChildren();
		while(shapes.hasNext()) 
		{
		  Object o = 	shapes.next()	;
          if(o instanceof BranchGroup )
		  {
        	  BranchGroup bg = (BranchGroup) o;
        	  Iterator<Node> boxes =  bg.getAllChildren();
      			while(boxes.hasNext()) 
      			{
      				Object ch = 	boxes.next();
      				if(ch instanceof BoxDraw)
      				{
      	        	  BoxDraw bx = ((BoxDraw) ch);
      	        	  if(bx.getSolid() instanceof Piece2D && bx.getSolid().isdrawable() )
      	        	  {
      	        		  ((BoxDraw) ch).redraw();
      	        	  }
      				  if(bx.getSolid() instanceof Space3D)
      				  {
      					  ((BoxDraw) ch).redraw();
      				  }
      				}
      				if(ch instanceof DimDraw)
					{
						((DimDraw)ch).redraw();
					}
      			}
        	  

		  }
          else if( o instanceof BoxDraw)
          {
        	  ((BoxDraw) o).redraw();
          }
          else if(o instanceof DimDraw)
          {
        	  ((DimDraw)o).redraw();
          }
		}
		
	}
	public void select()
	{
		if(solid instanceof Piece2D)
		{
			this.apparence.setColoringAttributes(SELECTION_COLOR_ATTRUBITE);
		}
		else if(solid instanceof Space3D)
		{
			this.apparence.setTransparencyAttributes(SPACE_SELCTED_TRANSPARENCY_ATRR);
		}
		box.setAppearance(this.apparence);
		selected = true;
		if(mt!=null)
			mt.setEnable(true);
		
	}
	
	public void unselect()
	{
		if(solid instanceof Piece2D)
		{
			this.apparence.setColoringAttributes(null);
		}
		else if(solid instanceof Space3D)
		{
			this.apparence.setTransparencyAttributes(SPACE_UNSELCTED_TRANSPARENCY_ATRR);
		}

		box.setAppearance(this.apparence);
		selected = true;
		if(mt!=null)
			mt.setEnable(false);
	}
	
	public boolean isSelected() {
		return selected;
	}
	public Solide3D getSolid() {
		return solid;
	}
	public void setDrawcorquis(boolean drawcorquis) {
		this.drawcorquis = drawcorquis;
	}
	
	public boolean isDrawcorquis() {
		return drawcorquis;
	}
}
