package tech.frsdev.j3d;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

import javax.imageio.ImageIO;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.image.TextureLoader;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3f;
import org.osgi.framework.Bundle;

import dressing.model.Space3D;
import dressing.model.Space3DFree;
import tech.frsdev.solids.Solide3D;

public class ArmoioreCanvasReporting {
	private Canvas3D canvas;
	private BranchGroup branchGroup;
	private SimpleUniverse univ;
	private TransformGroup dressingtransformgroup;
	private TransformGroup planstransformgroup;
	private Solide3D solide3d;
	private TransformGroup transformGroupRotation;
	private BranchGroup branchGroupRoot;
	private BranchGroup branchGroupinterim;
	double refSize;
	boolean offscreemode = true;
	public ArmoioreCanvasReporting(Solide3D solide3d,boolean offscren) {
		super();
		this.solide3d = solide3d;
		this.offscreemode = offscren;
		GraphicsConfigTemplate3D gct3D= new GraphicsConfigTemplate3D();
		gct3D.setSceneAntialiasing(GraphicsConfigTemplate3D.REQUIRED);
		GraphicsConfiguration gc= java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gct3D);
		
		refSize = Math.max(Math.max(this.solide3d.getXSize(), this.solide3d.getYSize()), this.solide3d.getZSize());
		refSize = refSize * 2;
		
		canvas = new Canvas3D(gc,this.offscreemode);
		
		univ = new SimpleUniverse(canvas);
		univ.getViewingPlatform().setNominalViewingTransform();
		univ.getViewer().getView().setSceneAntialiasingEnable(true);
		branchGroup  = createSceneGraph();
		
		BranchGroup collect = new BranchGroup();
		TransformGroup tf = new TransformGroup();
		
		double xsize = this.solide3d.getXSize();
		double ysize = this.solide3d.getYSize();
		double zsize = this.solide3d.getZSize();
		
		double scale = zsize/refSize;
		Transform3D t3 = new Transform3D();
		t3.setTranslation(new  Vector3f(0,0,0));
		tf.setTransform(t3);
		tf.addChild(branchGroup);
		
		collect.addChild(tf);
		univ.addBranchGraph(collect);
		
	}
	
	public ArmoioreCanvasReporting(Solide3D solidparent) {
		// TODO Auto-generated constructor stub
		this(solidparent,true);
	}

	private BranchGroup createSceneGraph() {
		branchGroupRoot = new BranchGroup();

		branchGroupRoot.setCapability(Group.ALLOW_CHILDREN_EXTEND);
		branchGroupRoot.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		branchGroupRoot.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		branchGroupRoot.addChild(getWhiteBackGround());
		transformGroupRotation = new TransformGroup();
		transformGroupRotation.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		transformGroupRotation.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		transformGroupRotation.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		createDesign();
		transformGroupRotation.addChild(dressingtransformgroup);
		transformGroupRotation.addChild(planstransformgroup);
		
		branchGroupinterim   = new BranchGroup();
		branchGroupinterim.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
		branchGroupinterim.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		branchGroupinterim.setCapability(BranchGroup.ALLOW_DETACH);
		branchGroupinterim.addChild(transformGroupRotation);
		
		branchGroupRoot.addChild(branchGroupinterim);
		branchGroupRoot.compile();
		return branchGroupRoot;
	}
	private Background getBackGround() {

		Texture texture;
		try {
			
			Bundle bundle = Platform.getBundle("Dressing");
			Path path = new Path("pictures/background2.png");
			URL url = FileLocator.find(bundle, path, null);
			texture = new TextureLoader(ImageIO.read(url)).getTexture();

			ImageComponent2D imageComponent2D = (ImageComponent2D) texture.getImage(0);
			Background background = new Background(imageComponent2D);

			background.setImageScaleMode(Background.SCALE_FIT_ALL);
			background.setApplicationBounds(new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));

			return background;
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(0);
			return null;
		} 
	}
	private Background getWhiteBackGround() {
		Background background = new Background(new Color3f(1,1,1));
		BoundingSphere sphere = new BoundingSphere(new Point3d(0,0,0), 100000);
		background.setApplicationBounds(sphere);
		return background;
}
	private TransformGroup createDesign() {

		Appearance appearance = new Appearance();
		appearance.setCapability(Appearance.ALLOW_COLORING_ATTRIBUTES_WRITE|Appearance.ALLOW_TEXTURE_WRITE);
		TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.NICEST, 0.3F);
		
	    LineAttributes la = new LineAttributes( 0.2f,LineAttributes.PATTERN_SOLID, true);
	    la.setCapability(LineAttributes.ALLOW_ANTIALIASING_WRITE);
	    la.setLineAntialiasingEnable(true);
	    
	    PointAttributes pt = new PointAttributes();
	    pt.setCapability(PointAttributes.ALLOW_ANTIALIASING_WRITE);
	    pt.setPointAntialiasingEnable(true);
	    
	    appearance.setLineAttributes(la);
	    appearance.setPointAttributes(pt);
	    
		appearance.setTransparencyAttributes(ta);		
		refSize = Math.max(Math.max(solide3d.getXSize(), solide3d.getYSize()), solide3d.getZSize());
		refSize = refSize * 2;
		dressingtransformgroup = new TransformGroup();
		dressingtransformgroup.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		dressingtransformgroup.setCapability(TransformGroup.ALLOW_PICKABLE_WRITE);
		dressingtransformgroup.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);

		planstransformgroup = new TransformGroup();
		planstransformgroup.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
				
		Transform3D transform = new Transform3D();
		Vector3f vector = new Vector3f(0f, (float) (solide3d.getYSize() / (refSize)),  (float) (solide3d.getZSize() / (refSize)));
		transform.setTranslation(vector);
		dressingtransformgroup.setTransform(transform);
		//tracer le solid parent si il est un espace 3d
		if(solide3d instanceof Space3D)
		{
			BoxDraw boxgroup = new BoxDraw(solide3d, this.refSize);
			DimDraw dimgroup = new ExternalDimDraw(solide3d, this.refSize,1.5f);
			dressingtransformgroup.addChild(boxgroup);
			dressingtransformgroup.addChild(dimgroup);
		}

		
		drawChilds(solide3d);
		return dressingtransformgroup;

	}



	private void drawChilds(Solide3D solideParent) {
		List<Solide3D> comps = solideParent.getChildren();
		for (Iterator<Solide3D> iterator = comps.iterator(); iterator.hasNext();) {
			Solide3D solid = iterator.next();
			BoxDraw boxgroup = new BoxDraw(solid, this.refSize);
			DimDraw dimgroup ;
			if(solid instanceof Space3DFree)
			{
				dimgroup = new ExternalDimDraw(solid, refSize, true, false, 1.3f);
			}
			else
			{
				dimgroup= new InternalDimDraw(solid, this.refSize);
			}
			
			BranchGroup bg = new BranchGroup();
			bg.addChild(boxgroup);
			bg.addChild(dimgroup);
			bg.setCapability(BranchGroup.ALLOW_DETACH);
			bg.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
			bg.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
			bg.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
			bg.setCapability(BranchGroup.ALLOW_PARENT_READ);			
			dressingtransformgroup.addChild(bg);
			drawChilds(solid);
			
		}
		
	}
	
	public Canvas3D getCanvas() {
		return canvas;
	}
	public SimpleUniverse getUniv() {
		return univ;
	}
	
	public double getRefSize() {
		return refSize;
	}
}
