package supercad.persistence.databinding;

import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import dressing.model.persistence.mappers.MapperProvider;
import supercad.xml.XmlNode;
import supercad.xml.XmlParser;

public class XmlMapper implements Mapper {
	
	XMLStreamWriter writer;
	XmlParser parser;

	private void writeElement(ElementNode root, OutputStream stream) {
		try {
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            writer = factory.createXMLStreamWriter(stream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writeNode(root);
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }		
	}
	
	private void writeValue(Object value) throws XMLStreamException {
		CustomValueMapper mapper = MapperProvider.getInstance().getValueTypeMapper(value.getClass());
		writer.writeCharacters(mapper.write(value));
	}
	
	private void writeNode(ElementNode node) throws XMLStreamException {
		writer.writeStartElement(NameGenerator.generateName(node));
		if(node.getType() != null)
			writer.writeAttribute("type", node.getType().getName());
		if(node.getValue() != null && node.getChildren().isEmpty()) {
			writeValue(node.getValue());
		}else {
			for (ElementNode child : node.getChildren()) {
				writeNode(child);
	        }
		}
		writer.writeEndElement();
	}
	
	//parsing and mapping to java object
	public XmlNode parse(InputStream stream) {
		parser = new XmlParser();
		XmlNode doc = null;
		try {
			byte[] data = stream.readAllBytes();
			String str = new String(data);
			doc = parser.parseDoc(str);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return doc;
	}
	
	
	
	
	@Override
	public void write(Object value, OutputStream stream) {
		ElementNode node = ElementMapper.createNodeForValue(value);
		writeElement(node, stream);
	}

	@Override
	public <T> T fromXml(InputStream stream, Class<? extends T> clazz) {
		XmlNode doc = parse(stream);
		T javaObject = null;
		if(doc != null) {
			javaObject =  (T) ElementMapper.bindObject(doc.getFirstChild(), clazz);
			if(javaObject == null) {
				try {
					javaObject = clazz.getConstructor().newInstance();
				}catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return javaObject;
	}
}
