package supercad.persistence.databinding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.UUID;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import com.badlogic.gdx.math.Vector3;
import com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;

import dressing.model.persistence.dpos.PbrMaterialDPO;
import dressing.model.persistence.mappers.MapperProvider;
import gdxapp.scenes.Scene;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;
import supercad.runtime.ReflectionUtils;

public class TestLaucnher {

	public static void write() {
		String path = "C:\\Users\\nadhe\\OneDrive\\Bureau\\persistence";
		try {
			PbrMaterialDPO mtlDPO = new PbrMaterialDPO();
			mtlDPO.setAlbedo(new Vector3(1,1,0));
			mtlDPO.setAlbedoMapPath("albedo.jpg");
			mtlDPO.setNormalMapPath("nomal.jpg");
			mtlDPO.setRoughnessMapPath("roughness.jpg");
			mtlDPO.setMetalness(0.2f);
			mtlDPO.setMetalnessMapPath("metalness.jpg");
			mtlDPO.setOpacity(0.4f);
			XmlMapper mapper = new XmlMapper();
			File file = new File(path + File.separator + "material.xml");
			FileOutputStream fos = new FileOutputStream(file);
			mapper.write(mtlDPO, fos);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public static void read() {
		String path = "C:\\Users\\nadhe\\OneDrive\\Bureau\\persistence";
		try {
			XmlMapper mapper = new XmlMapper();
			File file = new File(path + File.separator + "scene-preferences.xml");
			FileInputStream fis = new FileInputStream(file);
			Object object = mapper.fromXml(fis, ScenePreferences.class);
			System.out.println(object);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	
	public static void main(String...args) throws NoSuchFieldException, SecurityException {
//		ScenePreferences preferences = new ScenePreferences();
//		PbrMaterial wallMtl = new PbrMaterial("wall material");
//		PbrMaterial boxMtl = new PbrMaterial("box material");
//		PbrMaterial	facadeMtl = new PbrMaterial("facade material");
//		PbrMaterial floorMtl = new PbrMaterial("floor material");
//		preferences.setWallMtl(wallMtl);
//		preferences.setBoxMtl(boxMtl);
//		preferences.setFacadeMtl(facadeMtl);
//		preferences.setFloorMtl(floorMtl);
//		preferences.setWallHeight(4);
//		XmlMapper xmlMapper = new XmlMapper();
//		xmlMapper.write(wallMtl, System.out);
		Vector3[] axis = new Vector3[] {Vector3.X, Vector3.Y, Vector3.Z};
	}
	
}


