package supercad.persistence.databinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import supercad.runtime.ReflectionUtils;
import supercad.xml.XmlNode;

public class MapUnmarshaller {

	public static Map unmarshallMapAsEntrySet(XmlNode node,XmlUnmarshaller unmarshaller, Class hint) {
		Class<? extends Map> clazz = hint;
		Map map = null;
		try {
			if(clazz == null)
				clazz = ReflectionUtils.getClass(node.getAttr("type"));
			map = clazz.getConstructor().newInstance();
			ArrayList<XmlNode> children = node.getChildren();
			children.toString();
			for (XmlNode entryNode : node.getChildren()) {
				XmlNode keyNode = entryNode.getFirstChild();
				XmlNode valueNode = entryNode.getChildren().get(1);
				String keyType = keyNode.getAttr("type");
				String valueType = valueNode.getAttr("type");
				Class keyHint = null;
				Class valueHint = null;
				if(keyType != null)
					keyHint = Class.forName(keyType);
				if(valueType != null)
					valueHint = Class.forName(valueType);
				Object key = unmarshaller.unmarshall(keyNode, keyHint);
				Object value = unmarshaller.unmarshall(valueNode, valueHint);
				if(key != null && value!= null)
					map.put(key, value);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return map;
	}
	
	//when the key and value re serialized as attributes
	public static Map unmarshallMapBaseonAttribute(XmlNode node,XmlUnmarshaller unmarshaller, Class hint) {
		Class<? extends Map> clazz = hint;
		Map map = null;
		try {
			if(clazz == null)
				clazz = ReflectionUtils.getClass(node.getAttr("type"));
			map = clazz.getConstructor().newInstance();
			for (XmlNode entryNode : node.getChildren()) {
				HashMap<String, String> attrs = entryNode.getAttributes();
				String key = attrs.get("name");
				String value = attrs.get("value");
				map.put(key, value);
			}
		} catch (Exception e) {
			e.printStackTrace();
			map = null;
		}
		return map;
	}
	
	
	
	
}
