package supercad.persistence.databinding;

public class EnumMapper<E extends Enum> implements CustomValueMapper<E>{

	private boolean useNumber = false;
	
	@Override
	public String write(Enum value) {
		if(useNumber)
			return value.ordinal() + "";
		return value.name();
		
	}

	@Override
	public E read(String text, Class<? extends E> clazz) {
		try {
			E value = (E) Enum.valueOf(clazz, text);
			return value;
			
		}catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	
}
