package supercad.persistence.databinding;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

import com.badlogic.gdx.utils.XmlReader.Element;

import dressing.model.persistence.dpos.DPO;
import dressing.model.persistence.mappers.MapperProvider;
import supercad.runtime.ReflectionUtils;
import supercad.xml.XmlNode;

public class ElementMapper {

	public static ElementNode createNodeForValue(Object obj) {
		if (obj == null)
			return null;
		Class<? extends DPO> clazz = MapperProvider.getInstance().getPersistableType(obj.getClass());
		if (clazz != null) {
			try {
				DPO dpo = clazz.getConstructor().newInstance().from(obj);
				return createNodeForValue(dpo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		ElementNode node = new ElementNode();
		node.setValue(obj);

		if (ReflectionUtils.isCollection(obj)) {
			if (obj instanceof Map) {
				Map<?, ?> map = (Map<?, ?>) obj;
				for (Map.Entry<?, ?> entry : map.entrySet()) {
					ElementNode keyNode = createNodeForValue(entry.getKey());
					ElementNode valueNode = createNodeForValue(entry.getValue());
					ElementNode entryNode = new ElementNode("entry");
					entryNode.addChild(keyNode, true);
					entryNode.addChild(valueNode, true);
					node.addChild(entryNode, true);
				}
			} else {
				List list = null;
				if (obj instanceof List) {
					list = (List) obj;
				} else {
					list = ReflectionUtils.getList(obj, Object.class);
				}
				for (Object item : list) {
					ElementNode itemNode = createNodeForValue(item);
					node.addChild(itemNode, true);
				}
			}
		} else

		{
			if (ReflectionUtils.isPrimitive(obj.getClass())) {
				return node;
			} else if (obj instanceof String) {
				node.setValue(obj);
			} else {
				ArrayList<Field> fields = ReflectionUtils.getNonTransientField(obj);
				for (Field field : fields) {
					Object value = null;
					try {
						field.setAccessible(true);
						value = field.get(obj);
						if (!ReflectionUtils.isNullOrEmptyCollection(value)) {
							ElementNode childNode = createNodeForValue(value);
							if (childNode != null) {
								childNode.setName(NameGenerator.generateName(field));
								node.addChild(childNode, true);
							}
						}

					} catch (Exception e) {
						e.printStackTrace();
						System.err.println("error mapping " + value);
						continue;
					}
				}
			}
		}
		return node;
	}

	public static Object bindObject(XmlNode node, Class clazz) {
		Object value = null;
		try {
			XmlUnmarshaller unmarshaller = new XmlUnmarshaller();
			value = unmarshaller.unmarshall(node, clazz);
			if (value instanceof DPO) {
				value = ((DPO) value).get();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return value;
	}
	// handlePrimitive simple node
}