package supercad.graphics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import java.util.ArrayList;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.io.IOUtilities;
import gdxapp.shaders.PbrMaterial;

public class WaveFrontParser {
	
	private  ArrayList<Vector3> positions = new ArrayList<Vector3>();
	private  ArrayList<Vector3> normals = new ArrayList<Vector3>();
	private  ArrayList<Vector2> texCoords = new ArrayList<Vector2>();
	private  TNode rootNode =  new TNode();
	//private  ArrayList<Simplex3D> tmpNodeContent =  new ArrayList<Simplex3D>();
	//private String currentNodeName;
	public static WaveFrontParser waveFrontParserinstance = new WaveFrontParser();
	private ArrayList<PbrMaterial> materials;
	
	
       
	
	public Vector3 parsePositionLine(String line) {
		String[] components = line.split("[ \t]+");
		float x = Float.parseFloat(components[1]);
		float y = Float.parseFloat(components[2]);
		float z = Float.parseFloat(components[3]);

		return new Vector3(x, y ,z);
	}
	
	private Vector2 parseTexCoordsLine(String line) {
		String[] components = line.split("[ \t]+");
		float x = Float.parseFloat(components[1]);
		float y = Float.parseFloat(components[2]);
		return new Vector2(x, y);
	}
	


	private Vector3 parseNormalLine(String line) {
		String[] components = line.split("[ \t]+");
		float x = Float.parseFloat(components[1]);
		float y = Float.parseFloat(components[2]);
		float z = Float.parseFloat(components[3]);
		return new Vector3(x, y, z);
	}
	
	private Simplex3D parseFaceLine(String line) {
		String[] components = line.split("[ \t]+");
		if(components.length == 4) {
			Vertex v0 = parseVertex(components[1]);
			Vertex v1 = parseVertex(components[2]);
			Vertex v2 = parseVertex(components[3]);
			return new Simplex3D(v0, v1, v2);
		}
		return null;
		
	}
	
	private Vertex parseVertex(String str) {
		String[] indices = str.replaceAll("\\p{C}", "").split("/");
		int posIndex = Integer.parseInt(indices[0]);
		int normalIndex = Integer.parseInt(indices[1]);
		int texCoordsIndex = Integer.parseInt(indices[2]);
		Vertex vertex = new Vertex();
		vertex.setPosition(positions.get(posIndex - 1).cpy());
		vertex.setNormal(normals.get(normalIndex - 1).cpy());
		vertex.setTextureCoords(texCoords.get(texCoordsIndex - 1).cpy());
		return vertex;
	}
	

	public void parse(String content, ArrayList<PbrMaterial> arrayListmateriel) {
		String[] lines = content.split("\\n");
		String contentpiece = "" ;
		for(String line: lines) {
			if(line.startsWith("vn")) {
				normals.add(parseNormalLine(line));
			}else if(line.startsWith("vt")) {
				texCoords.add(parseTexCoordsLine(line));
			}else if(line.startsWith("v")) {
				positions.add(parsePositionLine(line));}
			else {
				
				
				contentpiece=contentpiece+line +"";
				
			}
				
			}
		String seperator ="usemtl";
		String[]blocs = contentpiece.split(seperator);
		String[] modifiedbloc = Arrays.copyOfRange(blocs, 1, blocs.length);
		
		for (String bloc :modifiedbloc) {
			ArrayList<Simplex3D> NodeSimplices =  new ArrayList<Simplex3D>();
			TNode node = new TNode();
			String[] lignes = bloc.split("\\r");
			for(String ligne: lignes) {
				if(ligne.startsWith("f ")) {
					Simplex3D face = parseFaceLine(ligne);
					if(face != null) {
						NodeSimplices.add(face);
						int debug=0;
					}
			}
				else {
					String matlRef = ligne.replaceAll("usemtl", "").replaceAll(" ","_");
			//		System.out.println(matlRef);
					//currentNodeName= matlRef;
				//	TNode node = new TNode();
					//node.setSimplices(NodeSimplices.toArray(new Simplex3D[0]));
					node.setNameNode(matlRef);

					PbrMaterial materiel = null;
					for(PbrMaterial pbrMaterial :arrayListmateriel ) {
						String nameNode =node.getNameNode();
						String matPBName =pbrMaterial.getName();

							if(matPBName.contains(nameNode)) {
								
								materiel =pbrMaterial;

								break;
								}
					}
					if(materiel != null) {
						materiel.setName(matlRef);
						node.setMaterial(materiel);

					}
					else {
						System.out.println("errer");
					}
					//assignementMateriel(node,arrayListmateriel, matlRef);
					
					//parserMtl.parse(path)
					//get material from material list and assign it to the node
					//rootNode.addChild(node);
					//tmpNodeContent.clear();
					
				}
		
		
		
				
				
			}
			node.setSimplices(NodeSimplices.toArray(new Simplex3D[0]));
			rootNode.addChild(node);
			}	
		//TNode lastNode = new TNode();
		//lastNode.setSimplices(tmpNodeContent.toArray(new Simplex3D[0]));
		//rootNode.addChild(lastNode);
		//tmpNodeContent.clear();
		}	
				
				
				
				
				
				
			
						
						
		
		
	
	private void assignementMateriel(TNode node, ArrayList<PbrMaterial> arrayListmateriel, String mtlReference) {
		boolean mtlFound = false;
		for(PbrMaterial mtl: arrayListmateriel) {
			if(mtl.getName().equals(mtlReference)) {
				node.setMaterial(mtl);
				mtlFound = true;
				break;
			}
		}
		if(!mtlFound)
			System.err.println("material not found");
	}

	private TNode getNodeName(String currentNodeName) {
		TNode parsenoued = new TNode();
		// TODO Auto-generated method stub
		return parsenoued;
	}

	public TNode parseFile(String pathObj,String pathmtl) {
		MtlParser parserMtl = new MtlParser ();
		String contentObj = IOUtilities.readTextFile(pathObj);
		String contentMtl = IOUtilities.readTextFile(pathmtl);
		ArrayList<PbrMaterial> materials = parserMtl.parse(contentMtl);
		parse(contentObj,materials);
		return rootNode;
		
	}
	
	public static WaveFrontParser getInstance () {
		return waveFrontParserinstance;
	}

	public ArrayList<Vector3> getPositions() {
		return positions;
	}

	public void setPositions(ArrayList<Vector3> positions) {
		this.positions = positions;
	}

	public ArrayList<Vector3> getNormals() {
		return normals;
	}

	public void setNormals(ArrayList<Vector3> normals) {
		this.normals = normals;
	}

	public ArrayList<Vector2> getTexCoords() {
		return texCoords;
	}

	public void setTexCoords(ArrayList<Vector2> texCoords) {
		this.texCoords = texCoords;
	}

	
	
	public TNode getRootNode() {
		return rootNode;
	}

	public void setRootNode(TNode rootNode) {
		this.rootNode = rootNode;
	}
	public ArrayList<PbrMaterial> listPbrMaterial(String pathmt){
		
		return materials;
		
	}
	public static Matrix4 readTransformFile(String path) {
		String text = IOUtilities.readTextFile(path);
		float[] values = new float[16];
		if(text.length() > 0) {
			int i = 0;
			for(String line: text.split("\\n")) {
				values[i++] = Float.parseFloat(line);
			}
		}
		return new Matrix4(values);
	}

	
	public static void main(String[] args) {
		
	
		String pathob = "C:\\Users\\ghassen BA\\Desktop\\testfileobjopt\\object1.obj";
		String pathmt = "C:\\Users\\ghassen BA\\Desktop\\testfileobjopt\\object1.mtl";
		WaveFrontParser parser = new WaveFrontParser();
		TNode node = parser.parseFile(pathob,pathmt);
		System.err.println(node);
		}

	
	
}
