package supercad.graphics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import com.badlogic.gdx.math.Matrix4;

import gdxapp.shaders.PbrMaterial;

public class TNode implements Iterable<TNode>{
	
	private Matrix4 transform = new Matrix4();
	private ArrayList<TNode> children = new ArrayList<TNode>();
	private PbrMaterial material;	
	private Simplex3D[] simplices;
	private String nameNode = "";
	
	public TNode() {}
	
	public TNode(String id) {
		this.nameNode = id;
	}

	
	public void addChild(TNode node) {
		if (children==null) {
			children = new ArrayList<TNode>();
		}
		this.children.add(node);
	}
	
	
	@Override
	public String toString() {
		int simpliceCount = (simplices != null)? simplices.length:0;
		return "TNode [simplices=" + simpliceCount + ", nameNode=" + nameNode + "]";
	}

	public String getNameNode() {
		return nameNode;
	}

	public void setNameNode(String nameNode) {
		this.nameNode = nameNode;
	}

	public ArrayList<TNode> getChildren() {
		return children;
	}

	public void setChildren(ArrayList<TNode> children) {
		this.children = children;
	}


	public Matrix4 getTransform() {
		return transform;
	}

	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}

	public PbrMaterial getMaterial() {
		return material;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}

	public Simplex3D[] getSimplices() {
		return simplices;
	}

	public void setSimplices(Simplex3D[] simplices) {
		this.simplices = simplices;
	}


	@Override
	public Iterator<TNode> iterator() {
		return new TNodeIterator(this);
	}

}
