package supercad.graphics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.ui.ide.undo.CreateFileOperation;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import gdxapp.shaders.PbrMaterial;

public class MeshIndexer {
	
	
	private ArrayList<Vector3> positions = new ArrayList<Vector3>();
	private ArrayList<Vector3> normals = new ArrayList<Vector3>();
	private ArrayList<Vector2> texCoords = new ArrayList<Vector2>();
	private ArrayList<PbrMaterial> materials;
	StringBuilder facesWriter = new StringBuilder();

	public StringBuilder blockpostext() {
		StringBuilder postextblock = new StringBuilder();
		for (Vector3 pos : positions) {
			float positionX = pos.x;
			String posx = Float.toString(positionX);
			float positionY = pos.y;
			String posy = Float.toString(positionY);
			float positionZ = pos.z;
			String posz = Float.toString(positionZ);
			String Vpos = "v  " + posx + "  " + posy + "  " + posz + '\n';
			postextblock.append(Vpos);

		}
		return postextblock;
	}

	public StringBuilder blockNormal() {
		StringBuilder blocknormale = new StringBuilder();
		for (Vector3 normal : normals) {
			float positionX = normal.x;
			String posx = Float.toString(positionX);
			float positionY = normal.y;
			String posy = Float.toString(positionY);
			float positionZ = normal.z;
			String posz = Float.toString(positionZ);
			String Vpos = "vn  " + posx + "  " + posy + "  " + posz + '\n';
			blocknormale.append(Vpos);

		}
		return blocknormale;
	}

	public void texcoorListOpt(ArrayList<Vector2> texCoordsInput) {
		
		for (Vector2 texCoord : texCoordsInput) {
			boolean exist = false;
			for (Vector2 coor : texCoords) {
				if (coor.epsilonEquals(texCoord, (float) 0.00001))
					 {
						exist = true;
						break;
					}	
					
				    }
		
		if(!exist)
			texCoords.add(texCoord);

			}

		}

	

	public StringBuilder blocktexture() {
		StringBuilder blocktexturetextblock = new StringBuilder();
		for (Vector2 texCoord : texCoords) {
			float textureX = texCoord.x;
			String textx = Float.toString(textureX);
			float textureY = texCoord.y;
			String texty = Float.toString(textureY);
			String texturecoord = "vt  " + textx + "  " + texty + '\n';
			blocktexturetextblock.append(texturecoord);
		}
		return blocktexturetextblock;

	}

	
	


	public String holeOpt() {
		StringBuilder fileOptimizing = new StringBuilder();
		String mtlFileRef="model.mtl";
		fileOptimizing.append(String.format("mtllib %s \n",mtlFileRef));

		fileOptimizing.append(blockpostext());
		fileOptimizing.append(blockNormal());
		fileOptimizing.append(blocktexture());
		fileOptimizing.append(facesWriter);
		return fileOptimizing.toString();
	}
	
	

	//materials is the list of distincts materials
	public String index(TNode rootnode, ArrayList<PbrMaterial> materials) {
		
		facesWriter.setLength(0);
		this.materials = materials;
		
		for(TNode child: rootnode) {
			if (child.getSimplices() == null) {
				facesWriter.append(String.format("o  %s \n",child.getNameNode().trim()));	
			}
		
			
			if((child.getSimplices() != null)) {
				facesWriter.append(String.format("g piece%s\n",child.getNameNode()));
				if(child.getMaterial() != null) {
					PbrMaterial material = findMaterial(child.getMaterial());
					facesWriter.append(String.format("usemtl %s \n",material.getName().trim()));
				}
				

				for(Simplex3D simplex: child.getSimplices()) {
					int[] indices = new int[9];
					int c = 0;
					for(Vertex vertex: simplex.getVertices()) {
						Vector3 pos = vertex.getPosition();
						Vector3 norm = vertex.getNormal();
						Vector2 textC = vertex.getTextureCoords();
						
						int posIndex = findOrAddVector3Index(pos, positions);
						int normalIndex = findOrAddVector3Index(norm, normals);
						int texcCoordsIndex =  findOrAddVector2Index(textC, texCoords); 
						indices[c++] = posIndex +1;
						indices[c++] = texcCoordsIndex +1;
						indices[c++] = normalIndex +1;
						
					}
					
					facesWriter.append(String.format("f  %d/%d/%d  %d/%d/%d  %d/%d/%d \n",indices[0], indices[1], indices[2],
							indices[3], indices[4], indices[5], indices[6], indices[7], indices[8]));
				}
				
			}
		}
		
		return holeOpt();
	}
	
	private PbrMaterial findMaterial(PbrMaterial material) {
		for(PbrMaterial mtl: materials) {
			if(mtl.equals(material))
				return mtl;
		}
		return null;
	}

	public static int findOrAddVector3Index(Vector3 target, List<Vector3> list) {
		int index = -1;
		for(int i = 0; i < list.size(); i++) {
			if(list.get(i).epsilonEquals(target, 0.0001f)) {
				index = i;
				break;
			}
		}
		if(index < 0) {
			list.add(target);
			index = list.size() -1;
		}
		return index;
	}
	
	public static int findOrAddVector2Index(Vector2 target, List<Vector2> list) {
		int index = -1;
		for(int i = 0; i < list.size(); i++) {
			if(list.get(i).epsilonEquals(target, 0.0001f)) {
				index = i;
				break;
			}
		}
		if(index < 0) {
			list.add(target);
			index = list.size() -1;
		}
		return index;
	}
	}

	

	
	

