package supercad.graphics;

import com.badlogic.gdx.math.Vector3;

public class GraphicsUtils {
	
	public final static byte POINTS = 1;
	public final static byte LINES = 2;
	public final static byte TRIANGLES = 4;
	public final static byte QUADS = 8;


	
	
	
	public static int[][] extractPrimitives(int[] indices, int type) {
		switch(type) {
		case GraphicsUtils.POINTS:
			return splitIndices(indices, 1);
		case GraphicsUtils.LINES:
			return splitIndices(indices, 2);
		case GraphicsUtils.TRIANGLES:
			return splitIndices(indices, 3);
		default:
			return splitIndices(indices, 4); 
		}
	}
		
	private static int[][] splitIndices(int[] indices, int primitiveSize) {
		int primitiveCount = Math.floorDiv(indices.length, primitiveSize);
		int[][] prims = new int[primitiveCount][primitiveSize];
		for(int i = 0; i < indices.length; i++) {
			prims[Math.floorDiv(i, primitiveSize)][i%primitiveSize] = indices[i];
		}
		return prims;
	}
	
	public static Simplex3D[] createTriangleMesh(Vector3[] vertices, int[][] indices) {
		Simplex3D[] triangles = new Simplex3D[indices.length];
		for(int i = 0; i < indices.length; i++) {
			int[] current = indices[i];
			triangles[i] = new Simplex3D(vertices[current[0]], vertices[current[1]], vertices[current[2]]) ;
		}
		return triangles;
	}
	
	public static Quad[] createQuadMesh(Vector3[] vertices, int[][] indices) {
		Quad[] quads = new Quad[indices.length];
		for(int i = 0; i < indices.length; i++) {
			int[] current = indices[i];
			quads[i] = new Quad(vertices[current[0]], vertices[current[1]], vertices[current[2]], vertices[current[3]]);
		}
		return quads;
	}
	
	
	


}