package supercad.eclipse.service;

import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;



public class EclipseServiceProvider {
	
	private final EModelService modelService;

	private final EPartService partService;
	
	private final MApplication application;
	
	private static EclipseServiceProvider serviceProvider;

		
	public EclipseServiceProvider(EModelService modelService, EPartService partService, MApplication application) {
		this.modelService = modelService;
		this.partService = partService;
		this.application = application;
	}


	public EModelService getModelService() {
		return modelService;
	}
	


	public EPartService getPartService() {
		return partService;
	}

	public MApplication getApplication() {
		return application;
	}


	public static EclipseServiceProvider getServiceProvider() {
		return serviceProvider;
	}


	public static void setServiceProvider(EclipseServiceProvider serviceProvider) {
		EclipseServiceProvider.serviceProvider = serviceProvider;
	}


	
	
	
	
	

}
