package reporting.htmlReporting.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HtmlNodeImpl implements HtmlNode{
	protected String name;
	protected String content;
	protected String text;
	protected int order=0;
	protected HashMap<String, HtmlAttribute> attributes = new HashMap<String, HtmlAttribute>();
	protected List<HtmlNode> childNodes = new ArrayList<HtmlNode>( );
	protected HtmlNodeImpl parent;
	
	public HtmlNodeImpl(String name) {
		super();
		this.name = name;
	}
	
	protected HtmlNodeImpl() {
		super();
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public int getOrder() {
		return order;
	}

	public void setOrder(int order) {
		this.order = order;
	}

	public void appendNode(HtmlNodeImpl node) {
		child(node);
	}
	
	@Override
	public String getContent() {
		generateContent();
		return content;
	}
	protected void generateContent() {
		StringBuilder sb=new StringBuilder();
		sb.append(getSpaceTab(order));
		if(this.name.contentEquals("content")) {
			sb.append("<div ");
		}else {
			sb.append("<"+name);
		}
		
		if(getAttributes()!=null && !getAttributes().isEmpty()) {
			for(String child:getAttributes().keySet()) {
				HtmlAttribute attibute=getAttributes().get(child);
				
				sb.append(attibute.getContent());
			}
		}
		sb.append("> \n ");
		if(getText()!=null && !getText().isEmpty())
		{
			sb.append(getSpaceTab(order+1));
			sb.append(text);
			sb.append("\n");

		}
		if(!getChildNodes().isEmpty()) {
			for(HtmlNode child:getChildNodes()) {
				sb.append(child.getContent());
			}
		}
		sb.append(getSpaceTab(order));
		if(this.name.contentEquals("content")) {
			sb.append("</div>\n");
		}else {
			sb.append("</"+getName()+">\n");
		}
		content=sb.toString();
		content.trim();
	}
	public void appendAttribute(String key,String segment) {
		HtmlAttribute attribute=getAttributes().get(key);
		if(attribute!=null)
		{	if(key.contentEquals("colspan")) {
				attribute.setSegment(segment);
			}else {
				attribute.appendSegment(segment);
			}
		}else {
			attribute =new HtmlAttribute();
			attribute.setName(key);
			attribute.appendSegment(segment);
			getAttributes().put(key, attribute);
		}
	}
	
	public void appendAttribute(String key,String... segments) {
		HtmlAttribute attribute=getAttributes().get(key);
		if(attribute!=null)
		{
			attribute.appendSegments(segments);
		}else {
			attribute =new HtmlAttribute();
			attribute.setName(key);
			attribute.appendSegments(segments);
			getAttributes().put(key, attribute);
		}
	}
	
	public void appendAttribute(String key, HtmlAttribute attribute) {
		getAttributes().put(key, attribute);
	}
	public void setContent(String content) {
		this.content = content;
	}
	public HashMap<String, HtmlAttribute> getAttributes() {
		if(attributes==null) {
			attributes=new HashMap<String, HtmlAttribute>();
		}
		return attributes;
	}
	public void setAttributes(HashMap<String, HtmlAttribute> attributes) {
		this.attributes = attributes;
	}
	public List<HtmlNode> getChildNodes() {
		return childNodes;
	}
	public void setChildNodes(List<HtmlNode> childNodes) {
		this.childNodes = childNodes;
	}
	public HtmlNodeImpl getParent() {
		return parent;
	}
	public void setParent(HtmlNodeImpl parent) {
		this.parent = parent;
	}
	public HtmlNodeImpl parent( HtmlNodeImpl parent )
	{
		parent.child( this );
		return parent;
	}

	public HtmlNodeImpl child( HtmlNodeImpl child )
	{
		child.parent = this;
		this.childNodes.add( child );
		child.order=this.order+1;
		return child;
	}

	public HtmlNodeImpl delete(HtmlNodeImpl child)
	{
		this.childNodes.remove( child );
		return child;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public String getSpaceTab( int i )
	{
		StringBuffer stringbuffer = new StringBuffer( );
		for ( int j = 0; j < i; j++ )
		{
			stringbuffer.append( "\t" );
		}
		return stringbuffer.toString( );
	}
	
}
