package reporting.htmlReporting;

import java.io.File;

import javax.servlet.http.HttpServlet;

import org.frs.webserver.internal.EmbeddedJettyServer;

import dressing.model.ProjectManager;

public class JettyServer {

	private EmbeddedJettyServer server;
	
	private static JettyServer instance;
	
	public void start() {
		server.startServer();
		try {
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void shutdown() {
		server.stopServer();
	}
	
	public void registerServlet(Class<? extends HttpServlet> clazz, String path) {
		try {
			server.registerServlet(clazz, path);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private JettyServer(String rootFolder) {
		server = new EmbeddedJettyServer(rootFolder);
	}
	
	public void restart(String rootFolder) {
		if(server.isRunning())
			shutdown();
		try {
			server.configure(rootFolder);
			start();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static JettyServer getInstance() {
		if(instance == null) {
			String root = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator + "reporting";
			instance = new JettyServer(root);
		}
		return instance;
	}

	
	
	
}
