package reporting.htmlReporting;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.List;

import org.frs.html.CrudeHtmlElement;
import org.frs.html.JavaCodeEvaluator;
import org.frs.svg.DressingDrawingConfig;
import org.frs.svg.SvgDrawer.RENDERING_MODE;
import com.badlogic.gdx.math.Vector2;

import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3DFree;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import dressing.reporting.data.handle.ArticleCoupe;
import dressing.model.ProjectManager;
import gdxapp.object3d.KitchenElement;
import param.Material;
import reporting.SVGGnerator;
import reporting.data.handle.PieceCoupe;

public class ElementReport extends HtmlReport{
	
	private KitchenElement kitchenElement;
	private final String template_path = "src/reporting/htmlReporting/templates/ElementReport.html";
	private String pathToBackImg;
	private String pathToFrontImg;
	ArrayList<ArticleCoupe> accessoires = new ArrayList<ArticleCoupe>();
	ArrayList<ArticleCoupe> quincailleries = new ArrayList<ArticleCoupe>();
	private String reportDir;
	public ElementReport(KitchenElement kitchenElement) {
		this.kitchenElement = kitchenElement;
		compiler = JavaCodeEvaluator.getInstance();
		svgGen = new SVGGnerator();
	}
	
	public void bind() {
//		generateAccessoiresAndQuincailleries();
//		replaceAccessoiresImages();
		binding.put("$path_to_back_img$", pathToBackImg);
		binding.put("$path_to_front_img$", pathToFrontImg);
		ArrayList<Piece2D> pieces = (ArrayList<Piece2D>) this.kitchenElement.getDesignObject().getListPieces();
		List<PieceCoupe> piecesCoupe =new ArrayList<PieceCoupe>();
		for(Piece2D piece: pieces) {
			piecesCoupe.add(new PieceCoupe(piece.getName(), piece));
		}
		binding.put("$element$", kitchenElement);
		binding.put("$pieces$", piecesCoupe);
		HashMap<Piece2D, String> svgs = new HashMap<Piece2D, String>();
		DesignObjectSvgDrawer drawer = new DesignObjectSvgDrawer();
		DressingDrawingConfig config = new DressingDrawingConfig();
		config.setMode(RENDERING_MODE.LINES);
		config.setHeight(300);
		String svg = drawer.draw(kitchenElement.getDesignObject(), config);
		binding.put("$front$", svg);
		int length = (int) Math.round(kitchenElement.getDesignObject().getLongeurext());
		int height = (int) Math.round(kitchenElement.getDesignObject().getHauteurext());
		int depth = (int) Math.round(kitchenElement.getDesignObject().getProfondeurext());
		
		// accessories
		final HashMap<ModelAccessoire, String> previewURLS = new HashMap<ModelAccessoire, String>();
		Space3DFree element = (Space3DFree) this.kitchenElement.getDesignObject();
		
		String folderPath = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator + "reporting" +
		File.separator + "accessories";
		
		
//		final List<ModelAccessoire> accessories = new ArrayList<ModelAccessoire>();
//		element.getAccessoires().stream().forEach(
//				acc -> {
//					String imagePath = "";
//					try {
//						imagePath = acc.getAccessoire().getAccessoire().getImage().getPath();
//						File dest = new File(folderPath + File.separator + acc.getName() + ".jpg");
//						IOUtilities.copyFileUsingChannel(new File(imagePath), dest);
//						String relativePath = "accessories" + File.separator + acc.getName() + ".jpg";
//						previewURLS.put(acc, WorkspaceConfiguration.JETTY_HOST + File.separator +  relativePath);
//					}catch (Exception e) {
//						e.printStackTrace();
//					}
//				});
//		accessories.addAll(element.getAccessoires());
//		binding.put("$accessories$", accessories);
//		binding.put("$accessoryUrl$", previewURLS);
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		boolean isShowCost = ReportingPreferences.getInstance().getProperty("report.showcost", false);
		boolean isShowSVGPiece = ReportingPreferences.getInstance().getProperty("report.showSVGPiece", false);

		if(isShowAccessoire || isShowQuicaillerie) {
			generateAccessoiresAndQuincailleries();
			replaceAccessoiresImages();
		}
		this.binding.put("$isShowAccessoire$", isShowAccessoire);
		this.binding.put("$isShowQuicaillerie$", isShowQuicaillerie);
		this.binding.put("$isShowCost$", isShowCost);
		this.binding.put("$isShowSVGPiece$", isShowSVGPiece);

		
		String dims =  length + "x" + height + "x" + depth;
		binding.put("$dims$", dims);
		Material boxMtl = kitchenElement.getDesignObject().getBasematerial();
		Material backMtl = kitchenElement.getDesignObject().getBackmaterial();
		Material facadeMtl = kitchenElement.getDesignObject().getFacadeMaterial();
		binding.put("$facadeMtl$", facadeMtl.getName());
		binding.put("$backMtl$", backMtl.getName());
		binding.put("$boxMtl$", boxMtl.getName());
		binding.put("$accessories$", accessoires);
		binding.put("$quincailleries$", quincailleries);
		if(isShowSVGPiece) {
			for(Piece2D piece2d: pieces) {
				String face = svgGen.genSingleImageProjections(piece2d, new Vector2(297 * 3,210 * 3), 50, 100, 100);
				svgs.put(piece2d, face);
			}
			binding.put("$svgs$", svgs);
		}
	}

	@Override
	public void loadTemplate( ) {
		loadTemplateFile(this.template_path);
	}
	
	public String getContentAsPlaintext() {
		CrudeHtmlElement body = this.doc.getChildrenByType("body").get(0);
		String plainText = "";
		for(CrudeHtmlElement child: body.getChildren()) {
			plainText += child.toString() + "\n";
		}
		return plainText;
	}

	public KitchenElement getKitchenElement() {
		return kitchenElement;
	}

	public void setKitchenElement(KitchenElement kitchenElement) {
		this.kitchenElement = kitchenElement;
	}

	public String getPathToBackImg() {
		return pathToBackImg;
	}

	public void setPathToBackImg(String pathToBackImg) {
		this.pathToBackImg = pathToBackImg;
	}

	public String getPathToFrontImg() {
		return pathToFrontImg;
	}

	public void setPathToFrontImg(String pathToFrontImg) {
		this.pathToFrontImg = pathToFrontImg;
	}

	public ArrayList<ArticleCoupe> getAccessoires() {
		return accessoires;
	}

	public void setAccessoires(ArrayList<ArticleCoupe> accessoires) {
		this.accessoires = accessoires;
	}

	public ArrayList<ArticleCoupe> getQuincailleries() {
		return quincailleries;
	}

	public void setQuincailleries(ArrayList<ArticleCoupe> quincailleries) {
		this.quincailleries = quincailleries;
	}

	public String getReportDir() {
		return reportDir;
	}

	public void setReportDir(String reportDir) {
		this.reportDir = reportDir;
	}

	private void replaceAccessoiresImages() {
		for (ArticleCoupe acc : accessoires) {
			putAccesoireImgInServer(acc);
		}
		for (ArticleCoupe acc : quincailleries) {
			putAccesoireImgInServer(acc);
		}
	}

	private void putAccesoireImgInServer(ArticleCoupe acc) {
		if (acc.isImageExist()) {
			File origin = new File(acc.getImagePath());
			File imgDestination = new File(reportDir + File.separator + "acc_" + origin.getName());
			try {
				IOUtilities.copyFileUsingChannel(origin, imgDestination);
				acc.setImagePath(WorkspaceConfiguration.JETTY_HOST + "/" + imgDestination.getName());
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	private void generateAccessoiresAndQuincailleries() {

		Map<param.Accessoire, ArticleCoupe> articlesAccessoiresCoupe = new HashMap<param.Accessoire, ArticleCoupe>();
		Map<param.Quincaillerie, ArticleCoupe> articlesQuincailleriesCoupe = new HashMap<param.Quincaillerie, ArticleCoupe>();

		generateElementAccessoires(accessoires, quincailleries, articlesAccessoiresCoupe, articlesQuincailleriesCoupe,
				kitchenElement.getDesignObject());

	}

	/**
	 * @param accessoires
	 * @param quincailleries
	 * @param articlesAccessoiresCoupe
	 * @param articlesQuincailleriesCoupe
	 * @param dress
	 */
	public void generateElementAccessoires(ArrayList<ArticleCoupe> accessoires, ArrayList<ArticleCoupe> quincailleries,
			Map<param.Accessoire, ArticleCoupe> articlesAccessoiresCoupe,
			Map<param.Quincaillerie, ArticleCoupe> articlesQuincailleriesCoupe, DesignObject3D dress) {
		ArrayList<ModelAccessoire> dressAccessoires = ((Space3DFree) dress).getAccessoires();
		ArrayList<ModelQuincaillerie> dressQuincailleries = ((Space3DFree) dress).getQuincailleries();

		// grouper accessoires
		for (ModelAccessoire accessoire : dressAccessoires) {
			if (accessoire.getAccessoire().getAccessoire() == null
					|| accessoire.getAccessoire().getAccessoire().eIsProxy()) {
				continue;
			}
			if (!articlesAccessoiresCoupe.containsKey(accessoire.getAccessoire().getAccessoire())) {
				ArticleCoupe artcoupe = new ArticleCoupe(accessoire, 1);
				articlesAccessoiresCoupe.put(accessoire.getAccessoire().getAccessoire(), artcoupe);
				accessoires.add(artcoupe);
			} else {
				ArticleCoupe artCoupe = articlesAccessoiresCoupe.get(accessoire.getAccessoire().getAccessoire());
				artCoupe.setNumber(artCoupe.getNumber() + accessoire.getNumber());
			}
		}

		// grouper quincailleries
		for (ModelQuincaillerie quicaillerie : dressQuincailleries) {
			if (quicaillerie.getQuincaillerie().getQuincaillerie() == null
					|| quicaillerie.getQuincaillerie().getQuincaillerie().eIsProxy()) {
				continue;
			}
			if (!articlesQuincailleriesCoupe.containsKey(quicaillerie.getQuincaillerie().getQuincaillerie())) {
				ArticleCoupe artcoupe = new ArticleCoupe(quicaillerie, 1);
				articlesQuincailleriesCoupe.put(quicaillerie.getQuincaillerie().getQuincaillerie(), artcoupe);
				quincailleries.add(artcoupe);
			} else {
				ArticleCoupe artCoupe = articlesQuincailleriesCoupe
						.get(quicaillerie.getQuincaillerie().getQuincaillerie());
				artCoupe.setNumber(artCoupe.getNumber() + quicaillerie.getNumber());
			}
		}
	}

}
