package reporting.htmlReporting;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;

import org.frs.html.JavaCodeEvaluator;
import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import dressing.reporting.data.handle.ProjectCoupe;
import dressing.reporting.data.handle.ReportConfigDialog;

public class DressingProjectAssemblyReport extends HtmlReport {
	private final String template_path = "src/dressing/reporting/htmlReporting/templates/dressingProjectAssembled_report.html";
	private SuperCadProject project;
	private ProjectCoupe projectcoupe;
	
	public DressingProjectAssemblyReport(SuperCadProject project) {
		super();
		this.setProject(project);
		this.compiler = JavaCodeEvaluator.getInstance();
		projectcoupe=new ProjectCoupe(true,project);
		bind();
	}

	@Override
	public void bind() {
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		boolean isShowCost = ReportingPreferences.getInstance().getProperty("report.showcost", false);
		this.binding.put("$project$", projectcoupe);
		this.binding.put("$logoPath$", WorkspaceConfiguration.JETTY_HOST + "/" + "logo.png");
		this.binding.put("$isShowAccessoire$", isShowAccessoire);
		this.binding.put("$isShowQuicaillerie$", isShowQuicaillerie);
		this.binding.put("$isShowCost$", isShowCost);

	}

	public ProjectCoupe getProjectcoupe() {
		return projectcoupe;
	}

	public void setProjectcoupe(ProjectCoupe projectcoupe) {
		this.projectcoupe = projectcoupe;
	}

	@Override
	public void loadTemplate() {
		loadTemplateFile(template_path);
	}

	public SuperCadProject getProject() {
		return project;
	}

	public void setProject(SuperCadProject project) {
		this.project = project;
	}
	@Override
	public void writeAndDisplay() {
		
		try {
			String tempFolder=System.getenv("temp");
			File parentFile=new File(tempFolder,"Supercad");
			parentFile.mkdir();
			File file =File.createTempFile("devis", " "+ProjectManager.getManager().getCurrentProject().getName()+".html",parentFile );
			file.createNewFile();
			FileOutputStream fos = new FileOutputStream(file);
			fos.write(doc.toString().getBytes());
			fos.close();
			
			String fileURI = file.toURI().toString();
			System.out.println(fileURI);
			//save the new path to preferences to use directly in the next save file action
			
			Desktop.getDesktop().browse(URI.create(file.toURI().toString().replace(" ", "%20")));
			file.deleteOnExit();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
}
