package reporting.htmlReporting;

import java.util.HashMap;
import java.util.Vector;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;
import dressing.cam.model.PlanUsinage;

public class CubeGrid {
	
	private final HashMap<PlanUsinage, Rectangle> grid = new HashMap<PlanUsinage, Rectangle>();
	private Vector2[][] offsets;
	private Vector2[][] dimensions;
	private float width;
	private float height;
	
	private void calculateOffsetsAndDimensions(Piece2D piece, int h_spacing, int v_spacing){
		float length = (float)piece.getLongeurext();
		float height = (float)piece.getHauteurext();
		float depth = (float)piece.getProfondeurext();
		
		float[] columnsWidth = new float[] {depth + h_spacing, length + h_spacing, depth + h_spacing, length + h_spacing};
		float[] rowsHeight = new float[] {depth + v_spacing, height + v_spacing, depth + v_spacing};
		
		this.height = this.width = 0;
		
		for(int i = 0; i < columnsWidth.length; i++)
			width += columnsWidth[i];
		for(int i = 0; i < rowsHeight.length; i++)
			this.height += rowsHeight[i];
		
		offsets = new Vector2[3][4];
		dimensions = new Vector2[3][4];
		
		for(int i = 0; i < offsets.length; i++) {
			for(int j = 0; j < offsets[0].length;j++) {
				float x = 0;
				float y = 0;
				for(int xc = 0; xc < j; xc++)
					x+= columnsWidth[xc];
				for(int yc = 0; yc < i; yc++)
					y+= rowsHeight[yc];
				offsets[i][j] = new Vector2(x, y);
				dimensions[i][j] = new Vector2(columnsWidth[j], rowsHeight[i]);
			}
		}
	}
	
	public void createForProjections(Piece2D piece, int h_spacing, int v_spacing) {
		calculateOffsetsAndDimensions(piece, h_spacing, v_spacing);
		grid.clear();
		Rectangle front = new Rectangle();
		front.setPosition(offsets[1][1]);
		front.setSize(dimensions[1][1].x, dimensions[1][1].y);
		grid.put(PlanUsinage.FRONT, front);
		
		Rectangle back = new Rectangle();
		back.setPosition(offsets[1][3]);
		back.setSize(dimensions[1][3].x, dimensions[1][3].y);
		grid.put(PlanUsinage.BACK, back);
		
		Rectangle top = new Rectangle();
		top.setPosition(offsets[2][1]);
		top.setSize(dimensions[2][1].x, dimensions[2][1].y);
		grid.put(PlanUsinage.TOP, top);
		
		Rectangle bottom = new Rectangle();
		bottom.setPosition(offsets[0][1]);
		bottom.setSize(dimensions[0][1].x, dimensions[0][1].y);
		grid.put(PlanUsinage.DOWN, bottom);
		
		Rectangle left = new Rectangle();
		left.setPosition(offsets[1][2]);
		left.setSize(dimensions[1][2].x, dimensions[1][2].y);
		grid.put(PlanUsinage.LEFT, left);
		
		Rectangle right = new Rectangle();
		right.setPosition(offsets[1][0]);
		right.setSize(dimensions[1][0].x, dimensions[1][0].y);
		grid.put(PlanUsinage.RIGHT, right);
		
	}
	
	public Rectangle getGridCell(PlanUsinage face) {
		return grid.get(face);
	}

	public float getWidth() {
		return width;
	}
	
	public float getHeight() {
		return height;
	}
}
