package reporting;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class SVGWriter {
	
	public static final String HTML_HEADER = "<!DOCTYPE html>\r\n  <html>\r\n <body>\r\n";

	public static final String HTML_FOOTER = "</svg>\r\n</body>\r\n</html>\r\n";

	public static String generateCircleBlock(double x, double y, double radius, Vector3 color) {
		return generateCircleBlock(x, y, radius, color, new Vector2());
	}
	
	public static String generateCircleBlock(double x, double y, double radius, Vector3 color, Vector2 translation) {
		return String.format(
				"<circle cx=\"%s\" cy=\"%s\" r=\"%s\" stroke=\"%s\" stroke-width=\"2\" fill=\"%s\" transform=\"translate(%s,%s)\" />", x, y, radius,
				SVGWriter.encodeColor(color.x, color.y, color.z), SVGWriter.encodeColor(1, 1, 1), translation.x, translation.y);
	}

	public static String generateRectangleBlock(double x, double y, double width, double height, Vector3 color,
			Vector3 border) {
		return generateRectangleBlock(x, y, width, height, color, border, new Vector2());
	}
	
	public static String generateRectangleBlock(double x, double y, double width, double height, Vector3 color,
			Vector3 border, Vector2 translation) {
		return String.format(
				"<rect x=\"%s\" y=\"%s\" width=\"%s\" height=\"%s\"  fill=\"%s\" opacity=\"0.5\" stroke =\"%s\"  stroke-width=\"2\" transform=\"translate(%s,%s)\"  />",
				x, y, width, height, SVGWriter.encodeColor(color.x, color.y, color.z),
				SVGWriter.encodeColor(border.x, border.y, border.z), translation.x, translation.y);
	}

	public static String generateLineBlock(float x1, float y1, float x2, float y2, boolean dashed, Vector3 color) {
		return generateLineBlock(x1, y1, x2, y2, dashed, color, new Vector2());
	}
	
	public static String generateLineBlock(float x1, float y1, float x2, float y2, boolean dashed, Vector3 color, Vector2 translation) {
		return String.format("<line x1=\"%s\" y1=\"%s\" x2=\"%s\" y2=\"%s\" stroke=\"%s\"stroke-width=\"2\" transform=\"translate(%s,%s)\" />", x1,
						y1, x2, y2, SVGWriter.encodeColor(color.x, color.y, color.z), translation.x, translation.y);
	}

	
	public static String generatetext(float x, float y,float rotation, String text, Vector3 color) {
		return String.format("<text transform=\"translate(%s, %s) rotate(%s)\"  fill=\"%s\"  style=\"text-anchor: middle;font-size:24px\">%s</text>", x, y, rotation,
				SVGWriter.encodeColor(color.x, color.y, color.z), text);
	}
	
	
	public static String encodeColor(float r, float g, float b) {
		String red = "#";
		if (Math.round(r * 255) <= 10) {
			red += "0" + Integer.toHexString(Math.round(r * 255));
		} else {
			red += Integer.toHexString(Math.round(r * 255));
		}
		String green = Integer.toHexString(Math.round(g * 255));
		if (Math.round(g * 255) <= 10) {
			green = "0" + green;
		}
		String bleu = "";
		if (Math.round(g * 255) <= 10) {
			bleu += "0" + Integer.toHexString(Math.round(b * 255));
		} else {
			bleu += Integer.toHexString(Math.round(b * 255));
		}
		return red + green + bleu;
	}

	public static String generateCotationCode(Cotation cotation, Vector2 translation) {
		String str = "";
		for(Line line: cotation.getLines()) {
			str += generateLineBlock(line.getStart().x, line.getStart().y, line.getEnd().x, line.getEnd().y, line.isdashed, new Vector3(1,0,0), translation) + "\n";
			if(cotation.getLines().size() == 1)
				str +=generateArrows(line, translation);
		}
		Vector2 absoluteTextPosition = translation.cpy().add(cotation.getTextPos());
		str += generatetext(absoluteTextPosition.x, absoluteTextPosition.y, cotation.getTextRot(), cotation.getText(), new Vector3()) + "\n";
		return str;
	}

	private static String generateArrows(Line line, Vector2 translation) {
		Vector2[] polyStart = new Vector2[3];
		polyStart[0] = line.getStart().cpy().sub(line.getEnd()).nor().scl(3).add(line.getStart());
		polyStart[1] = line.getNormal().cpy().nor().scl(4).add(line.getStart());
		polyStart[2] = line.getNormal().cpy().nor().scl(-4).add(line.getStart());
		
		Vector2[] polyEnd = new Vector2[3];
		polyEnd[0] = line.getEnd().cpy().sub(line.getStart()).nor().scl(3).add(line.getEnd());
		polyEnd[1] = line.getNormal().cpy().nor().scl(4).add(line.getEnd());
		polyEnd[2] = line.getNormal().cpy().nor().scl(-4).add(line.getEnd());
		
		String str = generateArrowBlock(polyStart, translation) + "\n";
		str +=  generateArrowBlock(polyEnd, translation) + "\n";

		
		return str;
	}

	private static String generateArrowBlock(Vector2[] vertices, Vector2 translation) {
		return String.format("<polygon transform=\"translate(%s, %s)\" points=\"%s,%s %s,%s %s,%s \" style=\"fill:black;stroke:black;stroke-width:1\" />",
				translation.x, translation.y, vertices[0].x, vertices[0].y, vertices[1].x, vertices[1].y,vertices[2].x, vertices[2].y);
	}

}
