package reporting;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.MathUtilities;
import dressing.mathutils.Matrix2;

public class Line {
	
	Vector2 start,end ;
	boolean isdashed=false;
	public Line(Vector2 start, Vector2 end,boolean isdashed) {
		this.start = start.cpy();
		this.end = end.cpy();
		this.isdashed=isdashed;
	}

	public Line translate(float x, float y) {
		this.start.add(x, y);
		this.end.add(x,y);
		return this;
	}
	
	public void sort() {
		if(start != null && end != null) {
			if(start.x > end.x) {
				start.add(end);
				end.set(start.cpy().sub(end));
				start.sub(end);
			}else if(Math.abs(start.x - end.x) < 0.001f) {
				if(start.y > end.y) {
					start.add(end);
					end.set(start.cpy().sub(end));
					start.sub(end);
				}
			}
		}
	}
	

	public Line getInversed() {
		return new Line(end, start, isdashed);
	}
	
	public boolean contains(Vector2 point) {
		return Math.abs(point.cpy().sub(start).len() + point.cpy().sub(end).len() - end.cpy().sub(start).len()) < 0.001f;
	}
	
	public boolean isOnline(Vector2 point) {
		Vector2 sp = point.cpy().sub(start);
		return Math.abs(Math.pow(sp.dot(getDirection()), 2) - sp.len2() * getDirection().len2()) < 0.001f;  
	}
	
	//return the equation of the line in the form of ax + by = c
	public Vector3 getEquation() {
		Vector2 n = getNormal();
		return new Vector3(n.x, n.y, start.dot(n));
	}
	
	public boolean isAligned(Line other) {
		return getDirection().isOnLine(other.getDirection());
	}
	
	
	public Vector2 intersects(Line other) {
		Vector3 lineEquation = getEquation();
		Vector3 otherLineEquation = other.getEquation();
		float values[] = new float[] {
				lineEquation.x, lineEquation.y,
				otherLineEquation.x, otherLineEquation.y
		};
		Matrix2 mat = new Matrix2(values);
		return mat.inv().mul(new Vector2(lineEquation.z, otherLineEquation.z));
	}
	
	
	public Vector2 getStart() {
		return start;
	}

	public void setStart(Vector2 start) {
		this.start = start;
	}

	public Vector2 getEnd() {
		return end;
	}

	public void setEnd(Vector2 end) {
		this.end = end;
	}

	public boolean isIsdashed() {
		return isdashed;
	}

	public void setIsdashed(boolean isdashed) {
		this.isdashed = isdashed;
	}
	
	public Vector2 getMiddle() {
		return start.cpy().add(end).scl(0.5f);
	}
	public float getLength () {
		return end.cpy().sub(start).len();
	}
	public Vector2 getDirection () {
		return end.cpy().sub(start);
	}
	public Vector2 getNormal() {
		Vector2 dir = getDirection();
		return dir.rotate90(1);
	}
	
	public Line cpy() {
		return new Line(start.cpy(), end.cpy(), isdashed);
	}


	@Override
	public String toString() {
		return "Line [start=" + start + ", end=" + end + ", isdashed=" + isdashed + "]";
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		Vector3 endH = new Vector3(end,0);
		MathUtilities.round(endH, 2);
		Vector3 startH = new Vector3(start,0);
		MathUtilities.round(startH, 2);
		result = prime * result + ((end == null) ? 0 : endH.hashCode());
		result = prime * result + (isdashed ? 1231 : 1237);
		result = prime * result + ((start == null) ? 0 : startH.hashCode());
		return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Line other = (Line) obj;
		if (end == null) {
			if (other.end != null)
				return false;
		} else if (! (end.epsilonEquals(other.end, 0.01f) || end.epsilonEquals(other.getInversed().end, 0.01f) ))
			return false;
		if (isdashed != other.isdashed)
			return false;
		if (start == null) {
			if (other.start != null)
				return false;
		} else if (!(start.epsilonEquals(other.start, 0.01f) || start.epsilonEquals(other.getInversed().start, 0.01f)))
			return false;
		return true;
	}
	
	public static void main(String[] args) {
		Line line = new Line(new Vector2(), new Vector2(10, 10), false);
		Line line2 = new Line(new Vector2(0,2), new Vector2(4,2), false);
		System.err.println(line + " intersects " + line2);
	}
}
