package geometry;

import org.frs.svg.Plane;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.MathUtilities;
import dressing.mathutils.Triangle;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;


public class Triangle3D {

	private Vector3[] vertices = new Vector3[3];
	
	public Triangle3D(Vector3... vertices) {
		super();
		this.setVertices(vertices);
	}

	public Vector3[] getVertices() {
		return vertices;
	}

	public void setVertices(Vector3... vertices) {
		this.vertices[0] = vertices[0];
		this.vertices[1] = vertices[1];
		this.vertices[2] = vertices[2];
	}
	
	public boolean contains(Vector3 point, float precision) {
		Matrix4 planeTransform = getRelativeTransform();
		Vector3 planePoint = point.cpy().mul(planeTransform);
		if(Math.abs(planePoint.z) > precision)
			return false;
		Vector3 plane0 = this.vertices[0].cpy().mul(planeTransform);
		Vector3 plane1 = this.vertices[1].cpy().mul(planeTransform);
		Vector3 plane2 = this.vertices[2].cpy().mul(planeTransform);
		Triangle triangle = new Triangle(new Vector2(plane0.x, plane0.y),
				new Vector2(plane1.x, plane1.y), new Vector2(plane2.x, plane2.y));
		return triangle.contains(new Vector2(planePoint.x, planePoint.y), precision);
	}
	
	public Matrix4 getRelativeTransform() {
		Vector3 t= vertices[1].cpy().sub(vertices[0]).nor();
		Vector3 b = vertices[2].cpy().sub(vertices[0]).nor();
		Vector3 n = t.cpy().crs(b).nor();
		b = n.cpy().crs(t).nor();
		return MathUtilities.baseChangeMatrix(vertices[0], t, b, n);
	}
	
	private Plane getPlane() {
		return new Plane(vertices[0], vertices[1], vertices[2]);
	}
	
	public static void main(String...strings) {
		Triangle3D triangle = new Triangle3D(new Vector3(0,1,0), new Vector3(1,1,0), new Vector3(1,1,1));
		System.out.println(triangle.contains(new Vector3(0.2f,0.9f,0.2f), 0.001f));
	}
	
}
