package geometry;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;

import dressing.mathutils.Edge;

public class Ray {
	
	private Vector2 origin;
    private Vector2 director;

    public Ray(Vector2 origin, Vector2 director) {
        this.origin = origin;
        this.director = director;
    }


    public Edge getUnitaryEdge(){
        return new Edge(origin, origin.cpy().add(director.nor()));
    }


    public void draw(ShapeRenderer shapeRenderer, float length) {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Color color = shapeRenderer.getColor();
        shapeRenderer.setColor(Color.YELLOW);
        shapeRenderer.line(origin.x,origin.y,origin.x +length * director.x,origin.y + length * director.y);
        shapeRenderer.line(origin.x,origin.y,origin.x -length * director.x,origin.y - length * director.y);
        shapeRenderer.end();
        shapeRenderer.setColor(color);
    }

    public Vector2 getOrigin() {
        return origin;
    }

    public void setOrigin(Vector2 origin) {
        this.origin = origin;
    }

    public Vector2 getDirector() {
        return director;
    }

    public void setDirector(Vector2 director) {
        this.director = director;
    }

}
