package gdxapp.zoneselector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap.Format;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.Array;

import dressing.controller.tools.ToolController;
import dressing.handlers.gdx.ToolControlHandler;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ActorInputListener;
import gdxapp.Commun.GroupSelection;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.ContainerBox;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import geometry.Polygon;
import gdxapp.screens.wall.SurfaceController;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class ZoneSelector extends Actor{
	
	private ArrayList<Polygon> zones;
	private ArrayList<Vector2> temporaryVertices;
	private Vector2 temporaryPolygonVertex;
	private Vector2 temporaryZoneStart;
	private Vector2 temporaryZoneEnd;
	private static Texture texture;
	private static ShapeRenderer renderer;
	private static ShapeDrawer shapeDrawer; 
	private static PolygonSpriteBatch polyBatch;
	private static ZoneSelector selector = new ZoneSelector();
	private ZoneSelectorEventProcessor inputProcessor;
	private com.badlogic.gdx.math.Polygon poly;
	
	private ZoneSelector() {
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		setX(0);
		setY(0);
		setColor(1,0,0,0.5f);
		inputProcessor = new ZoneSelectorEventProcessor(this);
		addListener(inputProcessor);
		temporaryVertices = new ArrayList<Vector2>();
	}
	
	public void createZone() {
//		if(temporaryVertices.size() > 1) {
//			Vector2[] verticesArray = new Vector2[temporaryVertices.size()];
//			for(int i = 0 ; i < verticesArray.length; i++) {
//				verticesArray[i] = new Vector2(temporaryVertices.get(i));
//			}
//			Polygon polygon = new Polygon();
//			polygon.setVertices(verticesArray);
//			if(zones == null)
//				zones = new ArrayList<Polygon>();
//			zones.add(polygon);
//			temporaryVertices.clear();
//		}
	}
	
	public void createPixmap() {
		Pixmap pixmap = new Pixmap(720, 720, Format.RGBA8888);
		pixmap.setColor(1, 0, 0, .4f);
		pixmap.fill();
		texture = new Texture(pixmap);
	}
	
	public void setkeyboardFocus() {
		if (getStage() != null){
					getStage().setKeyboardFocus(this);
		}
	}
	public void draw2(Batch batch, float parentAlpha) {
		if(texture == null)
			createPixmap();
		
		batch.enableBlending();
		if(temporaryZoneStart != null && temporaryZoneEnd != null) {
			batch.begin();
			
			float halfWidth = 0.5f * Math.abs(temporaryZoneEnd.x - temporaryZoneStart.x);
			float halfHeight = 0.5f * Math.abs(temporaryZoneEnd.y - temporaryZoneStart.y);
			Vector2 pos = temporaryZoneEnd.cpy().add(temporaryZoneStart).scl(0.5f);
			pos.x -= halfWidth;
			pos.y -= halfHeight;
			batch.draw(texture, pos.x,pos.y,2 * halfWidth, 2 * halfHeight );
			batch.end();
		}
	}
	@Override
	public void draw(Batch batch, float parentAlpha) {
		if(texture == null)
			createPixmap();
		batch.enableBlending();
		if(temporaryZoneStart != null && temporaryZoneEnd != null) {
			float halfWidth = 0.5f * Math.abs(temporaryZoneEnd.x - temporaryZoneStart.x);
			float halfHeight = 0.5f * Math.abs(temporaryZoneEnd.y - temporaryZoneStart.y);
			Vector2 pos = temporaryZoneEnd.cpy().add(temporaryZoneStart).scl(0.5f);
			pos.x -= halfWidth;
			pos.y -= halfHeight;
			batch.draw(texture, pos.x,pos.y,2 * halfWidth, 2 * halfHeight );
		}
		
		else {
			if (temporaryPolygonVertex != null)
				temporaryVertices.add(temporaryPolygonVertex);
			if (polyBatch == null)
				polyBatch = new PolygonSpriteBatch();
			batch.end();
			polyBatch.setProjectionMatrix(batch.getProjectionMatrix());
			polyBatch.begin();
			if (shapeDrawer == null)
				shapeDrawer = new ShapeDrawer(polyBatch, new TextureRegion(texture));
			if (temporaryVertices.size() > 2) {
				if (poly == null)
					poly = new com.badlogic.gdx.math.Polygon();
				float[] verticesArray = new float[temporaryVertices.size() * 2];
				int counter = 0;
				for (Vector2 vertex : temporaryVertices) {
					verticesArray[counter] = vertex.x;
					counter++;
					verticesArray[counter] = vertex.y;
					counter++;
				}
				poly.setVertices(verticesArray);
				
				shapeDrawer.filledPolygon(verticesArray);
				
			}else if(temporaryVertices.size() == 2){
				shapeDrawer.line(temporaryVertices.get(0), temporaryVertices.get(1));
			}
			temporaryVertices.remove(temporaryPolygonVertex);

			polyBatch.end();
			batch.begin();
		}
	}
	
	

	//getters and setters
	public ArrayList<Polygon> getZones() {
		return zones;
	}


	public void setZones(ArrayList<Polygon> zones) {
		this.zones = zones;
	}

	public static ZoneSelector getSelector() {
		return selector;
	}


	public static void setSelector(ZoneSelector selector) {
		ZoneSelector.selector = selector;
	}

	public ArrayList<Vector2> getTemporaryVertices() {
		return temporaryVertices;
	}

	public void setTemporaryVertices(ArrayList<Vector2> temporaryVertices) {
		this.temporaryVertices = temporaryVertices;
	}

	public Vector2 getTemporaryZoneStart() {
		return temporaryZoneStart;
	}

	public void setTemporaryZoneStart(Vector2 temporaryZoneStart) {
		this.temporaryZoneStart = temporaryZoneStart;
	}

	public Vector2 getTemporaryZoneEnd() {
		return temporaryZoneEnd;
	}

	public void setTemporaryZoneEnd(Vector2 temporaryZoneEnd) {
		this.temporaryZoneEnd = temporaryZoneEnd;
	}

	public Vector2 getTemporaryPolygonVertex() {
		return temporaryPolygonVertex;
	}

	public void setTemporaryPolygonVertex(Vector2 temporaryPolygonVertex) {
		this.temporaryPolygonVertex = temporaryPolygonVertex;
	}
	public void update() {
		if(getTemporaryZoneStart()!=null && getTemporaryZoneEnd()!=null)
		{
			GroupSelection.getInstance().clearSelection();
			Array<Object2D> actors= new Array<Object2D>();
			if(((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
				Array<Object2D> attachedActors=	((SurfaceController)((AbstractScreen) Scene.game.getScreen()).getController()).getAttachedActors();
				actors.addAll(attachedActors);
			}else {
				Array<Actor> stageActors=((RoomController)((AbstractScreen) Scene.game.getScreen()).getController()).getStage().getActors();
				for( Iterator<Actor> iterator=stageActors.iterator();iterator.hasNext();) {
					Actor actor=iterator.next();
					if(actor!=null && actor instanceof Object2D) {
						actors.add((Object2D) actor);
					}
				}
			}
			for( Actor actor:actors) {
				if(actor!=null && actor instanceof Object2D&& actor.isVisible()) {
					Object2D o2=(Object2D) actor;
					float startX=Math.min(getTemporaryZoneStart().x, getTemporaryZoneEnd().x);
					float endX=Math.max(getTemporaryZoneStart().x, getTemporaryZoneEnd().x);
					float startY=Math.min(getTemporaryZoneStart().y, getTemporaryZoneEnd().y);;
					float endY=Math.max(getTemporaryZoneStart().y, getTemporaryZoneEnd().y);;

					List<Edge> edges=o2.getEdges();
					if(edges!=null && edges.size()==4) {
						Edge left=edges.get(1);
						Edge right=edges.get(3);
						Vector2 v00=new Vector2(left.getV0().x,left.getV0().y);
						Vector2 v01=new Vector2(left.getV1().x,left.getV1().y);
						Vector2 v02=new Vector2(right.getV1().x,right.getV1().y);
						Vector2 v03=new Vector2(right.getV0().x,right.getV0().y); 
						//
						Vector2 v10=new Vector2(startX,startY);
						Vector2 v11=new Vector2(startX,endY);
						Vector2 v12=new Vector2(endX,endY);
						Vector2 v13=new Vector2(endX,startY);
						boolean iscontain=MathUtilities.isBoxContainsBox(v00, v01, v02, v03, v10, v11, v12, v13);
						if(iscontain) {
							GroupSelection.getInstance().addObject(o2.getWorldObject());
						}
					}
					
				}
			}
		}
	}
}

class ZoneSelectorEventProcessor extends ActorInputListener{
	
	static private final Vector2 tmpCoords = new Vector2();
	private ZoneSelector zoneSelector;
	private final String TAG = ZoneSelectorEventProcessor.class.getName();
	public ZoneSelectorEventProcessor(ZoneSelector zoneSelector) {
		super();
		this.zoneSelector = zoneSelector;
	}
	
	@Override
	public boolean handle(Event e) {
		if(ToolController.getInstance().isSELECT_ZONE()) {
			return super.handle(e);
		}
		return false;
	}
	@Override
	public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
//		if(!Gdx.input.isKeyPressed(Keys.CONTROL_LEFT))
			zoneSelector.getTemporaryVertices().clear();
//		zoneSelector.setTemporaryZoneStart(null);
		Vector2 point = new Vector2(x, y);
		zoneSelector.setTemporaryZoneStart(point);
		zoneSelector.setTemporaryZoneEnd(point);

//		if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)) {
//			zoneSelector.getTemporaryVertices().add(new Vector2(point));
//			return true;
//		}
		
		return true;
		
	}
	@Override
	public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
		zoneSelector.update();
		zoneSelector.setTemporaryZoneStart(null);
		zoneSelector.setTemporaryZoneEnd(null);
//		ToolController.getInstance().setSELECT_Objects();
		ToolControlHandler.getInstance().triggerSelectObject();
		super.touchUp(event, x, y, pointer, button);
	}
	@Override
	public void touchDragged(InputEvent event, float x, float y, int pointer) {
		zoneSelector.setTemporaryZoneEnd(new Vector2(x,  y));
		zoneSelector.update();
	}
	@Override
	public boolean mouseMoved(InputEvent event, float x, float y) {
		if(Gdx.input.isKeyPressed(Keys.CONTROL_LEFT)) {
			zoneSelector.setTemporaryPolygonVertex(new Vector2(x,y));
		}
		return super.mouseMoved(event, x, y);
	}
	@Override
	public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
		// TODO Auto-generated method stub
		super.enter(event, x, y, pointer, fromActor);
	}
	@Override
	public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
		// TODO Auto-generated method stub
		super.exit(event, x, y, pointer, toActor);
	}
	@Override
	public boolean scrolled(InputEvent event, float x, float y, int amount) {
		// TODO Auto-generated method stub
		return super.scrolled(event, x, y, amount);
	}
	@Override
	public boolean keyDown(InputEvent event, int keycode) {
		if(keycode == Keys.ENTER) {
			
		}
		return super.keyDown(event, keycode);
	}
	@Override
	public boolean keyUp(InputEvent event, int keycode) {
		Gdx.app.debug(TAG, Keys.toString(keycode) + " key up");
		return super.keyUp(event, keycode);
	}

	
	
	
}
