package gdxapp.ui;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.ui.TextField.TextFieldFilter;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

import gdxapp.animation.AnimationManager;
import gdxapp.animation.Object3DAnimator;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.Animation;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WorldObject;
import gdxapp.screens.room3d.Room3DController;

public class MoveToWindow extends Window {
	//this is the stage of the actor is intended to be part of 
	private Stage intendedStage;
	private TextField[] coordsInput;
	private TextButton applyBtn;
	private TextButton cancelBtn;
	private float[] coords = new float[3];
	private Object3D target;
	
	public MoveToWindow(Object3D target, Stage intendedStage) {
		super("Déplacer vers", AssetsTextures.getInstance().getSkin());
		this.target = target;
		this.intendedStage = intendedStage;
		createControl();
	}

	private void createControl() {
		coordsInput = new TextField[3];
		var pos = target.getWorldObject().getRealWorldPosition().cpy().scl(1000);
		coords[0] = pos.x;
		coords[1] = pos.y;
		coords[2] = pos.z;
		for(int i = 0; i < 3; i++) {
			coordsInput[i] = new TextField("", getSkin());
			coordsInput[i].setText(String.format("%.0f", coords[i]));
			coordsInput[i].setTextFieldFilter(new TextFieldFilter.DigitsOnlyFilter());
		}
		
		applyBtn = new TextButton("Appliquer", getSkin());
		applyBtn.addListener( new ChangeListener() {
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				apply();	
			}
		});
		cancelBtn = new TextButton("Annuler", getSkin());
		cancelBtn.addListener( new ChangeListener() {
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				cancel();	
			}
		});
		
		float width = 80;
		defaults().pad(5).center();
		add(new Label("X: ", getSkin(), "default"));
		add(coordsInput[0]).width(width);
		add(new Label("Y: ", getSkin(), "default"));
		add(coordsInput[1]).width(width);;
		add(new Label("Z: ", getSkin(), "default"));
		add(coordsInput[2]).width(width);;
		row();
		add(applyBtn).colspan(2).right().pad(10);
		add();
		add();
		add(cancelBtn).colspan(2).left().pad(10);
	}
	
	public Vector3 parseInput() {
		float x, y ,z;
		try {
			x = Float.parseFloat(coordsInput[0].getText());
			y = Float.parseFloat(coordsInput[1].getText());
			z = Float.parseFloat(coordsInput[2].getText());

		} catch (Exception e) {
			return null;
		}
		return new Vector3(x, y , z);
		
	}
	
	private void apply() {
		//to implement
		Object3DAnimator animator = new  Object3DAnimator();
		animator.setTarget(target);
		Vector3 input = parseInput();
		if(input == null) {
			close();
			return;
		}
		input.scl(1e-3f);
		Animation animation =  animator.moveTo(input, 0.5f);
		AnimationManager.getInstance().submitAnimations(animation);
		close();
	}
	
	private void cancel() {
		close();
		clear();
	}
	
	public void open() {
		intendedStage.addActor(this);
		setSize(400, 150);
		setPosition(getStage().getWidth()/2, getStage().getHeight()/2);
		intendedStage.setKeyboardFocus(this);
	}
	
	public void close() {
		remove();
	}

}
