package gdxapp.shapes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Align;

import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.LineObject;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.AssetFont;
import gdxapp.assets.SDFFont;
import gdxapp.quotation.Quotation;
import gdxapp.scenes.Scene;
import gdxapp.screens.wall.SurfaceController;

public class LineSegment {
	
	private boolean cut = false;
	private Vector2 start = new Vector2();
	private Vector2 end = new Vector2();
	private transient Vector2 dir = new Vector2();
	private transient Vector2 normal = new Vector2();
	private Matrix4 transform = new Matrix4().idt();
	
	
	public PropertyChangeListener pcl=new PropertyChangeListener() {
		@Override
		public void propertyChange(PropertyChangeEvent arg0) {
			if(arg0.getPropertyName().contentEquals("recalculate")) {
			}
		}
	};
	
	public LineSegment(Vector2 start, Vector2 end) {
		super();
		this.start = start;
		this.end = end;
		this.dir = end.cpy().sub(start).nor();
	}
	
	public LineSegment() {	}

	public Matrix4 getTransform() {
		return transform;
	}

	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}
	
	

	public boolean isCut() {
		return cut;
	}

	public void setCut(boolean cut) {
		this.cut = cut;
	}

	public LineSegment cpy() {
		LineSegment copy = new LineSegment(this.start, this.end);
		copy.setTransform(transform.cpy());
		copy.setCut(cut);
		return copy;
	}
	
	public float dst(Vector2 stagePoint) {
		Vector2 om = stagePoint.cpy().sub(start);
		Vector2 os = end.cpy().sub(start);
		float dot = om.dot(end.cpy().sub(start));
		Vector2 p = start.cpy().add(os.cpy().nor().scl(dot));
		if( Math.abs(p.cpy().sub(start).len() + end.cpy().sub(p).len() - os.len()) < 1e-3){
			return om.sub(p.cpy().sub(start)).len();
		}else {
			return Math.min(stagePoint.dst(start), stagePoint.dst(end));
		}
	}
	

	
	//in order to avoid binding and unbinding the shapeRenderer unnecessarly
	//the responsibility of the shape renderer management falls on the caller of the function 
	public void draw(ShapeRenderer shapeRenderer, Color color, float thickness, boolean drawLength) {
		
		shapeRenderer.setColor(color);
		shapeRenderer.rectLine(start, end, thickness);
		
	}
	
	

	
	

}
