package gdxapp.shapes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Align;

import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.LineObject;
import gdxapp.Commun.ScreenController;
import gdxapp.Commun.Fleche.Direction;
import gdxapp.assets.AssetFont;
import gdxapp.quotation.Quotation;
import gdxapp.scenes.Scene;
import gdxapp.screens.wall.SurfaceController;

public class FlecheSegment extends Actor {
	
	private String description;
	private int direction;
	private float scale;
	private static ShapeRenderer renderer;
	private static BitmapFont font;
	private LineObject line;
	private Vector2 startImage;
	private Vector2 endImage;
	private transient Vector2 directorImage;
	private transient Vector2 normalImage;
	public PropertyChangeListener pcl=new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent arg0) {
			if(arg0.getPropertyName().contentEquals("recalculate")) {
				recalculate();
			}
			
		}
	};
	public FlecheSegment() {
		super();
		setWidth(0);
		setHeight(0);
		
//		addListener(new LineSegmentEventProcessor(this));
		
	}

	public FlecheSegment(LineObject line) {
		this();
		this.line = line;
	}

	public void recalculate() {
		if(getStart()!=null ) {
			Vector2 end=getEnd()!=null?getEnd():getTmpVertex();
			if(end!=null) {
				startImage=getStart().cpy();
				endImage=end.cpy();
				if(getOffset()!=0.0f)
				{
					startImage.add(getNormal().cpy().scl(getOffset()));
					endImage.add(getNormal().cpy().scl(getOffset()));

				}
				this.directorImage = end.cpy().sub(startImage).nor();
				this.normalImage = new Vector2(-directorImage.y, directorImage.x);
			}
			

		}
		

	}
	public FlecheSegment cpy() {
		FlecheSegment copy = new FlecheSegment(getLine());
		copy.setScale(getScale());
		
		if(this.description != null)
			copy.description = new String(this.description);
		copy.setDirection(getDirection());
		return copy;
	}

	public int getDirection() {
		return direction;
	}

	public void setDirection(int direction) {
		this.direction = direction;
	}

	public Vector2 getDirectorImage() {
		return directorImage;
	}
	public void setDirectorImage(Vector2 directorImage) {
		this.directorImage = directorImage;
	}
	public Vector2 getNormalImage() {
		return normalImage;
	}
	public void setNormalImage(Vector2 normalImage) {
		this.normalImage = normalImage;
	}
	
	public Vector2 getStartImage() {
		return startImage;
	}
	public void setStartImage(Vector2 startImage) {
		this.startImage = startImage;
	}
	public Vector2 getEndImage() {
		return endImage;
	}
	public void setEndImage(Vector2 endImage) {
		this.endImage = endImage;
	}
	public boolean contains(Vector2 point) {
		return getLine().contains(point,getScale());
	}
	public void updateScale() {
		try {
			AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
			ScreenController controller = screen.getController();
			float[] scales = controller.getScales();
			setScale(scales[0]);
			
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		updateScale();
		getRenderer().setProjectionMatrix(batch.getProjectionMatrix());
		if(getStart() != null) {
			boolean tmpUsed = false;
			if(getEnd() == null && getTmpVertex() != null) {
				setEnd(getTmpVertex());
				tmpUsed = true;
			}
			if(getEnd() != null) {
				boolean batchInterrupted = false;
		    	if(batch.isDrawing()) {
		    		batch.end();
		    		batchInterrupted = true;
		    	}
				
		    	getRenderer().begin(ShapeType.Filled);
		    	getRenderer().setColor(getLine().getTmpcolor());
		    	getRenderer().rectLine(getStart().x, getStart().y, getEnd().x, getEnd().y,2);
		    	getRenderer().end();
				
				if( getOffset()!=0.0f) {
					getRenderer().begin(ShapeType.Filled);
					getRenderer().setColor(getColor());
					float offset = Math.abs(getOffset());
					if(direction == Fleche.START||direction == Fleche.DOUBLE) {
						Vector2 startImage=getStart().cpy();
						Vector2 startImage1=getStart().cpy();
						Vector2 startImage2=getStart().cpy();

						startImage.add(getNormal().cpy().scl(offset/2)).add(getDirector().cpy().scl(offset));
						startImage1.add(getNormal().cpy().scl(-offset/2)).add(getDirector().cpy().scl(offset));
						startImage2.add(getDirector().cpy().scl(offset*0.6f));

						getRenderer().triangle(getStart().x, getStart().y, startImage.x, startImage.y, startImage2.x, startImage2.y);
						getRenderer().triangle(getStart().x, getStart().y, startImage2.x, startImage2.y, startImage1.x, startImage1.y);

					}
				
					if(direction==Fleche.END||direction==Fleche.DOUBLE) {

						Vector2 endImage=getEnd().cpy();
						Vector2 endImage1=getEnd().cpy();
						Vector2 endImage2=getEnd().cpy();

						endImage.add(getNormal().cpy().scl(offset/2)).add(getDirector().cpy().scl(-offset));
						endImage1.add(getNormal().cpy().scl(-offset/2)).add(getDirector().cpy().scl(-offset));
						endImage2.add(getDirector().cpy().scl(-offset*0.6f));
						getRenderer().triangle(getEnd().x, getEnd().y, endImage.x, endImage.y, endImage2.x, endImage2.y);
						getRenderer().triangle(getEnd().x, getEnd().y, endImage2.x, endImage2.y, endImage1.x, endImage1.y);

					}
					getRenderer().setColor(getColor());
					getRenderer().end();
					
				}
		        if(batchInterrupted)
	            {
		        	batch.begin();
	            }
			}
			if(tmpUsed)
			{
				setEnd(null);
			}
		}
		
	}
	//the rotation of the edge in the x-y plan
	public float getRotation() {
		
		return line.getRotation();
	}
	 public float getLength() {
			
	        return this.line.getLength();
	   }
	
	public Vector2 getDirector() {
		
		return this.line.getDirector();
	}
	
	public Vector2 getNormal() {
		return line.getNormal();
	}
	
	public FlecheSegment endDrawing() {
		Object listeners = this.getListeners();
		listeners.equals(this);
		return this;
	}
	
	public Vector2 getStart() {
		return line.getStart();
	}
	public void setStart(Vector2 start) {
		this.line.setStart(start);

	}
	public Vector2 getEnd() {
		return line.getEnd();
	}
	public void setEnd(Vector2 end) {
		this.line.setEnd(end);
	}
	public Vector2 getMiddle() {
		return line.getMiddle();
	}
	
	public float getOffset() {
		return line.getOffset();
	}
	
	public Vector2 getTmpVertex() {
		return line.getTmpVertex();
	}
	
	public Color getColor() {
		return line.getColor();
	}
	
	public float getMeasurement() {
		float measure = Float.NaN;
		if(getStart() != null && getEnd() != null) {
			measure= getStart().dst(getEnd())*(1/getScale());
		}
		return measure;
	}
	
	
	public float getScale() {
		updateScale();
		return scale;
	}
	public void setScale(float scale) {
		if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
			this.scale=1/scale;
		}else
		{
			this.scale = scale;
		}
	}
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	public Vector2 getNearestEdge(Vector2 point) {
		Vector2 nearest = (getStart().dst(point) < getEnd().dst(point))? getStart():getEnd();
		if(nearest.dst(point) * getScale() < 0.5f)
			return nearest;
		return null;
	}
	
	public static ShapeRenderer getRenderer() {
		if(renderer == null)
			renderer = new ShapeRenderer();
		return renderer;
	}
	public static void setRenderer(ShapeRenderer renderer) {
		FlecheSegment.renderer = renderer;
	}
	public static BitmapFont getFont() {
		if(font == null)
    		font = AssetFont.getInstance().getFont();
		return font;
	}
	public static void setFont(BitmapFont font) {
		FlecheSegment.font = font;
	}
	public LineObject getLine() {
		return line;
	}
	public void setLine(LineObject line) {
		
		this.line = line;
	}
	@Override
	public void clear() {
		super.clear();
	
	}
	
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		this.clear();

	}
	public void setLength(float length, int direction) {
		line.setLength(length, direction);
	}
	public void setLength(float length) {
		setLength(length, 1);
	}
	
	

}
