package gdxapp.shaders;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;
import dressing.config.WorkspaceConfiguration;

public class MonoColorShader implements Shader{
	
	private ShaderProgram program;
    private Camera camera;
    private RenderContext context;

	@Override
	public void dispose() {
		program.dispose();
	}

	@Override
	public void init() {
		String vertx = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + "/monocolor/vertex.glsl").readString();
        String frag = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + "/monocolor/frag.glsl").readString();
        program = new ShaderProgram(vertx,frag);
        if(!program.isCompiled())
            throw new GdxRuntimeException(program.getLog());
        program.pedantic = false;
		
	}

	@Override
	public int compareTo(Shader other) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public boolean canRender(Renderable instance) {
		// TODO Auto-generated method stub
		return instance.material.has(ColorAttribute.Diffuse);
	}

	@Override
	public void begin(Camera camera, RenderContext context) {
		this.camera = camera;
        this.context = context;
        context.setCullFace(GL20.GL_BACK);
        context.setDepthTest(GL20.GL_LESS);
        program.begin();
        program.setUniformMatrix("vp", camera.combined);	
        program.setUniformf("camera_pos", camera.position);
        program.setUniformf("light_pos", new Vector3(5,5,5));
	}

	@Override
	public void render(Renderable renderable) {
		program.setUniformMatrix("model", renderable.worldTransform);
		Matrix3 normal = new Matrix3().set(renderable.worldTransform).inv().transpose();
		program.setUniformMatrix("normal", normal);
		ColorAttribute color = (ColorAttribute) renderable.material.get(ColorAttribute.Diffuse);
		program.setUniformf("color", color.color);
		renderable.meshPart.render(program);
	}

	@Override
	public void end() {
		// TODO Auto-generated method stub
		program.end();
	}

}
