package gdxapp.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.GdxRuntimeException;

import dressing.config.WorkspaceConfiguration;

public class DiffuseShader implements Shader {

	ShaderProgram program;
	private RenderContext context;
	
	
	
	@Override
	public void dispose() {
		program.dispose();
	}

	@Override
	public void render(Renderable renderable) {
		program.setUniformMatrix("model", renderable.worldTransform);
		program.setUniformf("hasAlbedoMap",0.0f);
		program.setUniformf("baseColor", 1.0f, 1.0f, 1.0f, 1.0f);
		if (renderable.material.has(ColorAttribute.Diffuse)) {
			Color diffuse = ((ColorAttribute) renderable.material.get(ColorAttribute.Diffuse)).color;
			program.setUniformf("baseColor", diffuse.r, diffuse.g, diffuse.b, diffuse.a);
		}
		if(renderable.material.has(TextureAttribute.Diffuse)) {
			TextureAttribute textureAttribute = (TextureAttribute) renderable.material.get(TextureAttribute.Diffuse);
            if(textureAttribute.textureDescription.texture.getTextureData() != null){
                program.setUniformi("albedoMap", context.textureBinder.bind(textureAttribute.textureDescription));
                program.setUniformf("hasAlbedoMap",1.0f);
            }
		}
		renderable.meshPart.render(program);
	}

	@Override
	public void init() {
		String vertex_shader_text = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + "/diffuse/vertx.glsl").readString();;
		String pixel_shader_text = Gdx.files.absolute(WorkspaceConfiguration.SHADERS_PATH + "/diffuse/frag.glsl").readString();
		program = new ShaderProgram(vertex_shader_text, pixel_shader_text);
		if (!program.isCompiled())
			throw new GdxRuntimeException(program.getLog());
		program.pedantic = false;

	}

	@Override
	public void end() {
		program.end();
	}

	@Override
	public int compareTo(Shader other) {
		return 0;
	}

	@Override
	public boolean canRender(Renderable instance) {
		return true;
	}

	@Override
	public void begin(Camera camera, RenderContext context) {
		if(program == null)
			init();
		this.context = context;
        this.context.setBlending(true, GL20.GL_SRC_ALPHA , GL20.GL_ONE_MINUS_SRC_ALPHA);
        this.context.setDepthTest(GL20.GL_LEQUAL);
		program.begin();
		program.setUniformMatrix("vp", camera.combined);
	}
	
	public ShaderProgram getProgram() {
		if(program == null)
			init();
		return program;
	}
	
}
