package gdxapp.screens.wall;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import dressing.events.Event;
import dressing.events.EventHandler;
import dressing.mathutils.Surface;
import dressing.model.Intervale;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.ui.ChangeCommandController;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.Measure;
import gdxapp.Commun.MeasuresTaker;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.AssetFont;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.RotatedBoundingBox;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.CameraController;
import gdxapp.screens.room.RoomController;
import gdxapp.ui.ActionItem;
import gdxapp.ui.Note;
import gdxapp.ui.ObjectMenuList;
import param.MechanicPublicParam;

public class SurfaceController implements ScreenController<Object2D>, EventHandler {

	private Surface surface;
	private Array<Object2D> attachedActors = new Array<Object2D>();;
	private Stage stage;
	private Stage uiStage;
	private InputMultiplexer inputMultiplexer;
	private WallActionController wallActionController;
	private SurfaceManager wallSpaceManager;
	private Object2D reference = null;
	private boolean handleEvent;
	private ChangeCommandController changeCommandController = new ChangeCommandController();
	private Image backGroundImg;
	private CameraController cameraController;
	private ShapeRenderer shapeRenderer;
	private OrthographicCamera stageCamera;
	
	private ArrayList<Vector2> referencePoints = new ArrayList<Vector2>();

	public SurfaceController() {
		subscribe(SceneEvent.DELETE_OBJECT.name(), SceneEvent.OBJECT_SELECTED.name(),
				SceneEvent.OBJECT_CHANGED.name(), SceneEvent.DISPLAY_ACTIONS_MENU.name(),
				SceneEvent.OBJECT_DROP.name(), SceneEvent.SHOW_OBJECT.name(), SceneEvent.VOID_CLICK.name(), SceneEvent.INVOKE_MEASURER.name(),SceneEvent.RESET_CAMERA.name());
		wallActionController = new WallActionController(this);
		wallSpaceManager = new SurfaceManager();
		inputMultiplexer = new InputMultiplexer();
		createStage();
	}

	SurfaceController(Surface surface) {
		this();
		setSurface(surface);
	}

	public void setSurface(Surface surface) {
		if(surface != this.surface) {
			this.surface = surface;
			clearObjects();
			wallSpaceManager = new SurfaceManager(this);
			wallSpaceManager.update(this);
		}
	}

	private void clearObjects() {
		attachedActors.clear();
		stage.clear();
		createWallImage();
	}

	public void createStage() {
		stage = new Stage(new ScreenViewport());
		stageCamera = (OrthographicCamera) stage.getCamera();
		stageCamera.setToOrtho(false);
		cameraController = new CameraController(stageCamera);

		uiStage =  new Stage(new ScreenViewport());
		uiStage.addActor(OnSurfacePositioner.getPositioner());
		setUpInputMultiplexer();
		shapeRenderer = new ShapeRenderer();
	}
	
	
	public void centerCamera() {
		Vector3 position =  surface.getStart().cpy().add(surface.getEnd()).scl(0.5f) .mul(surface.getWorldToSurfaceTransform());
		stageCamera.position.set(position);
		stageCamera.update();
		float padding = getScale() * 0.4f;
		stageCamera.zoom = Math.max((surface.getLength() + padding) /stageCamera.viewportWidth,  (surface.getHeight() + padding) /stageCamera.viewportHeight) ;
		stageCamera.update();
	}
	
	public void drawGrid() {
		
		float pixel = stageCamera.unproject(new Vector3(1,0,0)).sub(stageCamera.unproject(new Vector3())).len();
		float exponent = (float) Math.floor(Math.log10(pixel));
		float bigStep = (float) Math.pow(10, exponent + 3);
		shapeRenderer.begin(com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType.Filled);
		shapeRenderer.setProjectionMatrix(stageCamera.combined);
		Gdx.gl.glEnable(GL20.GL_BLEND);
		Gdx.gl.glBlendFunc(GL20.GL_SRC_ALPHA, GL20.GL_ONE_MINUS_SRC_ALPHA);
		Vector3 mainColor = new Vector3(0.5f, 0.5f, 0.5f);
		Vector3 secondaryColor = new Vector3(0.5f, 0.5f, 0.9f);

		Vector3 upperBound =  stageCamera.unproject(new Vector3(Gdx.graphics.getWidth(), 0,0));
		Vector3 lowerBound =  stageCamera.unproject(new Vector3(0, Gdx.graphics.getHeight(),0));

		float cursor = 0;
		float smallCursor;
		
		//origin
		float halfAxe = 100000;
		shapeRenderer.setColor(1.0f,0.0f,0.0f,0.2f);
		shapeRenderer.rectLine(new Vector2(0,-halfAxe), new Vector2(0,halfAxe), 4.0f * pixel);
		shapeRenderer.rectLine(new Vector2(-halfAxe,0), new Vector2(halfAxe,0), 4.0f * pixel);

		//vertical lines
		while(cursor < Math.max( Math.abs(upperBound.x), Math.abs(lowerBound.x))) {
			shapeRenderer.setColor(mainColor.x ,mainColor.y, mainColor.z, 0.2f);
			shapeRenderer.rectLine(new Vector2(cursor, lowerBound.y), new Vector2(cursor, upperBound.y),2 * pixel);
			shapeRenderer.rectLine(new Vector2(-cursor, lowerBound.y), new Vector2(-cursor, upperBound.y),2 * pixel);
			smallCursor = cursor + bigStep/10.0f;
			shapeRenderer.setColor(secondaryColor.x, secondaryColor.y, secondaryColor.z, 0.2f);
			while(smallCursor < cursor + bigStep) {
				shapeRenderer.rectLine(new Vector2(smallCursor, lowerBound.y), new Vector2(smallCursor, upperBound.y), pixel);
				shapeRenderer.rectLine(new Vector2(-smallCursor, lowerBound.y), new Vector2(-smallCursor, upperBound.y), pixel);
				smallCursor += bigStep/10.0f;
			}
			cursor+= bigStep;
		}
		//horizntal line
		cursor = 0;
		while(cursor < Math.max( Math.abs(upperBound.y), Math.abs(lowerBound.y))) {
			shapeRenderer.setColor(mainColor.x ,mainColor.y, mainColor.z, 0.2f);
			shapeRenderer.rectLine(new Vector2(lowerBound.x, cursor), new Vector2(upperBound.x, cursor),2 * pixel);
			shapeRenderer.rectLine(new Vector2(lowerBound.x, -cursor), new Vector2(upperBound.x, -cursor),2 * pixel);
			smallCursor = cursor + bigStep/10.0f;
			shapeRenderer.setColor(secondaryColor.x, secondaryColor.y, secondaryColor.z, 0.2f);
			while(smallCursor < cursor + bigStep) {
				shapeRenderer.rectLine(new Vector2(lowerBound.x, smallCursor), new Vector2(upperBound.x, smallCursor), pixel);
				shapeRenderer.rectLine(new Vector2(lowerBound.x, -smallCursor), new Vector2(upperBound.x, -smallCursor), pixel);
				smallCursor += bigStep/10.0f;
			}
			
			cursor+= bigStep;
		}
		shapeRenderer.end();
		
		cursor = bigStep;
		uiStage.getBatch().begin();
		while(cursor < Math.max( Math.abs(upperBound.x), Math.abs(lowerBound.x))) {
			Vector2 cursorScreen = uiStage.screenToStageCoordinates(stage.stageToScreenCoordinates(new Vector2(cursor, 0))); 
			Vector2 minusCursorScreen = uiStage.screenToStageCoordinates(stage.stageToScreenCoordinates(new Vector2(-cursor, 0))); 
			AssetFont.getInstance().getSmallFont().drawTransformed(uiStage.getBatch(), String.format("%.0f", cursor * 1000/getScale()), cursorScreen.x, cursorScreen.y,
					28 , 0, 0, -1, Color.GRAY);	
			AssetFont.getInstance().getSmallFont().drawTransformed(uiStage.getBatch(), String.format("%.0f", -cursor * 1000/getScale()), minusCursorScreen.x, minusCursorScreen.y,
					28, 0, 0, -1, Color.GRAY);	
			cursor += bigStep;
		}
		
		cursor = bigStep;
		while(cursor < Math.max( Math.abs(upperBound.y), Math.abs(lowerBound.y))) {
			Vector2 cursorScreen = uiStage.screenToStageCoordinates(stage.stageToScreenCoordinates(new Vector2(0, cursor))); 
			Vector2 minusCursorScreen = uiStage.screenToStageCoordinates(stage.stageToScreenCoordinates(new Vector2(0, -cursor))); 
			AssetFont.getInstance().getSmallFont().drawTransformed(uiStage.getBatch(), String.format("%.0f ", cursor * 1000/getScale()), cursorScreen.x, cursorScreen.y,
					28 , 0, 1, -0, Color.GRAY);	
			AssetFont.getInstance().getSmallFont().drawTransformed(uiStage.getBatch(), String.format("%.0f ", -cursor * 1000/getScale()), minusCursorScreen.x, minusCursorScreen.y,
					28, 0, 1, 0, Color.GRAY);	
			cursor += bigStep;
		}
		uiStage.getBatch().end();
	}



	void setUpInputMultiplexer() {
		inputMultiplexer.clear();
		this.inputMultiplexer.addProcessor(cameraController);
		this.inputMultiplexer.addProcessor(uiStage);
		this.inputMultiplexer.addProcessor(stage);
		this.inputMultiplexer.addProcessor(wallActionController);
		Gdx.input.setInputProcessor(this.inputMultiplexer);
	}

	public void createWallImage() {
		ProjectManager.instance.getCurrentScene().getPreferences().getWallMtl().prepare();
		if(backGroundImg != null)
			backGroundImg.remove();
		backGroundImg = new Image(surface.getWall().getMaterial().getAlbedoMap());
		backGroundImg.setSize(surface.getLength(), surface.getHeight());
		backGroundImg.setZIndex(0);
		stage.addActor(backGroundImg);
	}

	@Override
	public void dropActor(Object actor, float x, float y) {
		if (actor instanceof WorldObject) {
			Object2D article = ((WorldObject) actor).create2DObject();
			fitToStage(article);
			attachActor(article);
			stage.addActor(article);
			setStageDimension(article);
			float z = article.getWorldObject().getRealWorldDimension().z * 0.5f;
			if (article.getWorldObject().isConstraint()) {
				z *= -1;
			}
			article.setZ(z);
			article.setPosition(x, y); 
			attachedActors.add(article);
			this.wallSpaceManager.addActor(article);
			//
			surfaceAssist(article);
			WorldObject object = (WorldObject) actor;
			object.setRotation(surface.getyRotation());
			fitToStage(article);
			ProjectManager.getManager().getCurrentScene().addActor((WorldObject) actor, false);
		}
	}

	private void setStageDimension(Object2D actor) {
		Vector3 stageSize = getSurfaceDimension(actor);
		actor.setSize(stageSize.x, stageSize.y);
	}

	private Vector3 getSurfacePosition(Object2D object2d) {
		Vector3 stageSize =  getSurfaceDimension(object2d);
		Vector3 position = surface.toSurfaceCoords(object2d.getWorldObject().getRealWorldPosition().cpy());
		position.x -= stageSize.x / 2;
		position.y -= stageSize.y / 2;
		return position;
	}
	
	public void setActorsRealWorldPosition() {
		for (Object2D actor : attachedActors) {
			float x = (actor.getX() + actor.getWidth() / 2);
			float y = (actor.getY() + actor.getHeight() / 2);
			Vector3 realPosition = surface.toWorldCoords(new Vector3(x, y, actor.getZ()));
			actor.getWorldObject().setRealWorldPosition(realPosition);
			actor.getWorldObject().setActiveWidth(false);
		}
	}

	private void fitToStage(Object2D object2d) {
		setStageDimension(object2d);
		Vector3 positionSurface = getSurfacePosition(object2d);
		object2d.setPosition(positionSurface.x, positionSurface.y, positionSurface.z);
		object2d.setTopView(false);
		object2d.adjustTextureAndColors();
		object2d.setZIndex(Math.max(1,Math.round(positionSurface.z + object2d.getWorldObject().getRealWorldDimension().z)));
	}

	private Vector3 getSurfaceDimension(Object2D object2d) {		
		
		WorldObject worldObject = object2d.getWorldObject();
		Vector3 halfSize =  worldObject.getRealWorldDimension().xyz().scl(0.5f);
		float rotation = worldObject.getRotation();
		RotatedBoundingBox boundingBox = new RotatedBoundingBox();
		boundingBox.set(halfSize.cpy().scl(-1), halfSize);
		boundingBox.normalize();
		
		Matrix4 rotTransform = new Matrix4().setToRotation(Vector3.Y, rotation);
		boundingBox.setTransform(surface.getWorldToSurfaceTransform().mul(rotTransform.mul(boundingBox.getTransform())));
		Vector3 size = new Vector3();
		boundingBox.getDimensions(size);
		float height = Math.abs(size.y);
		float width =  Math.abs(size.x);
		float depth = Math.abs(size.z);
		return new Vector3(width, height, depth);
	}

	public void resize() {

		for (Object2D actor : attachedActors) {
			setStageDimension(actor);
		}
	}

	Object2D getSelectedActor() {
		for (Object2D actor : attachedActors) {
			if (actor.getWorldObject().isSelected())
				return actor;
		}
		return null;
	}
	float getScale() {
		return surface.getScale();
	}

	@Override
	public void reloadActors() {
		OnSurfacePositioner.getPositioner().setController(this);
		for (WorldObject wObject : ProjectManager.instance.getCurrentScene().getSceneObjects()) {
			if (!(wObject instanceof Wall) && !wObject.getType().equals(ObjectType.POLY)) {
				Object2D object2D = getObject(wObject);
				if(object2D == null)
					object2D = wObject.create2DObject();
				float rot = wObject.getRotation();
				float depth=0;
				if ((Math.abs((Math.abs(rot - surface.getyRotation()) - 90) % 180) < 1)) {
					wObject.setActiveWidth(true);
					depth=wObject.getRealWorldDimension().x;
				} else {
					wObject.setActiveWidth(false);
					depth=Math.max(wObject.getRealWorldDimension().z, wObject.getRealWorldDimension().w);;
				}
				Vector3 dimension = getSurfaceDimension(object2D);
				Vector3 position = getSurfacePosition(object2D);				
				boolean zTest = position.z + dimension.z/2.0f + 0.01f  > 0.0f && position.z - dimension.z/2.0f  < 0.2f;
				if(zTest) {
					boolean xTest = (position.x + dimension.x/2.0f) > 0.0f && position.x - dimension.x/2 < surface.getLength() * getScale();
					boolean yTest = position.y + dimension.y/2.0f  > 0.0f && position.y - dimension.y /2.0f  < surface.getHeight() * getScale();
					if (xTest && yTest) {
						fitToStage(object2D);
						attachActor(object2D);
						continue;
					}
				}
				detachActor(object2D);
			}
		}
		for (Note note : ProjectManager.instance.getCurrentScene().getNotes()) {
			if (note.getContext() != null && note.getContext().equals(this.surface))
				stage.addActor(note);
		}
		for (Measure measure : ProjectManager.instance.getCurrentScene().getMeasures()) {
			//if (measure.getContext() != null && measure.getContext().equals(this.surface))
				//stage.addActor(measure.getLineSegment());
		}
		for (Fleche fleche : ProjectManager.instance.getCurrentScene().getFleches()) {
			if (fleche.getContext() != null && fleche.getContext().equals(this.surface)) {
				stage.addActor(fleche.getFlecheSegment());
			}
		}
//		if (!getInputMultiplexer().getProcessors().contains(OnSurfacePositioner.getPositioner(), true)) {
//			getInputMultiplexer().addProcessor(OnSurfacePositioner.getPositioner());
//			Gdx.input.setInputProcessor(getInputMultiplexer());
//		}
		
		OnSurfacePositioner.getPositioner().begin();
	}
	
	public Array<Object2D> getAttachedActors() {
		return attachedActors;
	}
	
	public void attachActor(Object2D object) {
		if(!attachedActors.contains(object, true)) {
			attachedActors.add(object);
			stage.addActor(object);
		}
	}
	
	public void detachActor(Object2D object) {
		attachedActors.removeValue(object, true);
		object.delete();
	}

	@Override
	public void updateWorldObject(Object2D object2d) {
		float x = (object2d.getX() + object2d.getWidth() / 2);
		float y = (object2d.getY() + object2d.getHeight() / 2);
		float z = object2d.getZ();
		Vector3 realPosition = surface.toWorldCoords(new Vector3(x, y, z));
		object2d.getWorldObject().setRealWorldPosition(realPosition);
		object2d.getWorldObject().firePropertyChange("position", null, 5);
		object2d.getWorldObject().firePropertyChange("dimension", null, 5);
		object2d.adjustTextureAndColors();
		object2d.setTopView(false);

	}

	public void updateWorldObjectDimention(Object2D object2d) {
		float x = object2d.getWidth() / stage.getWidth();
		float y = object2d.getHeight() / stage.getHeight();
		object2d.getWorldObject().getRealWorldDimension().x = x;
		object2d.getWorldObject().getRealWorldDimension().y = y;
	}

	public void updateObject2D(Object2D object2D) {
		if (attachedActors != null && attachedActors.contains(object2D, false)) {
			fitToStage(object2D);
		}
	}
	
	public void showElement(WorldObject object) {
		var object2D = getObject(object);
		if(object2D != null) {
			fitToStage(object2D);
			stage.addActor(object2D);
		}
	}

	@Override
	public void updateObject(WorldObject object) {
		Object2D object2D = null;
		for (Object2D objectX : attachedActors) {
			if (objectX.getWorldObject() == object) {
				object2D = objectX;
				break;
			}
		}
		if (object2D != null)
			updateObject2D(object2D);
	}
	
	
	

	public void surfaceAssist(Object2D object2D) {
		ArrayList<Vector2> criticalPoints = new ArrayList<Vector2>();
		ArrayList<Vector2> corners = object2D.getRotatedVertices();
		for (Object2D other : attachedActors) {
			if (other == object2D)
				continue;
			criticalPoints.addAll(other.getRotatedVertices());
		}
		Vector2 translation = null;
		for (Vector2 corner : corners) {
			for (Vector2 otherCorner : criticalPoints) {
				Vector2 tmp = otherCorner.cpy().sub(corner);
				if (translation == null || tmp.len2() < translation.len2())
					translation = tmp;
			}
		}
		if (translation != null) {
			
			float fiveCm = 0.05f * getScale();
			
			
			if (translation.len2() > fiveCm * fiveCm) {
				Vector2 transX = translation.cpy().scl(1, 0);
				Vector2 transY = translation.cpy().scl(0, 1);
				translation.set(transX.len2() < transY.len2() ? transX : transY);
			}
			if (translation.len2() < 1000000) {
				object2D.setPosition(object2D.getX() + translation.x, object2D.getY() + translation.y);
				updateWorldObject(object2D);
			}
		}
	}

	public void fitToPlacebySides(Object2D object2D, Array<Object2D> brothers) {
		if(object2D==null ||brothers==null || brothers.isEmpty()) {
			return;
		}
		Object2D leftbrother = getClosestBySides(object2D, brothers, true);
		Object2D rightbrother = getClosestBySides(object2D, brothers, false);
		float start = leftbrother != null ? leftbrother.getX() + leftbrother.getWidth() : 0;
		float end = rightbrother != null ? rightbrother.getX() : stage.getWidth();
		float width = ((float) (Math.round(((end - start) / getScale()) * 1000))) / 1000;
		if (width > 0.017 && width < 1.5) {
			if (updateworldObject(object2D, width)) {
				object2D.setWidth(end - start);
			}
			object2D.setX(start);
		}
		updateWorldObject(object2D);
	}

	public void fitToPlacebySidesCousins(Object2D object2D, Array<Object2D> brothers, boolean isleft,
			boolean updateWidth) {
		float start = 0;
		float end = stage.getWidth();
		if (isleft) {
			Object2D leftbrother = getClosestBySides(object2D, brothers, true);
			Object2D rightcousin = null;
			if (getReference() != null && object2D != getReference()) {
				rightcousin = getReference();
			} else {
				rightcousin = getClosestCousinBySides(object2D, brothers, false);
			}
			start = leftbrother != null ? leftbrother.getX() + leftbrother.getWidth() : 0;
			end = rightcousin != null ? rightcousin.getX() : stage.getWidth();
		} else {

			//
			Object2D leftcousin = null;
			if (getReference() != null && object2D != getReference()) {
				leftcousin = getReference();
			} else {
				leftcousin = getClosestCousinBySides(object2D, brothers, true);
			}
			Object2D rightbrother = getClosestBySides(object2D, brothers, false);
			start = leftcousin != null ? leftcousin.getX() + leftcousin.getWidth() : 0;
			end = rightbrother != null ? rightbrother.getX() : stage.getWidth();
		}

		float width = ((float) (Math.round(((end - start) / getScale()) * 1000))) / 1000;
		if (width > 0.017 && width < 1.5 && updateWidth) {
			if (updateworldObject(object2D, width)) {
				object2D.setWidth(end - start);
			}
			object2D.setX(start);
		} else {
			if (!isleft) {
				object2D.setX(start);
			} else {
				object2D.setX(end - object2D.getWidth());
			}

		}

	}

	public void fitToPlacebyCousin(Object2D object2D, Array<Object2D> brothers) {
		float start = 0;
		float end = stage.getWidth();
		Object2D cousin = null;
		if (getReference() != null && object2D != getReference()) {
			cousin = getReference();
		} else {
			cousin = getClosestCousin(object2D, brothers);
		}

		start = cousin != null ? cousin.getX() : 0;
		end = cousin != null ? cousin.getX() + cousin.getWidth() : stage.getWidth();

		float width = cousin != null ? cousin.getWorldObject().getRealWorldDimension().x
				: ((float) (Math.round(((end - start) / getScale()) * 1000))) / 1000;

		if (width > 0.017 && width < 1.5) {
			if (updateworldObject(object2D, width)) {
				object2D.setWidth(end - start);
			}
			object2D.setX(start);
		}
		updateWorldObject(object2D);

	}

	public void fitToPlace(Object2D object2D, Array<Object2D> brothers) {
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}
			//
			float xStart = object2D.getX();
			float xEnd = object2D.getX() + object2D.getWidth();

			float yStart = object2D.getY();
			float yEnd = object2D.getY() + object2D.getHeight();

			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();

			//
			Intervale yint = new Intervale(yStart, true, yEnd, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale Yintersection = yint.getintersection(yintObj);
			//
			if (Yintersection == null || Yintersection.isPoint()) {
				continue;
			}

			//
			Intervale xint = new Intervale(xStart, true, xEnd, true);
			Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
			Intervale Xintersection = xint.getintersection(xintObj);
			//
			//
			if (Xintersection == null || Xintersection.isPoint()) {
				continue;
			} else {
				float width = ((float) (Math
						.round(((float) (object2D.getWidth() - Xintersection.getlong()) / getScale()) * 1000))) / 1000;

				if (updateworldObject(object2D, width)) {
					object2D.setWidth((float) (object2D.getWidth() - Xintersection.getlong()));
				}

				if (xStart == Xintersection.getMininter()) {
					object2D.setX(xObjend);

				}
				break;
			}

		}
		if (object2D.getX() + object2D.getWidth() > stage.getWidth()) {
			float width = ((float) (Math.round(((float) (stage.getWidth() - object2D.getX()) / getScale()) * 1000))) / 1000;

			if (updateworldObject(object2D, width)) {
				object2D.setWidth((float) (stage.getWidth() - object2D.getX()));
			}
		}
		if (object2D.getX() < 0) {
			float width = ((float) (Math.round(((float) (object2D.getWidth() + object2D.getX()) / getScale()) * 1000)))
					/ 1000;

			if (updateworldObject(object2D, width)) {
				object2D.setWidth((float) (object2D.getWidth() + object2D.getX()));
			}

			object2D.setX(0);
		}
		updateWorldObject(object2D);

	}

	public boolean updateworldObject(Object2D object2D, float width) {
		if (width < 0.005) {
			return false;
		}
		if (object2D.getWorldObject().getType().equals(ObjectType.DEFINED)) {
			KitchenElement element = (KitchenElement) object2D.getWorldObject();
			MechanicPublicParam paramL;
			try {
				paramL = element.getMechanicDesign().getPublicParam("global.l");
				if (object2D.getWorldObject().activeWidth == true) {
					String caissonType = element.getDesignObject().getDesignCaissonType();
					if (caissonType.contentEquals("BAS_COINS_L") || caissonType.contentEquals("HAUT_COINS_L")) {
						paramL = element.getMechanicDesign().getPublicParam("global.largeur");

					} else {
						paramL = element.getMechanicDesign().getPublicParam("global.p");
					}
				}
				if (paramL != null) {
					paramL.setDefaultvalue(String.valueOf((int) (width * 1000)));
					Space3DFree space = ((Space3DFree) element.getDesignObject());
					space.update();
					element.setRequireRefrech(true);
					return true;
				}
			} catch (Exception e) {

				e.printStackTrace();
				return false;

			}
		} else {
			object2D.getWorldObject().getRealWorldDimension().x = width;

			return true;

		}
		return false;
	}

	public void findPlaceByPushSelfX(Object2D object2D, Array<Object2D> brothers) {
		boolean valid = false;
		boolean isleft = true;
		whil: while (!valid) {
			valid = true;
			for (Object2D objectX : brothers) {
				if (objectX.equals(object2D)) {
					continue;
				}
				//
				float xStart = object2D.getX();
				float xEnd = object2D.getX() + object2D.getWidth();

				float yStart = object2D.getY();
				float yEnd = object2D.getY() + object2D.getHeight();

				float xObjstart = objectX.getX();
				float xObjend = objectX.getX() + objectX.getWidth();

				float yObjstart = objectX.getY();
				float yObjend = objectX.getY() + objectX.getHeight();

				//
				Intervale yint = new Intervale(yStart, true, yEnd, true);
				Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
				Intervale Yintersection = yint.getintersection(yintObj);
				//
				if (Yintersection == null || Yintersection.isPoint()) {
					continue;
				}

				//
				Intervale xint = new Intervale(xStart, true, xEnd, true);
				Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
				Intervale Xintersection = xint.getintersection(xintObj);
				//
				//
				if (Xintersection == null || Xintersection.isPoint()) {
					continue;
				} else {
					valid = false;
					if (isleft) {
						object2D.setX(xObjend);
					} else {
						object2D.setX(xObjstart - object2D.getWidth());
					}
				}
				if (object2D.getX() + object2D.getWidth() > stage.getWidth()) {
					isleft = false;
					object2D.setX(stage.getWidth() - object2D.getWidth());
					valid = false;

				}
				if (object2D.getX() < 0) {
					valid = false;
					object2D.setX(0);
					break whil;
				}
			}
		}

		updateWorldObject(object2D);
	}

	public void findPlaceByPushBrothers(Object2D object2D, Array<Object2D> brothers) {
		for (int i = 0; i < brothers.size; i++) {
			Object2D objectX = brothers.get(i);
			if (objectX.equals(object2D)) {
				continue;
			}
			//
			float xStart = object2D.getX();
			float xEnd = object2D.getX() + object2D.getWidth();

			float yStart = object2D.getY();
			float yEnd = object2D.getY() + object2D.getHeight();

			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();

			//
			Intervale yint = new Intervale(yStart, true, yEnd, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale Yintersection = yint.getintersection(yintObj);
			//
			if (Yintersection == null || Yintersection.isPoint()) {
				continue;
			}

			//
			Intervale xint = new Intervale(xStart, true, xEnd, true);
			Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
			Intervale Xintersection = xint.getintersection(xintObj);
			//
			//
			if (Xintersection == null || Xintersection.isPoint()) {
				continue;
			} else {

				if (Xintersection.getMininter() == xStart) {
					objectX.setX(xStart - objectX.getWidth());
				} else {
					objectX.setX(xEnd);
				}
				try {
					findPlaceByPushBrothers(objectX, brothers);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

		}
		if (object2D.getX() + object2D.getWidth() > stage.getWidth()) {
			object2D.setX(stage.getWidth() - object2D.getWidth());
			fitToPlacebySides(object2D, brothers);
		}
		if (object2D.getX() < 0) {
			object2D.setX(0);
			fitToPlacebySides(object2D, brothers);
		}
	}

	public Object2D getClosest(Object2D object2D, Array<Object2D> brothers) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}
		float xstart = object2D.getX();
		float xend = object2D.getX() + object2D.getWidth();
		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		double longXinter = 0;
		double longYinter = 0;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}
			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();
			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection == null || intersection.isPoint()) {
				continue;
			}
			Intervale xint = new Intervale(xstart, true, xend, true);
			Intervale xintObj = new Intervale(xObjstart, true, xObjend, true);
			Intervale xIntersection = xint.getintersection(xintObj);
			double longXinterx = xIntersection == null ? 0 : xIntersection.getlong();
			final float a = xstart - xObjend;
			final float b = ystart - yObjstart;

			final float c = xend - xObjstart;
			final float d = ystart - yObjstart;

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			final float g = xstart - xObjstart;

//			double disttoLeft =Math.sqrt(a * a + b * b );
//			double disttoright =Math.sqrt(c * c + d * d );
			double distbyOrigin = Math.sqrt(e * e + f * f);
//			double distbystart =Math.sqrt(g * g + b * b );

//			if(disttoLeft <distance) {
//				closest=objectX;
//				distance=(float) disttoLeft;
//			}
//			if( disttoright<distance) {
//				closest=objectX;
//				distance=(float) disttoright;
//			}
			if (distbyOrigin <= distance && longXinter == 0) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}
			float distbyX = Math.abs(Math.abs(e) - object2D.getWidth() / 2 - objectX.getWidth() / 2);
			if (distbyX < distance && longXinter == 0) {
				closest = objectX;
				distance = distbyX;
			}
			if (longXinterx > longXinter) {
				closest = objectX;
				longXinter = longXinterx;
				distance = (float) longXinterx;

			}

		}
		return closest;
	}

	public Object2D getClosestCousin(Object2D object2D, Array<Object2D> brothers) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}

		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection != null && !intersection.isPoint()) {
				continue;
			}

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			double distbyOrigin = Math.sqrt(e * e + f * f);

			if (distbyOrigin <= distance) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}

	public Object2D getClosestBySides(Object2D object2D, Array<Object2D> brothers, boolean isleft) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}
		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xstart = object2D.getX();
		float xend = object2D.getX() + object2D.getWidth();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection == null || intersection.isPoint()) {
				continue;
			}

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			double distbyOrigin = Math.sqrt(e * e + f * f);

			if (((isleft && xOrigin > xObjOrigin) || (!isleft && xOrigin < xObjOrigin)) && (distbyOrigin <= distance)) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}

	public Object2D getClosestCousinBySides(Object2D object2D, Array<Object2D> brothers, boolean isleft) {
		if (object2D == null || brothers == null || brothers.size < 1) {
			return null;
		}
		float ystart = object2D.getY();
		float yend = object2D.getY() + object2D.getHeight();
		//
		float xstart = object2D.getX();
		float xend = object2D.getX() + object2D.getWidth();
		//
		float xOrigin = object2D.getX() + object2D.getWidth() / 2;
		float YOrigin = object2D.getY() + object2D.getHeight() / 2;
		//
		Object2D closest = null;
		float distance = 10000000;
		for (Object2D objectX : brothers) {
			if (objectX.equals(object2D)) {
				continue;
			}

			float yObjstart = objectX.getY();
			float yObjend = objectX.getY() + objectX.getHeight();
			//
			float xObjstart = objectX.getX();
			float xObjend = objectX.getX() + objectX.getWidth();
			//
			float xObjOrigin = objectX.getX() + objectX.getWidth() / 2;
			float YObjOrigin = objectX.getY() + objectX.getHeight() / 2;
			//
			Intervale yint = new Intervale(ystart, true, yend, true);
			Intervale yintObj = new Intervale(yObjstart, true, yObjend, true);
			Intervale intersection = yint.getintersection(yintObj);
			if (intersection != null && !intersection.isPoint()) {
				continue;
			}

			final float e = xOrigin - xObjOrigin;
			final float f = YOrigin - YObjOrigin;

			double distbyOrigin = Math.sqrt(e * e + f * f);

			if (((isleft && xOrigin >= xObjOrigin) || (!isleft && xOrigin <= xObjOrigin))
					&& (distbyOrigin <= distance)) {
				closest = objectX;
				distance = (float) distbyOrigin;
			}

		}
		return closest;
	}


	public ChangeCommandController getChangeCommandController() {
		return changeCommandController;
	}

	public void setChangeCommandController(ChangeCommandController changeCommandController) {
		this.changeCommandController = changeCommandController;
	}

	public Surface getSurface() {
		return surface;
	}

	@Override
	public Object2D getObject(WorldObject worldObject) {
		Object2D object2D = null;
		for (Object2D actor : attachedActors) {
			if(actor.getWorldObject() == worldObject) {
				object2D = actor;
				break;
			}
		}
		return object2D;
	}

	@Override
	public Stage getUIStage() {
		return this.uiStage;
	}

	@Override
	public float[] getScales() {
		return new float[] { 1 / getScale(), 1 / getScale() };
	}

	public InputMultiplexer getInputMultiplexer() {
		return inputMultiplexer;
	}

	public void setInputMultiplexer(InputMultiplexer inputMultiplexer) {
		this.inputMultiplexer = inputMultiplexer;
	}

	@Override
	public void rectifyPosition(Object2D object2D) {

		if (object2D.getWorldObject().isConstraint()) {
			String role = object2D.getWorldObject().getModel().getInfo().getProperties().getProperty("role", "");
			Vector3 center = new Vector3(object2D.getAbsoluteOrigin(), 0).mul(surface.getSurfaceToWorldTransform());
			if (role.equals("door")) {
				ProjectManager.getManager().getCurrentScene().addDoor(object2D.getWorldObject(), center);
			} else {
				ProjectManager.getManager().getCurrentScene().addConstraint(object2D.getWorldObject(), center);
			}
		} else {
			surfaceAssist(object2D);
		}
	}

	@Override
	public void clear() {
		getUIStage().clear();
	}

	@Override
	public void addActor(Object actor) {

	}

	@Override
	public void removeActor(Object actor) {
		if (actor instanceof WorldObject) {
			Object2D object2D = (Object2D) getObject((WorldObject) actor);
			if (object2D != null) {
				this.attachedActors.removeValue(object2D, true);
				wallSpaceManager.removeActor(object2D);
				object2D.delete();
			}

		}
	}

	@Override
	public void handle(Event event) {
		if (!isHandleEvent())
			return;
		SceneEvent sceneEvent = SceneEvent.valueOf(event.getTopic());
		switch (sceneEvent) {
		case DELETE_OBJECT:
			removeActor(event.getData());
			break;
		case OBJECT_DROP:
			objectDropped((Map<String, Object>) event.getData());
			break;
		case OBJECT_CHANGED:
			updateObject((WorldObject) event.getData());
			break;
		case OBJECT_SELECTED:
			ObjectMenuList.getInstance(null).remove();
			break;
		case DISPLAY_ACTIONS_MENU:
			displayRightClickMenu(event.getData());
			break;
		case SHOW_OBJECT:
			showElement((WorldObject) event.getData());
			break;
		case VOID_CLICK:
			GroupSelection.getInstance().clearSelection();
			ObjectMenuList.getInstance(null).remove();
			break;
		case INVOKE_MEASURER:
			invokeMeasurer();
			break;
		case RESET_CAMERA:
			centerCamera();
			break;
		default:
			break;
		}
	}
	
	private void displayRightClickMenu(Object data) {
		if (ProjectManager.getInstance().getCurrentProject() == null)
			return;
		HashMap map = (HashMap) data;
		List<ActionItem> actions = (List<ActionItem>) map.get("actions");
		Vector3 location = (Vector3) map.getOrDefault("location", new Vector3());
		Vector3 stageLocation = location.mul(surface.getWorldToSurfaceTransform());
		Vector2 screenCoords = stage.stageToScreenCoordinates(new Vector2(stageLocation.x, stageLocation.y));
		Vector2 uiStageLocation = uiStage.screenToStageCoordinates(screenCoords);
		ObjectMenuList menu = ObjectMenuList.getInstance(actions);
		float y = uiStageLocation.y - menu.getHeight();
		if (y < 0)
			y += menu.getHeight();
		menu.setPosition(uiStageLocation.x, y);
		uiStage .addActor(menu);
		uiStage.setKeyboardFocus(menu);
		uiStage.setScrollFocus(menu);
	}

	public void objectDropped(Map<String, Object> data) {
		Object object = data.get("object");
		Vector2 location = (Vector2) data.getOrDefault("location", new Vector2(600, 600));
		getStage().screenToStageCoordinates(location);
		dropActor(object, location.x, location.y);
	}
	
	private void invokeMeasurer() {
		if(!stage.getActors().contains(MeasuresTaker.getInstance(), true)) {
			stage.addActor(MeasuresTaker.getInstance());
		}
		calculateCriticalPoints();
		MeasuresTaker.getInstance().setReferencePoints(referencePoints);
		MeasuresTaker.getInstance().begin();
		
	}

	private void calculateCriticalPoints() {
		referencePoints.clear();
		for (Object2D other : attachedActors) {
			referencePoints.addAll(other.getRotatedVertices());
		}
	}

	public void dispose() {
		attachedActors.clear();
		stage.dispose();
	}

	public Object2D getReference() {
		return reference;
	}

	public void setReference(Object2D reference) {
		this.reference = reference;
	}
	
	

	public boolean isHandleEvent() {
		return handleEvent;
	}

	public void setHandleEvent(boolean handleEvent) {
		this.handleEvent = handleEvent;
	}

	@Override
	public void reloadActor(WorldObject... worldObject) {

	}
	
	@Override
	public Stage getStage() {
		return stage;
	}

}
