package gdxapp.screens.ObjectEditor.uicomponents;


import java.io.File;
import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.Texture.TextureFilter;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton.ImageButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import dressing.config.WorkspaceConfiguration;
import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.assets.AssetsTextures;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.ObjectEditor.EditorSkin;


public class RightBar extends Table{

	private final ArrayList<Model3DWidget> models = new  ArrayList<Model3DWidget>();
	
	ImageButton upBtn;
	ImageButton downBtn;
	
	Table container;
	
	ScrollPane scrollPane;
	
	public RightBar() {
		createWidgets();
		createContents();
	}

	private void createWidgets() {
		models.add(new Model3DWidget("C:/ProgramData/supercad.2.1.0/assets/models/spark led/model.g3dj", "C:/ProgramData/supercad.2.1.0/assets/models/spark led/preview.png" ));
	}

	private void createContents() {
		Texture downtext = new Texture(Gdx.files.absolute(WorkspaceConfiguration.ICONS + File.separator + "double-down-36.png"));
		Texture uptext = new Texture(Gdx.files.absolute(WorkspaceConfiguration.ICONS + File.separator + "double-up-36.png"));

		ImageButtonStyle upStyle = EditorSkin.createImgBtnStyle(uptext);
		ImageButtonStyle downStyle = EditorSkin.createImgBtnStyle(downtext);
		
		upBtn = new ImageButton(upStyle);
		downBtn = new ImageButton(downStyle);
		
		container = new Table();
		Table table = new Table();
		for(Model3DWidget model: models) {
			table.row();
			table.add(model);
		}		
		scrollPane = new ScrollPane(table, AssetsTextures.getInstance().getSkin());
		container.add(scrollPane).width(200).height(500).center();
		pad(10);
		add(upBtn).top();
		row();
		add(container).grow();
		row();
		add(downBtn).bottom();
		
	}
	
	public class Model3DWidget extends Table
	{
		Model model;
		String imageLblPath;
		Texture texture;
			
		ImageButton imgBtn;
		Label nameLbl;
		
		public Model3DWidget(String modelPath, String imagePath) {
			super();
			loadModel(modelPath);
			loadPreview(imagePath);
			
			createContents();
		}
		
		private void createContents() {
			ImageButtonStyle style = EditorSkin.createImgBtnStyle(texture);
			imgBtn = new ImageButton(style);
			imgBtn.addListener(new ClickListener() {
				@Override
				public void clicked(InputEvent event, float x, float y) {
					EventDriver.getDriver().deliverEvent(new Event(SceneEvent.INSERT_3D_MODEL.name(), model));
				}
			});
			add(imgBtn).width(150).height(150);
		}

		private void loadModel(String path) {
			AssetsTextures.getInstance().getAssetManager().load(path, Model.class);
			AssetsTextures.getInstance().getAssetManager().finishLoading();
			model = AssetsTextures.getInstance().getAssetManager().get(path, Model.class);
		}
		
		private void loadPreview(String path) {
			texture = new Texture(Gdx.files.absolute(path));
			texture.setFilter(TextureFilter.Linear, TextureFilter.Linear);
		}
	}
}
