package gdxapp.screens.ObjectEditor.uicomponents;

import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.assets.AssetsTextures;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.ObjectEditor.EditorSkin;

public class LeftBar extends Table{

	//layout components
	private ImageButton selectBtn;
	private ImageButton moveBtn;
	private ImageButton rotateBtn;
	private ImageButton scaleBtn;
	//modeling components
	private ImageButton cubeBtn;
	private ImageButton cylinderBtn;
	private ImageButton sphereBtn;

	


	public LeftBar() {
		super();
		createContents();
	}

	private void createContents() {
		
		selectBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.SELECT_STYLE));
		selectBtn.addListener(new ClickListener(){
            @Override
            public void clicked(InputEvent event, float x, float y) {
                Event eventX = new Event(SceneEvent.SELECT_OBJECT.name(), null);
                EventDriver.getDriver().deliverEvent(eventX);
            }
        });
	    moveBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.MOVE_STYLE));
	    moveBtn.addListener(new ClickListener(){
            @Override
            public void clicked(InputEvent event, float x, float y) {
                Event eventX = new Event(SceneEvent.MOVE_BTN_PRESSED.name(), null);
                EventDriver.getDriver().deliverEvent(eventX);
            }
        });
	    rotateBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.ROTATE_STYLE));
	    scaleBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.SCALE_STYLE));
	    
	    cubeBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.CUBE_STYLE));
	    cubeBtn.addListener(new ClickListener() {
			@Override
			public void clicked(InputEvent event, float x, float y) {
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.BUILD_CUBE.name(), null));
			}
	    });
	    
	    sphereBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.SPHERE_STYLE));	    
	    cylinderBtn = new ImageButton(EditorSkin.getSkin().getImageVtnStyle(EditorSkin.CYLINDER_STYLE));

	    setForLayout();
	    
	    
	}

	public void setForModeling() {
		clear();
		left();
	    row();
	    add(cubeBtn).width(32).height(32);
	    row();
	    add(sphereBtn).width(32).height(32);
	    row();
	    add(cylinderBtn).width(32).height(32);
	    row();
	}
	
	public void setForLayout() {
		clear();
		left();
	    row();
	    add(selectBtn).width(32).height(32);
	    row();
	    add(moveBtn).width(32).height(32);
	    row();
	    add(rotateBtn).width(32).height(32);
	    row();
	    add(scaleBtn).width(32).height(32);
	}

	
}
