package gdxapp.screens.ObjectEditor;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import gdxapp.object3d.Object3D;
import gdxapp.scenes.SceneEvent;

public class ObjectMover implements DrawableInputProcessor, EventHandler {
	
	public static Model model;
	
	private Object3D target;
	
	Vector3 tmp = new Vector3();
	
	private boolean enableDrag;
	
	float lastDepth;
	
	private final Vector2 lastClickLocation = new Vector2(Float.NaN, Float.NaN);
	
	private Vector3 elementaryTranslation;
	
	
	private final AxisSystem axisSystem = new AxisSystem();
	
	Camera camera;

	
	public ObjectMover(Camera camera) {
		this.camera = camera;
		subscribe(SceneEvent.OBJECT_SELECTED.name());
	}
	
	@Override
	public void draw(ModelBatch batch) {
		axisSystem.draw(batch);
	}
	
	
	@Override
	public boolean keyDown(int keycode) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyUp(int keycode) {
		return false;
	}

	@Override
	public boolean keyTyped(char character) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean touchDown(int screenX, int screenY, int pointer, int button) {
		if(button == Input.Buttons.LEFT) {
			lastClickLocation.set(screenX, screenY);
			enableDrag = true;
			return true;
		}
		enableDrag = false;
		return false;
		
	}

	@Override
	public boolean touchUp(int screenX, int screenY, int pointer, int button) {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public boolean touchDragged(int screenX, int screenY, int pointer) {
		if(enableDrag) {
			Vector3 v1 = camera.unproject(new Vector3(screenX, screenY, lastDepth));
			Vector3 v0 = camera.unproject(new Vector3(lastClickLocation, lastDepth));	
			Vector3 v = axisSystem.getTranslationAxis().cpy();
			float amount = v1.sub(v0).nor().dot(v)/10.0f;
			target.translate(v.scl(amount));
			axisSystem.setTransform(target.transform);
			return true;
		}
		
		return false;
	}

	@Override
	public boolean mouseMoved(int screenX, int screenY) {
		float z = ScreenUtilities.getDepthFromBuffer(screenX, Gdx.graphics.getHeight() - screenY);
		Vector3 realWorldPoint = camera.unproject(new Vector3(screenX, screenY, z));
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.MSG.name(), realWorldPoint.toString()));
		tmp.set(realWorldPoint);
		lastDepth = z;
		axisSystem.selectAxis(tmp);
		return false;
	}

	@Override
	public boolean scrolled(int amount) {
		// TODO Auto-generated method stub
		return false;
	}
	
	@Override
	public void handle(Event event) {
		SceneEvent eventX = SceneEvent.valueOf(event.getTopic());
		switch(eventX) {
		case OBJECT_SELECTED:
			handleSelection(event.getData());
			break;
		}
	}
	
	
	private void handleSelection(Object object) {
		if(object instanceof Object3D) {
			setTarget((Object3D) object);
		}
	}
	
	public Object3D getTarget() {
		return target;
	}

	public void setTarget(Object3D target) {
		this.target = target;
		axisSystem.setTransform(target.transform);
	}


	class AxisSystem{
		
		Object3D xAxis;
		Object3D yAxis;
		Object3D zAxis;
		
		private Object3D selectedAxis;
		
		public AxisSystem() {
			create();
		}
		
		public void setTransform(Matrix4 transform) {
			xAxis.transform.set(transform);
			xAxis.calculateProperties();
			yAxis.transform.set(transform);
			yAxis.calculateProperties();
			zAxis.transform.set(transform);
			zAxis.calculateProperties();
		}
		
		
		public void create() {
			int attr = VertexAttributes.Usage.Position;
			ModelBuilder modelBuilder = new ModelBuilder();
			Model xModel = modelBuilder.createArrow(0, 0, 0, 1, 0, 0, 0.1f, 0.3f, 50, GL20.GL_TRIANGLES,
					new Material(ColorAttribute.createDiffuse(Color.RED)), attr);
			Model yModel = modelBuilder.createArrow(0, 0, 0, 0, 1, 0, 0.1f, 0.3f, 50, GL20.GL_TRIANGLES,
					new Material(ColorAttribute.createDiffuse(Color.GREEN)), attr);
			Model zModel = modelBuilder.createArrow(0, 0, 0, 0, 0, 1, 0.1f, 0.3f, 50, GL20.GL_TRIANGLES,
							new Material(ColorAttribute.createDiffuse(Color.BLUE)), attr);
			xAxis = new Object3D(xModel);
			yAxis = new Object3D(yModel);
			zAxis = new Object3D(zModel);
		}
		
		public void draw(ModelBatch batch) {
			batch.getRenderContext().setDepthTest(GL20.GL_ALWAYS);
			if(selectedAxis != null) 
				selectedAxis.transform.scale(1.2f, 1.2f, 1.2f);
			batch.render(xAxis);
			batch.render(yAxis);
			batch.render(zAxis);
			if(selectedAxis != null) 
				selectedAxis.transform.scale(1.0f/1.2f, 1.0f/ 1.2f, 1.0f/1.2f);
		}
		
		Vector3 selectAxis(Vector3 point) {
			selectedAxis = null;
			if(xAxis.contains(point)) {
				selectedAxis = xAxis;
			}
			if(yAxis.contains(point)) {
				selectedAxis = yAxis;
			}
			if(zAxis.contains(point)) {
				selectedAxis = zAxis;
			}
			return getTranslationAxis();
		}

		public Vector3 getTranslationAxis() {
			if(selectedAxis == null)
				return Vector3.Zero;
			if(selectedAxis.equals(xAxis))
				return Vector3.X;
			if(selectedAxis.equals(yAxis))
				return Vector3.Y;
			return Vector3.Z;
			
		}
	}

}
